/**********************************************************************
* @file		main.c
* @brief	Gpio_LedBlinky Example Code tested on A31G22x StarterKit
* @version	1.00
* @date		22 July 2020
* @author	ABOV AE team
*
* Copyright(C) 2020, ABOV Semiconductor
* All rights reserved.
**********************************************************************/
#include "main_conf.h"
#include "TestCode_ADC_DmaP2P.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void DEBUG_MenuPrint(void);
void mainloop(void);
int main (void);

/* Private variables ---------------------------------------------------------*/
//static uint32_t MilliSec;

#ifdef _DEBUG_MSG
static const char Menu[] =
"************************************************\n\r"
"\t - MCU: A31G22x \n\r"
"\t - Core: ARM Cortex-M0+ \n\r"
"\t - Communicate via: USART10 - 38400 bps \n\r"
" ADC DMAC Peri-to-Peri Test \n\r"
"************************************************\n\r";
#endif

/* Public Function ------------------------------------------------------------*/
extern void Main_AdcPeri2Peri(void);


/**********************************************************************
 * @brief		 menu Print
 * @param[in]	None
 * @return 		None
 **********************************************************************/
void DEBUG_MenuPrint(void)
{
	#ifdef _DEBUG_MSG
	_DBG(Menu);
	#endif
}

/**********************************************************************
 * @brief		Main loop
 * @param[in]	None
 * @return	None
 **********************************************************************/
void mainloop(void)
{
	/*Configure menu prinf*/
	DEBUG_MenuPrint();
   
	/* Enable IRQ Interrupts */
	__enable_irq();
	
	while(1) {
		/*User Code start*/
		Main_AdcPeri2Peri();
	}
}

/**********************************************************************
 * @brief		Main program
 * @param[in]	None
 * @return	None
 **********************************************************************/
int main (void)
{
	 /* Initialize all port */
	Port_Init();  

	/* Configure the system clock to HSE 8 MHz */
	SystemClock_Config();
	
	/* Initialize Debug frame work through initializing UART port  */
    #ifdef _DEBUG_MSG    
    debug_frmwrk_init();
    #endif	
    
	/* Infinite loop */
	mainloop();

	return (0);
}

/* --------------------------------- End Of File ------------------------------ */
