/*!
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2024-07-31
 *
 * @attention
 *
 *  Copyright (C) 2024 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

#include "Board_APM32E030_TINY.h"
#include "stdio.h"
#include "stdint.h"
#include "apm32e030_gpio.h"
#include "apm32e030_misc.h"
#include "apm32e030_eint.h"
#include "apm32e030_rcm.h"

/* Delay */
void Delay(uint32_t nTime);
/* Declared identifier TimingDelay*/
static uint32_t TimingDelay;

/*!
 * @brief       Main program
 *
 * @param       None
 *
 * @retval      None
 *
 * @note
 */
int main(void)
{
    APM_TINY_LEDInit(LED2);
    APM_TINY_LEDInit(LED3);

    APM_TINY_LEDOff(LED2);

    /** Configure the SysTick to generate a time base equal to 1 ms*/
    if (SysTick_Config(SystemCoreClock / 1000))
    {
        while (1);
    }

    while (1)
    {

        APM_TINY_LEDToggle(LED2);
        /** Delay 1 s*/
        Delay(1000);

        APM_TINY_LEDToggle(LED3);
        /** Delay 1 s*/
        Delay(1000);

    }
}

/*!
 * @brief       Delay
 *
 * @param       None
 *
 * @retval      None
 *
 * @note
 */
void Delay(uint32_t nTime)
{
    TimingDelay = nTime;

    while (TimingDelay != 0);
}

/*!
 * @brief       Enters Interrupt when TimingDelay's value changes
 *
 * @param       None
 *
 * @retval      None
 *
 * @note
 */
void TimingDelay_Decrement(void)
{
    if (TimingDelay != 0x00)
    {
        TimingDelay--;
    }
}
