/*
 *   Copyright (C) 2025 Alif Semiconductor - All Rights Reserved.
 *   Use, distribution and modification of this code is permitted under the
 *   terms stated in the Alif Semiconductor Software License Agreement
 *
 *   You should have received a copy of the Alif Semiconductor Software
 *   License Agreement with this file. If not, please write to:
 *   https://alifsemi.com/contact/, or visit: https://alifsemi.com/license/
 */
/******************************************************************************
 * @file     board_defs.h
 * @author  	Auto generated by Conductor Tool https://conductor.alifsemi.com/
 * @version  v1.0.1
 * @date     2025-4-11
 * @brief    Board info/settings for "AI/ML AppKit Gen 2 (AK-E7-AIML)" project
 *           with AE722F80F55D5LS
 * @bug      None.
 * @note     To modify this file manually, take care to modify pins.h and gpios.h
 *           accordingly when required.
 ******************************************************************************/
//-------- <<< Use Configuration Wizard in Context Menu >>> -------------------

// <h> Board peripheral instances
// <e> CSI module enabled flag
#define BOARD_CSI_ENABLED                    1
// <e> "ARX3AO" on CSI presence flag
#define BOARD_CSI_ARX3AO_PRESENT             1
// </e>
// </e>

// <e> DSI module enabled flag
#define BOARD_DSI_ENABLED                    1
// <e> "ILI9806" on DSI presence flag
#define BOARD_DSI_ILI9806_PRESENT            1
// </e>
// </e>

// <o> "WM8904 CODEC" I2C instance number <0-3>
#define BOARD_WM8904_CODEC_I2C_INSTANCE      0

// <o> "Camera" I2C instance number <0-3>
#define BOARD_CAMERA_I2C_INSTANCE            1

// <o> "GT911 Touchscreen" I2C instance number <0-3>
#define BOARD_GT911_TOUCHSCREEN_I2C_INSTANCE 1

// <o> "WM8904 Output" I2S instance number <0-3>
#define BOARD_WM8904_OUTPUT_I2S_INSTANCE     2

// <o> "MIC Input" I2S instance number <0-3>
#define BOARD_MIC_INPUT_I2S_INSTANCE         3

// <e> I3C module enabled flag
#define BOARD_I3C_ENABLED                    1
// <e> "ICM42670 IMU" on I3C presence flag
#define BOARD_I3C_ICM42670_IMU_PRESENT       1
// </e>
// <e> "BMI323 IMU" on I3C presence flag
#define BOARD_I3C_BMI323_IMU_PRESENT         1
// </e>
// </e>

// <e> JTAG module enabled flag
#define BOARD_JTAG_ENABLED                   1
// </e>

// <e> LPCPI module enabled flag
#define BOARD_LPCPI_ENABLED                  1
// </e>

// <e> LPGPIO module enabled flag
#define BOARD_LPGPIO_ENABLED                 1
// </e>

// <e> MISC module enabled flag
#define BOARD_MISC_ENABLED                   1
// </e>

// <o> "ISSI RAM" OSPI instance number <0-1>
#define BOARD_ISSI_RAM_OSPI_INSTANCE         0

// <o> "ISSI FLASH" OSPI instance number <0-1>
#define BOARD_ISSI_FLASH_OSPI_INSTANCE       1

// <e> PDM module enabled flag
#define BOARD_PDM_ENABLED                    1
// <e> "PDM MIC" on PDM presence flag
#define BOARD_PDM_PDM_MIC_PRESENT            1
// </e>
// </e>

// <e> SEUART module enabled flag
#define BOARD_SEUART_ENABLED                 1
// </e>

// <o> "WE310F5 WIFI BLE" SPI instance number <0-3>
#define BOARD_WE310F5_WIFI_BLE_SPI_INSTANCE  3

// <o> "WE310F5 WIFI BLE" UART instance number <0-7>
#define BOARD_WE310F5_WIFI_BLE_UART_INSTANCE 1

// <o> "UARTA" UART instance number <0-7>
#define BOARD_UARTA_UART_INSTANCE            2

// <o> "UARTB" UART instance number <0-7>
#define BOARD_UARTB_UART_INSTANCE            4

// <e> USB module enabled flag
#define BOARD_USB_ENABLED                    1
// <e> "Device Role" on USB presence flag
#define BOARD_USB_DEVICE_ROLE_PRESENT        1
// </e>
// </e>

// </h>
// <h> Miscellaneous
// <o> Onboard LEDs
// <i> Sets the #define BOARD_LED_COUNT in the board_def.h file exported from the Conductor tool.
#define BOARD_LED_COUNT                      0

// <o> Onboard RGB LEDs
// <i> Sets the #define BOARD_LEDRGB_COUNT in the board_def.h file exported from the Conductor tool.
#define BOARD_LEDRGB_COUNT                   2

// <o> Onboard Push-buttons
// <i> Sets the #define BOARD_BUTTON_COUNT in the board_def.h file exported from the Conductor tool.
#define BOARD_BUTTON_COUNT                   5

// <o> Onboard Config Switches or Jumpers
// <i> Sets the #define BOARD_CONFIG_JUMPER_COUNT in the board_def.h file exported from the
// Conductor tool.
#define BOARD_CONFIG_JUMPER_COUNT            0

// <o> Onboard Switching Devices
// <i> Sets the #define BOARD_SWITCH_OUTPUT_COUNT in the board_def.h file exported from the
// Conductor tool. These include relays, solid state relays, transistors, optocopulers, etc.
#define BOARD_SWITCH_OUTPUT_COUNT            0

// <o> OSPI0 Bus Speed
// <i> Selects OSPI0 bus speed for a 200-MHz (default) HCLK. For 100 MHz and lower HCLK clock
// speeds, some values are either not possible, either rounded to the closest possible value in
// hardware.
#define BOARD_OSPI0_BUS_SPEED                50000000

// <o> OSPI1 Bus Speed
// <i> Selects OSPI1 bus speed for a 200-MHz (default) HCLK. For 100 MHz and lower HCLK clock
// speeds, some values are either not possible, either rounded to the closest possible value in
// hardware.
#define BOARD_OSPI1_BUS_SPEED                100000000

// <o> OSPI0 onboard memory size
#define BOARD_OSPI0_MEM_SIZE                 33554432

// <o> OSPI1 onboard memory size
#define BOARD_OSPI1_MEM_SIZE                 67108864

// </h>
// <h> GPIO port/pin numbers, analog instance/input numbers, etc.
// <o> FLEX IO pins supply voltage <0=> 3.3 V <1=> 1.8 V
// <i> Make sure this setting corresponds to the VDD_IO_FLEX pin voltage. If the VDD_IO_FLEX pin is
// connected to a 3.3 V supply, do not change the value of the GPIO_CNTL register to command 1.8-V
// operation mode!
#define FLEX_IO_VOLTAGE_1V8                  1

// <o> "TOUCH_RESET" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_TOUCH_RESET_GPIO_PORT          4
// <o> "TOUCH_RESET" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_TOUCH_RESET_GPIO_PIN           0

// <o> "PDM_MIC" PDM data/clock pair number <0=> D0/C0 <1=> D1/C1 <2=> D2/C2 <3=> D3/C3
#define BOARD_PDM_MIC_PDM_INPUT              2

// <o> "LCD_BACKLIGHT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LCD_BACKLIGHT_GPIO_PORT        6
// <o> "LCD_BACKLIGHT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_LCD_BACKLIGHT_GPIO_PIN         1

// <o> "LEDRGB1_R" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LEDRGB1_R_GPIO_PORT            6
// <o> "LEDRGB1_R" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LEDRGB1_R_GPIO_PIN             2

// <o> "LEDRGB1_G" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LEDRGB1_G_GPIO_PORT            6
// <o> "LEDRGB1_G" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LEDRGB1_G_GPIO_PIN             5

// <o> "LEDRGB1_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LEDRGB1_B_GPIO_PORT            6
// <o> "LEDRGB1_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LEDRGB1_B_GPIO_PIN             6

// <o> "LEDRGB0_G" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LEDRGB0_G_GPIO_PORT            7
// <o> "LEDRGB0_G" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LEDRGB0_G_GPIO_PIN             4

// <o> "CAMERA_POWER" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAMERA_POWER_GPIO_PORT         7
// <o> "CAMERA_POWER" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CAMERA_POWER_GPIO_PIN          5

// <o> "ICM_IMU_IRQ" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_ICM_IMU_IRQ_GPIO_PORT          8
// <o> "ICM_IMU_IRQ" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_ICM_IMU_IRQ_GPIO_PIN           4

// <o> "BMI_IMU_IRQ" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_BMI_IMU_IRQ_GPIO_PORT          8
// <o> "BMI_IMU_IRQ" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_BMI_IMU_IRQ_GPIO_PIN           5

// <o> "CAMERA_RESET" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAMERA_RESET_GPIO_PORT         9
// <o> "CAMERA_RESET" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CAMERA_RESET_GPIO_PIN          1

// <o> "CAMERA_FLASH" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAMERA_FLASH_GPIO_PORT         9
// <o> "CAMERA_FLASH" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CAMERA_FLASH_GPIO_PIN          2

// <o> "CAMERA_TRIGGER" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAMERA_TRIGGER_GPIO_PORT       9
// <o> "CAMERA_TRIGGER" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CAMERA_TRIGGER_GPIO_PIN        3

// <o> "TOUCH_INT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_TOUCH_INT_GPIO_PORT            9
// <o> "TOUCH_INT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_TOUCH_INT_GPIO_PIN             4

// <o> "LEDRGB0_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LEDRGB0_B_GPIO_PORT            12
// <o> "LEDRGB0_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LEDRGB0_B_GPIO_PIN             0

// <o> "LEDRGB0_R" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LEDRGB0_R_GPIO_PORT            12
// <o> "LEDRGB0_R" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LEDRGB0_R_GPIO_PIN             3

// <o> "WIFI_ENABLE" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_WIFI_ENABLE_GPIO_PORT          13
// <o> "WIFI_ENABLE" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_WIFI_ENABLE_GPIO_PIN           0

// <o> "WIFI_WAKE" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_WIFI_WAKE_GPIO_PORT            13
// <o> "WIFI_WAKE" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_WIFI_WAKE_GPIO_PIN             1

// <o> "WIFI_RESET" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_WIFI_RESET_GPIO_PORT           13
// <o> "WIFI_RESET" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_WIFI_RESET_GPIO_PIN            2

// <o> "WIFI_IRQ" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_WIFI_IRQ_GPIO_PORT             13
// <o> "WIFI_IRQ" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_WIFI_IRQ_GPIO_PIN              3

// <o> "CODEC_IRQ" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CODEC_IRQ_GPIO_PORT            14
// <o> "CODEC_IRQ" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CODEC_IRQ_GPIO_PIN             2

// <o> "JOY_SW_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_JOY_SW_A_GPIO_PORT             15
// <o> "JOY_SW_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_JOY_SW_A_GPIO_PIN              0

// <o> "JOY_SW_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_JOY_SW_B_GPIO_PORT             15
// <o> "JOY_SW_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_JOY_SW_B_GPIO_PIN              1

// <o> "JOY_SW_C" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_JOY_SW_C_GPIO_PORT             15
// <o> "JOY_SW_C" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_JOY_SW_C_GPIO_PIN              2

// <o> "JOY_SW_D" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_JOY_SW_D_GPIO_PORT             15
// <o> "JOY_SW_D" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_JOY_SW_D_GPIO_PIN              3

// <o> "JOY_SW_CENTER" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_JOY_SW_CENTER_GPIO_PORT        15
// <o> "JOY_SW_CENTER" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_JOY_SW_CENTER_GPIO_PIN         4

// <o> "LCD_RESET" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LCD_RESET_GPIO_PORT            15
// <o> "LCD_RESET" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LCD_RESET_GPIO_PIN             5

// <o> "OSPI0_RESET" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_OSPI0_RESET_GPIO_PORT          15
// <o> "OSPI0_RESET" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_OSPI0_RESET_GPIO_PIN           6

// <o> "OSPI1_RESET" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_OSPI1_RESET_GPIO_PORT          15
// <o> "OSPI1_RESET" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_OSPI1_RESET_GPIO_PIN           7

// P0_0 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_0_ADC12_INSTANCE            0
// P0_0 ADC12 input number (Do Not Modify!)
#define BOARD_P0_0_ADC12_INPUT               0

// P0_0 ADC24 positive input number (Do Not Modify!)
#define BOARD_P0_0_ADC24_POSITIVE_INPUT      0

// P0_0 CMP instance number (Do Not Modify!)
#define BOARD_P0_0_CMP_INSTANCE              0
// P0_0 CMP input number (Do Not Modify!)
#define BOARD_P0_0_CMP_INPUT                 0

// P0_1 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_1_ADC12_INSTANCE            0
// P0_1 ADC12 input number (Do Not Modify!)
#define BOARD_P0_1_ADC12_INPUT               1

// P0_1 ADC24 positive input number (Do Not Modify!)
#define BOARD_P0_1_ADC24_POSITIVE_INPUT      1

// P0_1 CMP instance number (Do Not Modify!)
#define BOARD_P0_1_CMP_INSTANCE              1
// P0_1 CMP input number (Do Not Modify!)
#define BOARD_P0_1_CMP_INPUT                 0

// P0_2 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_2_ADC12_INSTANCE            0
// P0_2 ADC12 input number (Do Not Modify!)
#define BOARD_P0_2_ADC12_INPUT               2

// P0_2 ADC24 positive input number (Do Not Modify!)
#define BOARD_P0_2_ADC24_POSITIVE_INPUT      2

// P0_2 CMP instance number (Do Not Modify!)
#define BOARD_P0_2_CMP_INSTANCE              2
// P0_2 CMP input number (Do Not Modify!)
#define BOARD_P0_2_CMP_INPUT                 0

// P0_3 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_3_ADC12_INSTANCE            0
// P0_3 ADC12 input number (Do Not Modify!)
#define BOARD_P0_3_ADC12_INPUT               3

// P0_3 ADC24 positive input number (Do Not Modify!)
#define BOARD_P0_3_ADC24_POSITIVE_INPUT      3

// P0_3 CMP instance number (Do Not Modify!)
#define BOARD_P0_3_CMP_INSTANCE              3
// P0_3 CMP input number (Do Not Modify!)
#define BOARD_P0_3_CMP_INPUT                 0

// P0_4 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_4_ADC12_INSTANCE            0
// P0_4 ADC12 input number (Do Not Modify!)
#define BOARD_P0_4_ADC12_INPUT               4

// P0_4 ADC24 negative input number (Do Not Modify!)
#define BOARD_P0_4_ADC24_NEGATIVE_INPUT      0

// P0_4 CMP instance number (Do Not Modify!)
#define BOARD_P0_4_CMP_INSTANCE              0
// P0_4 CMP input number (Do Not Modify!)
#define BOARD_P0_4_CMP_INPUT                 3

// P0_5 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_5_ADC12_INSTANCE            0
// P0_5 ADC12 input number (Do Not Modify!)
#define BOARD_P0_5_ADC12_INPUT               5

// P0_5 ADC24 negative input number (Do Not Modify!)
#define BOARD_P0_5_ADC24_NEGATIVE_INPUT      1

// P0_5 CMP instance number (Do Not Modify!)
#define BOARD_P0_5_CMP_INSTANCE              1
// P0_5 CMP input number (Do Not Modify!)
#define BOARD_P0_5_CMP_INPUT                 3

// P0_6 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_6_ADC12_INSTANCE            1
// P0_6 ADC12 input number (Do Not Modify!)
#define BOARD_P0_6_ADC12_INPUT               0

// P0_6 ADC24 negative input number (Do Not Modify!)
#define BOARD_P0_6_ADC24_NEGATIVE_INPUT      2

// P0_6 CMP instance number (Do Not Modify!)
#define BOARD_P0_6_CMP_INSTANCE              0
// P0_6 CMP input number (Do Not Modify!)
#define BOARD_P0_6_CMP_INPUT                 1

// P0_7 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_7_ADC12_INSTANCE            1
// P0_7 ADC12 input number (Do Not Modify!)
#define BOARD_P0_7_ADC12_INPUT               1

// P0_7 ADC24 negative input number (Do Not Modify!)
#define BOARD_P0_7_ADC24_NEGATIVE_INPUT      3

// P0_7 CMP instance number (Do Not Modify!)
#define BOARD_P0_7_CMP_INSTANCE              1
// P0_7 CMP input number (Do Not Modify!)
#define BOARD_P0_7_CMP_INPUT                 1

// P1_0 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_0_ADC12_INSTANCE            1
// P1_0 ADC12 input number (Do Not Modify!)
#define BOARD_P1_0_ADC12_INPUT               2

// P1_0 CMP instance number (Do Not Modify!)
#define BOARD_P1_0_CMP_INSTANCE              2
// P1_0 CMP input number (Do Not Modify!)
#define BOARD_P1_0_CMP_INPUT                 1

// P1_1 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_1_ADC12_INSTANCE            1
// P1_1 ADC12 input number (Do Not Modify!)
#define BOARD_P1_1_ADC12_INPUT               3

// P1_1 CMP instance number (Do Not Modify!)
#define BOARD_P1_1_CMP_INSTANCE              3
// P1_1 CMP input number (Do Not Modify!)
#define BOARD_P1_1_CMP_INPUT                 1

// P1_2 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_2_ADC12_INSTANCE            1
// P1_2 ADC12 input number (Do Not Modify!)
#define BOARD_P1_2_ADC12_INPUT               4

// P1_2 CMP instance number (Do Not Modify!)
#define BOARD_P1_2_CMP_INSTANCE              2
// P1_2 CMP input number (Do Not Modify!)
#define BOARD_P1_2_CMP_INPUT                 3

// P1_3 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_3_ADC12_INSTANCE            1
// P1_3 ADC12 input number (Do Not Modify!)
#define BOARD_P1_3_ADC12_INPUT               5

// P1_3 CMP instance number (Do Not Modify!)
#define BOARD_P1_3_CMP_INSTANCE              3
// P1_3 CMP input number (Do Not Modify!)
#define BOARD_P1_3_CMP_INPUT                 3

// P1_4 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_4_ADC12_INSTANCE            2
// P1_4 ADC12 input number (Do Not Modify!)
#define BOARD_P1_4_ADC12_INPUT               0

// P1_4 CMP instance number (Do Not Modify!)
#define BOARD_P1_4_CMP_INSTANCE              0
// P1_4 CMP input number (Do Not Modify!)
#define BOARD_P1_4_CMP_INPUT                 2

// P1_5 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_5_ADC12_INSTANCE            2
// P1_5 ADC12 input number (Do Not Modify!)
#define BOARD_P1_5_ADC12_INPUT               1

// P1_5 CMP instance number (Do Not Modify!)
#define BOARD_P1_5_CMP_INSTANCE              1
// P1_5 CMP input number (Do Not Modify!)
#define BOARD_P1_5_CMP_INPUT                 2

// P1_6 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_6_ADC12_INSTANCE            2
// P1_6 ADC12 input number (Do Not Modify!)
#define BOARD_P1_6_ADC12_INPUT               2

// P1_6 CMP instance number (Do Not Modify!)
#define BOARD_P1_6_CMP_INSTANCE              2
// P1_6 CMP input number (Do Not Modify!)
#define BOARD_P1_6_CMP_INPUT                 2

// P1_7 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_7_ADC12_INSTANCE            2
// P1_7 ADC12 input number (Do Not Modify!)
#define BOARD_P1_7_ADC12_INPUT               3

// P1_7 CMP instance number (Do Not Modify!)
#define BOARD_P1_7_CMP_INSTANCE              3
// P1_7 CMP input number (Do Not Modify!)
#define BOARD_P1_7_CMP_INPUT                 2

// P2_0 ADC12 instance number (Do Not Modify!)
#define BOARD_P2_0_ADC12_INSTANCE            2
// P2_0 ADC12 input number (Do Not Modify!)
#define BOARD_P2_0_ADC12_INPUT               4

// P2_1 ADC12 instance number (Do Not Modify!)
#define BOARD_P2_1_ADC12_INSTANCE            2
// P2_1 ADC12 input number (Do Not Modify!)
#define BOARD_P2_1_ADC12_INPUT               5

// P2_2 DAC12 instance number (Do Not Modify!)
#define BOARD_P2_2_DAC12_INSTANCE            0
// P2_3 DAC12 instance number (Do Not Modify!)
#define BOARD_P2_3_DAC12_INSTANCE            1
// P2_4 LPCMP input number (Do Not Modify!)
#define BOARD_P2_4_LPCMP_INPUT               0

// P2_5 LPCMP input number (Do Not Modify!)
#define BOARD_P2_5_LPCMP_INPUT               1

// P2_6 LPCMP input number (Do Not Modify!)
#define BOARD_P2_6_LPCMP_INPUT               2

// P2_7 LPCMP input number (Do Not Modify!)
#define BOARD_P2_7_LPCMP_INPUT               3

// </h>
