/******************************************************************************
 * @file     clocks.h
 * @author   Auto generated by Conductor Tool https://conductor.alifsemi.com/
 * @version  v1.0.0
 * @date     2025-4-11
 * @brief    Clocking settings for "AI/ML AppKit Gen 2 (AK-E7-AIML)" project with AE722F80F55D5LS
 * @bug      None.
 * @note     None.
 ******************************************************************************/
/*
 *   Copyright (C) 2025 Alif Semiconductor - All Rights Reserved.
 *   Use, distribution and modification of this code is permitted under the
 *   terms stated in the Alif Semiconductor Software License Agreement
 *
 *   You should have received a copy of the Alif Semiconductor Software
 *   License Agreement with this file. If not, please write to:
 *   https://alifsemi.com/contact/, or visit: https://alifsemi.com/license/
 */

#ifndef __CLOCKS_H__
#define __CLOCKS_H__

#include <stdint.h>

/* ===========================================================================================================================
 */
/* ================                                     Clocks
 * ================ */
/* ===========================================================================================================================
 */

#define APSS_CLK   800000000 /* Output of MUX_APSS_CLK; */
#define APSS_CLK_1 800000000 /* Output of DIV_APSS_CLK_1; Input of MUX_APSS_CLK; */
#define APSS_CLK_2 400000000 /* Output of DIV_APSS_CLK_2; Input of MUX_APSS_CLK; */
#define CPUPLL_CLK 800000000 /* Input of DIV_APSS_CLK_1; Output of MUX_CPUPLL_CLK; */
#define ETH_CLK    50000000  /* Output of MUX_ETH_CLK; */
#define ETH_REFCLK 50000000  /* Input of MUX_ETH_CLK; */
#define GNSS_CLK   131000000
#define HFOSC_CLK  0        /* Output of MUX_HFOSC_CLK; */
#define HFRC       76800000 /* Input of DIV_HFRC; */
#define HFRC_DIV2                                                                                  \
    38400000 /* Output of DIV_HFRC_DIV2; Input of MUX_HFOSC_CLK; Input of MUX_RTSS_HP_CLK_2; Input \
                of MUX_RTSS_HE_CLK_2; */
#define HFRC_DIV_CLK                                                                               \
    76800000 /* Output of DIV_HFRC; Input of DIV_HFRC_DIV2; Input of MUX_HFXO_CLK; Input of        \
                MUX_RTSS_HP_CLK_2; Input of MUX_RTSS_HE_CLK_2; */
#define HFXO 38400000 /* Input of DIV_HFXO; */
#define HFXO_CLK                                                                                   \
    76800000 /* Output of MUX_HFXO_CLK; Input of MUX_CPUPLL_CLK; Input of MUX_SYSPLL_CLK; Input of \
                MUX_SYST_REFCLK; */
#define HFXO_DIV_CLK                                                                               \
    38400000 /* Output of DIV_HFXO; Input of MUX_HFXO_CLK; Input of MUX_HFOSC_CLK; Input of        \
                MUX_RTSS_HP_CLK_2; Input of MUX_RTSS_HE_CLK_2; */
#define JTAG_TCK_PIN       20000000
#define LFRC               32700 /* Input of MUX_S32K_CLK; */
#define LFXO               32768 /* Input of MUX_S32K_CLK; */
#define MODEM_APB_CLK      160000000
#define MODEM_MAIN_CLK     160000000
#define PLL_CLK1           800000000 /* Input of MUX_CPUPLL_CLK; */
#define PLL_CLK1_DIV10     80000000  /* Input of MUX_RTSS_HE_CLK_1; */
#define PLL_CLK1_DIV2      400000000 /* Input of MUX_SYSPLL_CLK; Input of MUX_RTSS_HP_CLK_1; */
#define PLL_CLK1_DIV4      200000000 /* Input of MUX_RTSS_HP_CLK_1; */
#define PLL_CLK1_DIV8_DIV2 50000000  /* Input of MUX_ETH_CLK; */
#define PLL_CLK1_DIV_10    80000000  /* Input of MUX_RTSS_HE_CLK_1; */
#define RTSS_HE_CLK        160000000 /* Output of MUX_RTSS_HE_CLK; */
#define RTSS_HE_CLK_1      160000000 /* Output of MUX_RTSS_HE_CLK_1; Input of MUX_RTSS_HE_CLK; */
#define RTSS_HE_CLK_2      76800000  /* Output of MUX_RTSS_HE_CLK_2; Input of MUX_RTSS_HE_CLK; */
#define RTSS_HP_CLK        400000000 /* Output of MUX_RTSS_HP_CLK; */
#define RTSS_HP_CLK_1      400000000 /* Output of MUX_RTSS_HP_CLK_1; Input of MUX_RTSS_HP_CLK; */
#define RTSS_HP_CLK_2      76800000  /* Output of MUX_RTSS_HP_CLK_2; Input of MUX_RTSS_HP_CLK; */
#define S32K_CLK           32768     /* Output of MUX_S32K_CLK; */
#define SYSPLL_CLK                                                                                 \
    400000000 /* Input of DIV_APSS_CLK_2; Input of DIV_SYST_ACLK_1; Output of MUX_SYSPLL_CLK; */
#define SYST_ACLK                                                                                  \
    400000000 /* Input of DIV_SYST_HCLK; Input of DIV_SYST_PCLK; Output of MUX_SYST_ACLK; */
#define SYST_ACLK_1 400000000 /* Output of DIV_SYST_ACLK_1; Input of MUX_SYST_ACLK; */
#define SYST_DBGCLK 100000000
#define SYST_HCLK   200000000 /* Output of DIV_SYST_HCLK; */
#define SYST_PCLK   100000000 /* Output of DIV_SYST_PCLK; */
#define SYST_REFCLK                                                                                \
    100000000 /* Output of MUX_SYST_REFCLK; Input of MUX_APSS_CLK; Input of MUX_SYST_ACLK; */
#define USB_CLK                            0
#define _0M_CLK                            0 /* Input of MUX_APSS_CLK; Input of MUX_SYST_ACLK; */
#define _100M_CLK                          100000000 /* Input of MUX_SYST_REFCLK; Input of MUX_RTSS_HP_CLK_1; */
#define _100M_CLK_2                        0
#define _10M_CLK                           0
#define _160M_CLK                          160000000 /* Input of MUX_RTSS_HE_CLK_1; */
#define _160M_CLK_2                        0
#define _160M__CLK                         160000000 /* Input of MUX_RTSS_HE_CLK_1; */
#define _76M8_CLK                          76800000 /* Input of MUX_RTSS_HP_CLK_2; Input of MUX_RTSS_HE_CLK_2; */

/* ===========================================================================================================================
 */
/* ================										DIVs
 * ================ */
/* ===========================================================================================================================
 */

/* ================ DIV_SYST_HCLK ================ */
/* Bitfield Offset */
#define DIV_SYST_HCLK__BITFLD_OFFSET       8
/* Possible Values */
#define DIV_SYST_HCLK__DIV1                (0UL << DIV_SYST_HCLK__BITFLD_OFFSET)
#define DIV_SYST_HCLK__DIV2                (1UL << DIV_SYST_HCLK__BITFLD_OFFSET)
#define DIV_SYST_HCLK__DIV4                (2UL << DIV_SYST_HCLK__BITFLD_OFFSET)
/* Address and Mask */
#define DIV_SYST_HCLK__ADDRESS             0x1A604020
#define DIV_SYST_HCLK__MASK                0x00000300
/* Configured Value */
#define DIV_SYST_HCLK__SETTINGS            DIV_SYST_HCLK__DIV2

/* ================ DIV_SYST_PCLK ================ */
/* Bitfield Offset */
#define DIV_SYST_PCLK__BITFLD_OFFSET       0
/* Possible Values */
#define DIV_SYST_PCLK__DIV1                (0UL << DIV_SYST_PCLK__BITFLD_OFFSET)
#define DIV_SYST_PCLK__DIV2                (1UL << DIV_SYST_PCLK__BITFLD_OFFSET)
#define DIV_SYST_PCLK__DIV4                (2UL << DIV_SYST_PCLK__BITFLD_OFFSET)
/* Address and Mask */
#define DIV_SYST_PCLK__ADDRESS             0x1A604020
#define DIV_SYST_PCLK__MASK                0x00000003
/* Configured Value */
#define DIV_SYST_PCLK__SETTINGS            DIV_SYST_PCLK__DIV4

/* ================ DIV_APSS_CLK_1 ================ */
/* Bitfield Offset */
#define DIV_APSS_CLK_1__BITFLD_OFFSET      0
/* Possible Values */
#define DIV_APSS_CLK_1__DIV1               (0UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV2               (1UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV3               (2UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV4               (3UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV5               (4UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV6               (5UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV7               (6UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV8               (7UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV9               (8UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV10              (9UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV11              (10UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV12              (11UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV13              (12UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV14              (13UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV15              (14UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV16              (15UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV17              (16UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV18              (17UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV19              (18UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV20              (19UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV21              (20UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV22              (21UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV23              (22UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV24              (23UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV25              (24UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV26              (25UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV27              (26UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV28              (27UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV29              (28UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV30              (29UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV31              (30UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
#define DIV_APSS_CLK_1__DIV32              (31UL << DIV_APSS_CLK_1__BITFLD_OFFSET)
/* Address and Mask */
#define DIV_APSS_CLK_1__ADDRESS            0x1A010808
#define DIV_APSS_CLK_1__MASK               0x0000001f
/* Configured Value */
#define DIV_APSS_CLK_1__SETTINGS           DIV_APSS_CLK_1__DIV1

/* ================ DIV_APSS_CLK_2 ================ */
/* Bitfield Offset */
#define DIV_APSS_CLK_2__BITFLD_OFFSET      0
/* Possible Values */
#define DIV_APSS_CLK_2__DIV1               (0UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV2               (1UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV3               (2UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV4               (3UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV5               (4UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV6               (5UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV7               (6UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV8               (7UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV9               (8UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV10              (9UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV11              (10UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV12              (11UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV13              (12UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV14              (13UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV15              (14UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV16              (15UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV17              (16UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV18              (17UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV19              (18UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV20              (19UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV21              (20UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV22              (21UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV23              (22UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV24              (23UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV25              (24UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV26              (25UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV27              (26UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV28              (27UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV29              (28UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV30              (29UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV31              (30UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
#define DIV_APSS_CLK_2__DIV32              (31UL << DIV_APSS_CLK_2__BITFLD_OFFSET)
/* Address and Mask */
#define DIV_APSS_CLK_2__ADDRESS            0x1A010804
#define DIV_APSS_CLK_2__MASK               0x0000001f
/* Configured Value */
#define DIV_APSS_CLK_2__SETTINGS           DIV_APSS_CLK_2__DIV1

/* ================ DIV_SYST_ACLK_1 ================ */
/* Bitfield Offset */
#define DIV_SYST_ACLK_1__BITFLD_OFFSET     0
/* Possible Values */
#define DIV_SYST_ACLK_1__DIV1              (0UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV2              (1UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV3              (2UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV4              (3UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV5              (4UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV6              (5UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV7              (6UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV8              (7UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV9              (8UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV10             (9UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV11             (10UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV12             (11UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV13             (12UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV14             (13UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV15             (14UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV16             (15UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV17             (16UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV18             (17UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV19             (18UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV20             (19UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV21             (20UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV22             (21UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV23             (22UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV24             (23UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV25             (24UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV26             (25UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV27             (26UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV28             (27UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV29             (28UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV30             (29UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV31             (30UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
#define DIV_SYST_ACLK_1__DIV32             (31UL << DIV_SYST_ACLK_1__BITFLD_OFFSET)
/* Address and Mask */
#define DIV_SYST_ACLK_1__ADDRESS           0x1A010824
#define DIV_SYST_ACLK_1__MASK              0x0000001f
/* Configured Value */
#define DIV_SYST_ACLK_1__SETTINGS          DIV_SYST_ACLK_1__DIV1

/* ================ DIV_HFXO ================ */
/* Bitfield Offset */
#define DIV_HFXO__BITFLD_OFFSET            13
/* Possible Values */
#define DIV_HFXO__DIV1                     (0UL << DIV_HFXO__BITFLD_OFFSET)
#define DIV_HFXO__DIV2                     (1UL << DIV_HFXO__BITFLD_OFFSET)
#define DIV_HFXO__DIV4                     (2UL << DIV_HFXO__BITFLD_OFFSET)
#define DIV_HFXO__DIV8                     (3UL << DIV_HFXO__BITFLD_OFFSET)
#define DIV_HFXO__DIV16                    (4UL << DIV_HFXO__BITFLD_OFFSET)
#define DIV_HFXO__DIV32                    (5UL << DIV_HFXO__BITFLD_OFFSET)
#define DIV_HFXO__DIV64                    (6UL << DIV_HFXO__BITFLD_OFFSET)
#define DIV_HFXO__DIV128                   (7UL << DIV_HFXO__BITFLD_OFFSET)
#define DIV_HFXO__DIV256                   (14UL << DIV_HFXO__BITFLD_OFFSET)
#define DIV_HFXO__DIV1024                  (15UL << DIV_HFXO__BITFLD_OFFSET)
/* Address and Mask */
#define DIV_HFXO__ADDRESS                  0x1A604030
#define DIV_HFXO__MASK                     0x0001e000
/* Configured Value */
#define DIV_HFXO__SETTINGS                 DIV_HFXO__DIV1

/* ================ DIV_HFRC ================ */
/* Bitfield Offset */
#define DIV_HFRC__BITFLD_OFFSET            11
/* Possible Values */
#define DIV_HFRC__DIV1                     (0UL << DIV_HFRC__BITFLD_OFFSET)
#define DIV_HFRC__DIV2                     (1UL << DIV_HFRC__BITFLD_OFFSET)
#define DIV_HFRC__DIV4                     (2UL << DIV_HFRC__BITFLD_OFFSET)
#define DIV_HFRC__DIV8                     (3UL << DIV_HFRC__BITFLD_OFFSET)
#define DIV_HFRC__DIV16                    (4UL << DIV_HFRC__BITFLD_OFFSET)
#define DIV_HFRC__DIV32                    (5UL << DIV_HFRC__BITFLD_OFFSET)
#define DIV_HFRC__DIV64                    (6UL << DIV_HFRC__BITFLD_OFFSET)
#define DIV_HFRC__DIV128                   (7UL << DIV_HFRC__BITFLD_OFFSET)
/* Address and Mask */
#define DIV_HFRC__ADDRESS                  0x1A60A03C
#define DIV_HFRC__MASK                     0x00003800
/* Configured Value */
#define DIV_HFRC__SETTINGS                 DIV_HFRC__DIV1

/* ===========================================================================================================================
 */
/* ================										MUXes
 * ================ */
/* ===========================================================================================================================
 */

/* ================ MUX_HFXO_CLK ================ */
/* Bitfield Offset */
#define MUX_HFXO_CLK__BITFLD_OFFSET        0
/* Possible Values */
#define MUX_HFXO_CLK__HFRC_DIV_CLK         (0UL << MUX_HFXO_CLK__BITFLD_OFFSET)
#define MUX_HFXO_CLK__HFXO_DIV_CLK         (1UL << MUX_HFXO_CLK__BITFLD_OFFSET)
/* Address and Mask */
#define MUX_HFXO_CLK__ADDRESS              0x1A602000
#define MUX_HFXO_CLK__MASK                 0x00000001
/* Configured Value */
#define MUX_HFXO_CLK__SETTINGS             MUX_HFXO_CLK__HFRC_DIV_CLK

/* ================ MUX_HFOSC_CLK ================ */
/* Bitfield Offset */
#define MUX_HFOSC_CLK__BITFLD_OFFSET       4
/* Possible Values */
#define MUX_HFOSC_CLK__HFXO_DIV_CLK        (1UL << MUX_HFOSC_CLK__BITFLD_OFFSET)
#define MUX_HFOSC_CLK__HFRC_DIV2           (0UL << MUX_HFOSC_CLK__BITFLD_OFFSET)
/* Address and Mask */
#define MUX_HFOSC_CLK__ADDRESS             0x1A602000
#define MUX_HFOSC_CLK__MASK                0x00000010
/* Configured Value */
#define MUX_HFOSC_CLK__SETTINGS            MUX_HFOSC_CLK__HFRC_DIV2

/* ================ MUX_CPUPLL_CLK ================ */
/* Bitfield Offset */
#define MUX_CPUPLL_CLK__BITFLD_OFFSET      4
/* Possible Values */
#define MUX_CPUPLL_CLK__HFXO_CLK           (0UL << MUX_CPUPLL_CLK__BITFLD_OFFSET)
#define MUX_CPUPLL_CLK__PLL_CLK1           (1UL << MUX_CPUPLL_CLK__BITFLD_OFFSET)
/* Address and Mask */
#define MUX_CPUPLL_CLK__ADDRESS            0x1A602008
#define MUX_CPUPLL_CLK__MASK               0x00000010
/* Configured Value */
#define MUX_CPUPLL_CLK__SETTINGS           MUX_CPUPLL_CLK__PLL_CLK1

/* ================ MUX_SYSPLL_CLK ================ */
/* Bitfield Offset */
#define MUX_SYSPLL_CLK__BITFLD_OFFSET      4
/* Possible Values */
#define MUX_SYSPLL_CLK__HFXO_CLK           (0UL << MUX_SYSPLL_CLK__BITFLD_OFFSET)
#define MUX_SYSPLL_CLK__PLL_CLK1_DIV2      (1UL << MUX_SYSPLL_CLK__BITFLD_OFFSET)
/* Address and Mask */
#define MUX_SYSPLL_CLK__ADDRESS            0x1A602008
#define MUX_SYSPLL_CLK__MASK               0x00000010
/* Configured Value */
#define MUX_SYSPLL_CLK__SETTINGS           MUX_SYSPLL_CLK__PLL_CLK1_DIV2

/* ================ MUX_SYST_REFCLK ================ */
/* Bitfield Offset */
#define MUX_SYST_REFCLK__BITFLD_OFFSET     0
/* Possible Values */
#define MUX_SYST_REFCLK__HFXO_CLK          (0UL << MUX_SYST_REFCLK__BITFLD_OFFSET)
#define MUX_SYST_REFCLK__100M_CLK          (1UL << MUX_SYST_REFCLK__BITFLD_OFFSET)
/* Address and Mask */
#define MUX_SYST_REFCLK__ADDRESS           0x1A602008
#define MUX_SYST_REFCLK__MASK              0x00000001
/* Configured Value */
#define MUX_SYST_REFCLK__SETTINGS          MUX_SYST_REFCLK__100M_CLK

/* ================ MUX_APSS_CLK ================ */
/* Bitfield Offset */
#define MUX_APSS_CLK__BITFLD_OFFSET        0
/* Possible Values */
#define MUX_APSS_CLK__0M_CLK               (0UL << MUX_APSS_CLK__BITFLD_OFFSET)
#define MUX_APSS_CLK__SYST_REFCLK          (1UL << MUX_APSS_CLK__BITFLD_OFFSET)
#define MUX_APSS_CLK__APSS_CLK_2           (2UL << MUX_APSS_CLK__BITFLD_OFFSET)
#define MUX_APSS_CLK__APSS_CLK_1           (4UL << MUX_APSS_CLK__BITFLD_OFFSET)
/* Address and Mask */
#define MUX_APSS_CLK__ADDRESS              0x1A010800
#define MUX_APSS_CLK__MASK                 0x000000ff
/* Configured Value */
#define MUX_APSS_CLK__SETTINGS             MUX_APSS_CLK__APSS_CLK_1

/* ================ MUX_SYST_ACLK ================ */
/* Bitfield Offset */
#define MUX_SYST_ACLK__BITFLD_OFFSET       0
/* Possible Values */
#define MUX_SYST_ACLK__0M_CLK              (0UL << MUX_SYST_ACLK__BITFLD_OFFSET)
#define MUX_SYST_ACLK__SYST_REFCLK         (1UL << MUX_SYST_ACLK__BITFLD_OFFSET)
#define MUX_SYST_ACLK__SYST_ACLK_1         (2UL << MUX_SYST_ACLK__BITFLD_OFFSET)
/* Address and Mask */
#define MUX_SYST_ACLK__ADDRESS             0x1A010820
#define MUX_SYST_ACLK__MASK                0x000000ff
/* Configured Value */
#define MUX_SYST_ACLK__SETTINGS            MUX_SYST_ACLK__SYST_ACLK_1

/* ================ MUX_ETH_CLK ================ */
/* Bitfield Offset */
#define MUX_ETH_CLK__BITFLD_OFFSET         4
/* Possible Values */
#define MUX_ETH_CLK__ETH_REFCLK            (0UL << MUX_ETH_CLK__BITFLD_OFFSET)
#define MUX_ETH_CLK__PLL_CLK1_DIV8_DIV2    (1UL << MUX_ETH_CLK__BITFLD_OFFSET)
/* Address and Mask */
#define MUX_ETH_CLK__ADDRESS               0x4903F080
#define MUX_ETH_CLK__MASK                  0x00000010
/* Configured Value */
#define MUX_ETH_CLK__SETTINGS              MUX_ETH_CLK__ETH_REFCLK

/* ================ MUX_RTSS_HP_CLK_1 ================ */
/* Bitfield Offset */
#define MUX_RTSS_HP_CLK_1__BITFLD_OFFSET   0
/* Possible Values */
#define MUX_RTSS_HP_CLK_1__100M_CLK        (0UL << MUX_RTSS_HP_CLK_1__BITFLD_OFFSET)
#define MUX_RTSS_HP_CLK_1__PLL_CLK1_DIV4   (1UL << MUX_RTSS_HP_CLK_1__BITFLD_OFFSET)
#define MUX_RTSS_HP_CLK_1__PLL_CLK1_DIV2   (3UL << MUX_RTSS_HP_CLK_1__BITFLD_OFFSET)
/* Address and Mask */
#define MUX_RTSS_HP_CLK_1__ADDRESS         0x1A602010
#define MUX_RTSS_HP_CLK_1__MASK            0x00000003
/* Configured Value */
#define MUX_RTSS_HP_CLK_1__SETTINGS        MUX_RTSS_HP_CLK_1__PLL_CLK1_DIV2

/* ================ MUX_RTSS_HP_CLK_2 ================ */
/* Bitfield Offset */
#define MUX_RTSS_HP_CLK_2__BITFLD_OFFSET   8
/* Possible Values */
#define MUX_RTSS_HP_CLK_2__HFRC_DIV_CLK    (0UL << MUX_RTSS_HP_CLK_2__BITFLD_OFFSET)
#define MUX_RTSS_HP_CLK_2__HFRC_DIV2       (1UL << MUX_RTSS_HP_CLK_2__BITFLD_OFFSET)
#define MUX_RTSS_HP_CLK_2__76M8_CLK        (2UL << MUX_RTSS_HP_CLK_2__BITFLD_OFFSET)
#define MUX_RTSS_HP_CLK_2__HFXO_DIV_CLK    (3UL << MUX_RTSS_HP_CLK_2__BITFLD_OFFSET)
/* Address and Mask */
#define MUX_RTSS_HP_CLK_2__ADDRESS         0x1A602010
#define MUX_RTSS_HP_CLK_2__MASK            0x00000300
/* Configured Value */
#define MUX_RTSS_HP_CLK_2__SETTINGS        MUX_RTSS_HP_CLK_2__HFRC_DIV_CLK

/* ================ MUX_RTSS_HP_CLK ================ */
/* Bitfield Offset */
#define MUX_RTSS_HP_CLK__BITFLD_OFFSET     16
/* Possible Values */
#define MUX_RTSS_HP_CLK__RTSS_HP_CLK_2     (0UL << MUX_RTSS_HP_CLK__BITFLD_OFFSET)
#define MUX_RTSS_HP_CLK__RTSS_HP_CLK_1     (1UL << MUX_RTSS_HP_CLK__BITFLD_OFFSET)
/* Address and Mask */
#define MUX_RTSS_HP_CLK__ADDRESS           0x1A602008
#define MUX_RTSS_HP_CLK__MASK              0x00010000
/* Configured Value */
#define MUX_RTSS_HP_CLK__SETTINGS          MUX_RTSS_HP_CLK__RTSS_HP_CLK_1

/* ================ MUX_RTSS_HE_CLK_1 ================ */
/* Bitfield Offset */
#define MUX_RTSS_HE_CLK_1__BITFLD_OFFSET   4
/* Possible Values */
#define MUX_RTSS_HE_CLK_1__PLL_CLK1_DIV10  (0UL << MUX_RTSS_HE_CLK_1__BITFLD_OFFSET)
#define MUX_RTSS_HE_CLK_1__PLL_CLK1_DIV_10 (1UL << MUX_RTSS_HE_CLK_1__BITFLD_OFFSET)
#define MUX_RTSS_HE_CLK_1__160M__CLK       (2UL << MUX_RTSS_HE_CLK_1__BITFLD_OFFSET)
#define MUX_RTSS_HE_CLK_1__160M_CLK        (3UL << MUX_RTSS_HE_CLK_1__BITFLD_OFFSET)
/* Address and Mask */
#define MUX_RTSS_HE_CLK_1__ADDRESS         0x1A602010
#define MUX_RTSS_HE_CLK_1__MASK            0x00000030
/* Configured Value */
#define MUX_RTSS_HE_CLK_1__SETTINGS        MUX_RTSS_HE_CLK_1__160M_CLK

/* ================ MUX_RTSS_HE_CLK_2 ================ */
/* Bitfield Offset */
#define MUX_RTSS_HE_CLK_2__BITFLD_OFFSET   12
/* Possible Values */
#define MUX_RTSS_HE_CLK_2__HFRC_DIV_CLK    (0UL << MUX_RTSS_HE_CLK_2__BITFLD_OFFSET)
#define MUX_RTSS_HE_CLK_2__HFRC_DIV2       (1UL << MUX_RTSS_HE_CLK_2__BITFLD_OFFSET)
#define MUX_RTSS_HE_CLK_2__76M8_CLK        (2UL << MUX_RTSS_HE_CLK_2__BITFLD_OFFSET)
#define MUX_RTSS_HE_CLK_2__HFXO_DIV_CLK    (3UL << MUX_RTSS_HE_CLK_2__BITFLD_OFFSET)
/* Address and Mask */
#define MUX_RTSS_HE_CLK_2__ADDRESS         0x1A602010
#define MUX_RTSS_HE_CLK_2__MASK            0x00003000
/* Configured Value */
#define MUX_RTSS_HE_CLK_2__SETTINGS        MUX_RTSS_HE_CLK_2__HFRC_DIV_CLK

/* ================ MUX_RTSS_HE_CLK ================ */
/* Bitfield Offset */
#define MUX_RTSS_HE_CLK__BITFLD_OFFSET     20
/* Possible Values */
#define MUX_RTSS_HE_CLK__RTSS_HE_CLK_2     (0UL << MUX_RTSS_HE_CLK__BITFLD_OFFSET)
#define MUX_RTSS_HE_CLK__RTSS_HE_CLK_1     (1UL << MUX_RTSS_HE_CLK__BITFLD_OFFSET)
/* Address and Mask */
#define MUX_RTSS_HE_CLK__ADDRESS           0x1A602008
#define MUX_RTSS_HE_CLK__MASK              0x00100000
/* Configured Value */
#define MUX_RTSS_HE_CLK__SETTINGS          MUX_RTSS_HE_CLK__RTSS_HE_CLK_1

/* ================ MUX_S32K_CLK ================ */
/* Bitfield Offset */
#define MUX_S32K_CLK__BITFLD_OFFSET        0
/* Possible Values */
#define MUX_S32K_CLK__LFRC                 (0UL << MUX_S32K_CLK__BITFLD_OFFSET)
#define MUX_S32K_CLK__LFXO                 (1UL << MUX_S32K_CLK__BITFLD_OFFSET)
/* Address and Mask */
#define MUX_S32K_CLK__ADDRESS              0x1A60A000
#define MUX_S32K_CLK__MASK                 0x00000001
/* Configured Value */
#define MUX_S32K_CLK__SETTINGS             MUX_S32K_CLK__LFXO

/* ===========================================================================================================================
 */
/* ================                                     Switches
 * ================ */
/* ===========================================================================================================================
 */

/* ================ SW_CPUPLL_CLK ================ */
/* Bitfield Offset */
#define SW_CPUPLL_CLK__BITFLD_OFFSET       4
/* Possible Values */
#define SW_CPUPLL_CLK__DISABLED            (0UL << SW_CPUPLL_CLK__BITFLD_OFFSET)
#define SW_CPUPLL_CLK__ENABLED             (1UL << SW_CPUPLL_CLK__BITFLD_OFFSET)
/* Address and Mask */
#define SW_CPUPLL_CLK__ADDRESS             0x1A602014
#define SW_CPUPLL_CLK__MASK                0x00000010
/* Configured Value */
#define SW_CPUPLL_CLK__SETTINGS            SW_CPUPLL_CLK__ENABLED

/* ================ SW_SYSPLL_CLK ================ */
/* Bitfield Offset */
#define SW_SYSPLL_CLK__BITFLD_OFFSET       0
/* Possible Values */
#define SW_SYSPLL_CLK__DISABLED            (0UL << SW_SYSPLL_CLK__BITFLD_OFFSET)
#define SW_SYSPLL_CLK__ENABLED             (1UL << SW_SYSPLL_CLK__BITFLD_OFFSET)
/* Address and Mask */
#define SW_SYSPLL_CLK__ADDRESS             0x1A602014
#define SW_SYSPLL_CLK__MASK                0x00000001
/* Configured Value */
#define SW_SYSPLL_CLK__SETTINGS            SW_SYSPLL_CLK__ENABLED

/* ================ SW_100M_CLK_2 ================ */
/* Bitfield Offset */
#define SW_100M_CLK_2__BITFLD_OFFSET       21
/* Possible Values */
#define SW_100M_CLK_2__DISABLED            (0UL << SW_100M_CLK_2__BITFLD_OFFSET)
#define SW_100M_CLK_2__ENABLED             (1UL << SW_100M_CLK_2__BITFLD_OFFSET)
/* Address and Mask */
#define SW_100M_CLK_2__ADDRESS             0x1A602014
#define SW_100M_CLK_2__MASK                0x00200000
/* Configured Value */
#define SW_100M_CLK_2__SETTINGS            SW_100M_CLK_2__DISABLED

/* ================ SW_RTSS_HP_CLK ================ */
/* Bitfield Offset */
#define SW_RTSS_HP_CLK__BITFLD_OFFSET      12
/* Possible Values */
#define SW_RTSS_HP_CLK__DISABLED           (0UL << SW_RTSS_HP_CLK__BITFLD_OFFSET)
#define SW_RTSS_HP_CLK__ENABLED            (1UL << SW_RTSS_HP_CLK__BITFLD_OFFSET)
/* Address and Mask */
#define SW_RTSS_HP_CLK__ADDRESS            0x1A602014
#define SW_RTSS_HP_CLK__MASK               0x00001000
/* Configured Value */
#define SW_RTSS_HP_CLK__SETTINGS           SW_RTSS_HP_CLK__ENABLED

/* ================ SW_HFOSC_CLK ================ */
/* Bitfield Offset */
#define SW_HFOSC_CLK__BITFLD_OFFSET        23
/* Possible Values */
#define SW_HFOSC_CLK__DISABLED             (0UL << SW_HFOSC_CLK__BITFLD_OFFSET)
#define SW_HFOSC_CLK__ENABLED              (1UL << SW_HFOSC_CLK__BITFLD_OFFSET)
/* Address and Mask */
#define SW_HFOSC_CLK__ADDRESS              0x1A602014
#define SW_HFOSC_CLK__MASK                 0x00800000
/* Configured Value */
#define SW_HFOSC_CLK__SETTINGS             SW_HFOSC_CLK__DISABLED

/* ================ SW_RTSS_HE_CLK ================ */
/* Bitfield Offset */
#define SW_RTSS_HE_CLK__BITFLD_OFFSET      13
/* Possible Values */
#define SW_RTSS_HE_CLK__DISABLED           (0UL << SW_RTSS_HE_CLK__BITFLD_OFFSET)
#define SW_RTSS_HE_CLK__ENABLED            (1UL << SW_RTSS_HE_CLK__BITFLD_OFFSET)
/* Address and Mask */
#define SW_RTSS_HE_CLK__ADDRESS            0x1A602014
#define SW_RTSS_HE_CLK__MASK               0x00002000
/* Configured Value */
#define SW_RTSS_HE_CLK__SETTINGS           SW_RTSS_HE_CLK__ENABLED

/* ================ SW_160M_CLK_2 ================ */
/* Bitfield Offset */
#define SW_160M_CLK_2__BITFLD_OFFSET       20
/* Possible Values */
#define SW_160M_CLK_2__DISABLED            (0UL << SW_160M_CLK_2__BITFLD_OFFSET)
#define SW_160M_CLK_2__ENABLED             (1UL << SW_160M_CLK_2__BITFLD_OFFSET)
/* Address and Mask */
#define SW_160M_CLK_2__ADDRESS             0x1A602014
#define SW_160M_CLK_2__MASK                0x00100000
/* Configured Value */
#define SW_160M_CLK_2__SETTINGS            SW_160M_CLK_2__DISABLED

/* ================ SW_USB_CLK ================ */
/* Bitfield Offset */
#define SW_USB_CLK__BITFLD_OFFSET          22
/* Possible Values */
#define SW_USB_CLK__DISABLED               (0UL << SW_USB_CLK__BITFLD_OFFSET)
#define SW_USB_CLK__ENABLED                (1UL << SW_USB_CLK__BITFLD_OFFSET)
/* Address and Mask */
#define SW_USB_CLK__ADDRESS                0x1A602014
#define SW_USB_CLK__MASK                   0x00400000
/* Configured Value */
#define SW_USB_CLK__SETTINGS               SW_USB_CLK__DISABLED

/* ================ SW_10M_CLK ================ */
/* Bitfield Offset */
#define SW_10M_CLK__BITFLD_OFFSET          22
/* Possible Values */
#define SW_10M_CLK__DISABLED               (0UL << SW_10M_CLK__BITFLD_OFFSET)
#define SW_10M_CLK__ENABLED                (1UL << SW_10M_CLK__BITFLD_OFFSET)
/* Address and Mask */
#define SW_10M_CLK__ADDRESS                0x1A602014
#define SW_10M_CLK__MASK                   0x00400000
/* Configured Value */
#define SW_10M_CLK__SETTINGS               SW_10M_CLK__DISABLED

/* Callback Macro */
#define SET_CLOCK(reg, mask, value)                                                                \
    {                                                                                              \
        *(uint32_t *) (reg) &= ~((uint32_t) (mask));                                               \
        *(uint32_t *) (reg) |= (uint32_t) (value);                                                 \
    }

#endif /* __CLOCKS_H__ */
