/*
 *   Copyright (C) 2025 Alif Semiconductor - All Rights Reserved.
 *   Use, distribution and modification of this code is permitted under the
 *   terms stated in the Alif Semiconductor Software License Agreement
 *
 *   You should have received a copy of the Alif Semiconductor Software
 *   License Agreement with this file. If not, please write to:
 *   https://alifsemi.com/contact/, or visit: https://alifsemi.com/license/
 */
/******************************************************************************
 * @file     board_defs.h
 * @author      Auto generated by Conductor Tool https://conductor.alifsemi.com/
 * @version  v1.0.0
 * @date     2025-5-7
 * @brief    Board info/settings for "DevKit-e8" project
 *           with AE822FA0E5597
 * @bug      None.
 * @note     To modify this file manually, take care to modify pins.h and gpios.h
 *           accordingly when required.
 ******************************************************************************/
//-------- <<< Use Configuration Wizard in Context Menu >>> -------------------

// <h> Board peripheral instances
// <o> "ADC12A" ADC12 instance number <0-2>
#define BOARD_ADC12A_ADC12_INSTANCE          0

// <o> "ADC12B" ADC12 instance number <0-2>
#define BOARD_ADC12B_ADC12_INSTANCE          1

// <o> "ADC12C" ADC12 instance number <0-2>
#define BOARD_ADC12C_ADC12_INSTANCE          2

// <e> ADC24 module enabled flag
#define BOARD_ADC24_ENABLED                  1
// </e>

// <e> CANFD module enabled flag
#define BOARD_CANFD_ENABLED                  1
// <e> "CAN Transceiver" on CANFD presence flag
#define BOARD_CANFD_CAN_TRANSCEIVER_PRESENT  1
// </e>
// </e>

// <o> "CMPA" CMP instance number <0-4>
#define BOARD_CMPA_CMP_INSTANCE              0

// <o> "CMPB" CMP instance number <0-4>
#define BOARD_CMPB_CMP_INSTANCE              1

// <o> "CMPC" CMP instance number <0-4>
#define BOARD_CMPC_CMP_INSTANCE              2

// <o> "CMPD" CMP instance number <0-4>
#define BOARD_CMPD_CMP_INSTANCE              3

// <e> CSI module enabled flag
#define BOARD_CSI_ENABLED                    1
// <e> "ARX3A0" on CSI presence flag
#define BOARD_CSI_ARX3A0_PRESENT             1
// </e>
// <e> "AR0144" on CSI presence flag
#define BOARD_CSI_AR0144_PRESENT             1
// </e>
// </e>

// <e> DSI module enabled flag
#define BOARD_DSI_ENABLED                    1
// <e> "ILI9806" on DSI presence flag
#define BOARD_DSI_ILI9806_PRESENT            1
// </e>
// </e>

// <o> Select MIPI display by default
#define BOARD_CONFIGURE_LVDS_MUX             1

// <e> ETH module enabled flag
#define BOARD_ETH_ENABLED                    1
// <e> "RTL8201" on ETH presence flag
#define BOARD_ETH_RTL8201_PRESENT            1
// </e>
// </e>

// <o> "Clickboard" I2C instance number <0-3>
#define BOARD_CLICKBOARD_I2C_INSTANCE        0

// <o> "Slave" I2C instance number <0-3>
#define BOARD_SLAVE_I2C_INSTANCE             0

// <o> "Camera" I2C instance number <0-3>
#define BOARD_CAMERA_I2C_INSTANCE            1

// <o> "GT911 Touchscreen" I2C instance number <0-3>
#define BOARD_GT911_TOUCHSCREEN_I2C_INSTANCE 1

// <o> "Master" I2C instance number <0-3>
#define BOARD_MASTER_I2C_INSTANCE            1

// <o> LPI2C0 module enabled flag
#define BOARD_LPI2C0_ENABLED                 1

// <e> "FLEXIO" on LPI2C0 presence flag
#define BOARD_LPI2C0_USE_FLEXIO_PINS         1

#if defined(RTSS_HE)
// <o> "MIC Input" I2S instance number <0-3>
#define BOARD_MIC_INPUT_I2S_INSTANCE LP
#else
// <o> "MIC Input" I2S instance number <0-3>
#define BOARD_MIC_INPUT_I2S_INSTANCE 3
#endif

// <o> LPSPI module enabled flag
#define BOARD_LPSPI_ENABLED                             1

// <o> SPI salve instance number <0-3>
#define BOARD_SLAVE_SPI_INSTANCE                        1

// <o> SPI master instance number <0-3>
#define BOARD_MASTER_SPI_INSTANCE                       1

// <o> LPUART module enabled flag
#define BOARD_LPUART_ENABLED                            1

// <e> I3C module enabled flag
#define BOARD_I3C_ENABLED                               1

// <e> "FLEXIO" on I3C presence flag
#define BOARD_I3C_FLEXIO_PRESENT                        1
// <e> "ICM42670 IMU" on I3C presence flag
#define BOARD_I3C_ICM42670_IMU_PRESENT                  1
// </e>
// <e> "BMI323 IMU" on I3C presence flag
#define BOARD_I3C_BMI323_IMU_PRESENT                    1
// </e>
// <e> "pin header" on I3C presence flag
#define BOARD_I3C_PIN_HEADER_PRESENT                    1
// </e>
// </e>

// <e> JTAG module enabled flag
#define BOARD_JTAG_ENABLED                              1
// </e>

// <e> LPCPI module enabled flag
#define BOARD_LPCPI_ENABLED                             1
// </e>

// <e> LPGPIO module enabled flag
#define BOARD_LPGPIO_ENABLED                            1
// </e>

// <e> LPI2S module enabled flag
#define BOARD_LPI2S_ENABLED                             0
// </e>

// <e> LPPDM module enabled flag
#define BOARD_LPPDM_ENABLED                             1
// </e>

// <e> MISC module enabled flag
#define BOARD_MISC_ENABLED                              1
// </e>

// <o> "ISSI RAM" OSPI instance number <0>
#define BOARD_ISSI_RAM_OSPI_INSTANCE                    0

// <o> "ISSI Flash" OSPI instance number <1>
#define BOARD_ISSI_FLASH_OSPI_INSTANCE                  1

// <e> PDM module enabled flag
#define BOARD_PDM_ENABLED                               1
// <e> "PDM MIC" on PDM presence flag
#define BOARD_PDM_PDM_MIC_PRESENT                       1
// </e>
// </e>

// <o> "Encoder" UTIMER instance number <12-15>
#define BOARD_ENCODER_UTIMER_INSTANCE                   12

// <e> SDMMC module enabled flag
#define BOARD_SDMMC_ENABLED                             1
// <e> "SDCARD" on SDMMC presence flag
#define BOARD_SDMMC_SDCARD_PRESENT                      1
// </e>
// </e>

// <e> SEUART module enabled flag
#define BOARD_SEUART_ENABLED                            1
// </e>

// <o> "Clickboard" UART instance number <0-7>
#define BOARD_CLICKBOARD_UART_INSTANCE                  0

// <o> "UARTA" UART instance number <0-7>
#define BOARD_UARTA_UART_INSTANCE                       2

// <o> "UARTB" UART instance number <0-7>
#define BOARD_UARTB_UART_INSTANCE                       4

// <e> USB module enabled flag
#define BOARD_USB_ENABLED                               1
// <e> "Device Role" on USB presence flag
#define BOARD_USB_DEVICE_ROLE_PRESENT                   1
// </e>
// </e>

// <o> "Basic Mode" UTIMER instance number <0-12>
#define BOARD_BASIC_MODE_UTIMER_INSTANCE                0

// <o> "Buffer Mode" UTIMER instance number <0-12>
#define BOARD_BUFFER_MODE_UTIMER_INSTANCE               1

// <o> "Capture Mode" UTIMER instance number <0-12>
#define BOARD_CAPTURE_MODE_UTIMER_INSTANCE              4

// <o> "Compare Mode" UTIMER instance number <0-12>
#define BOARD_COMPARE_MODE_UTIMER_INSTANCE              5

// <o> "Trigger Mode" UTIMER instance number <0-12>
#define BOARD_TRIGGER_MODE_UTIMER_INSTANCE              3

// <o> "Clickboard PWM" UTIMER instance number <0-12>
#define BOARD_CLICKBOARD_PWM_UTIMER_INSTANCE            3

// <o> Utimer 250ms counter value
#define BOARD_UTIMER_250_MILLI_SEC_COUNTER_VALUE        100000000

// <o> Utimer 500ms counter value
#define BOARD_UTIMER_500_MILLI_SEC_COUNTER_VALUE        200000000

// <o> Utimer 750ms counter value
#define BOARD_UTIMER_750_MILLI_SEC_COUNTER_VALUE        300000000

// <o> Utimer 1000ms counter value
#define BOARD_UTIMER_1000_MILLI_SEC_COUNTER_VALUE       400000000

// <o> Utimer 1500ms counter value
#define BOARD_UTIMER_1500_MILLI_SEC_COUNTER_VALUE       600000000

// <o> LED PWM utimer max counter value
#define BOARD_LED_PWM_UT_MAX_COUNTER_VALUE              240000

// <o> "RED_LED_UTIMER_COUNTER_TYPE" UTIMER counter type
//    <0=> UTIMER_COMPARE_A
//    <1=> UTIMER_COMPARE_B
#define BOARD_RED_LED_UTIMER_COUNTER_TYPE               1

// <o> "GREEN_LED_UTIMER_COUNTER_TYPE" UTIMER counter type
//    <0=> UTIMER_COMPARE_A
//    <1=> UTIMER_COMPARE_B
#define BOARD_GREEN_LED_UTIMER_COUNTER_TYPE             0

// <o> "BLUE_LED_UTIMER_COUNTER_TYPE" UTIMER counter type
//    <0=> UTIMER_COMPARE_A
//    <1=> UTIMER_COMPARE_B
#define BOARD_BLUE_LED_UTIMER_COUNTER_TYPE              0

// <o> UTIMER channel red LED instance number <9>
#define BOARD_RED_LED_UTIMER_INSTANCE                   9

// <o> UTIMER channel green LED instance number <10>
#define BOARD_GREEN_LED_UTIMER_INSTANCE                 10

// <o> UTIMER channel blue LED instance number <8>
#define BOARD_BLUE_LED_UTIMER_INSTANCE                  8

// <o> CMP external trigger UTIMER channel instance number <0-12>
#define BOARD_CMP_EXT_TRIGGER_UTIMER_INSTANCE           0

// </h>
// <h> Miscellaneous
// <o> Onboard LEDs
// <i> Sets the #define BOARD_LED_COUNT in the board_def.h file exported from the Conductor tool.
#define BOARD_LED_COUNT                                 0

// <o> Onboard RGB LEDs
// <i> Sets the #define BOARD_LEDRGB_COUNT in the board_def.h file exported from the Conductor tool.
#define BOARD_LEDRGB_COUNT                              2

// <o> Onboard Push-buttons
// <i> Sets the #define BOARD_BUTTON_COUNT in the board_def.h file exported from the Conductor tool.
#define BOARD_BUTTON_COUNT                              5

// <o> Onboard Config Switches or Jumpers
// <i> Sets the #define BOARD_CONFIG_JUMPER_COUNT in the board_def.h file exported from the
// Conductor tool.
#define BOARD_CONFIG_JUMPER_COUNT                       0

// <o> Onboard Switching Devices
// <i> Sets the #define BOARD_SWITCH_OUTPUT_COUNT in the board_def.h file exported from the
// Conductor tool. These include relays, solid state relays, transistors, optocopulers, etc.
#define BOARD_SWITCH_OUTPUT_COUNT                       0

// <o> OSPI0 Bus Speed
// <i> Selects OSPI0 bus speed for a 200-MHz (default) HCLK. For 100 MHz and lower HCLK clock
// speeds, some values are either not possible, either rounded to the closest possible value in
// hardware.
#define BOARD_OSPI0_BUS_SPEED                           100000000

// <o> OSPI1 Bus Speed
// <i> Selects OSPI1 bus speed for a 200-MHz (default) HCLK. For 100 MHz and lower HCLK clock
// speeds, some values are either not possible, either rounded to the closest possible value in
// hardware.
#define BOARD_OSPI1_BUS_SPEED                           100000000

// <o> OSPI0 onboard memory size
#define BOARD_OSPI0_MEM_SIZE                            33554432

// <o> OSPI1 onboard memory size
#define BOARD_OSPI1_MEM_SIZE                            33554432

// </h>
// <h> GPIO port/pin numbers, analog instance/input numbers, etc.
// <o> FLEX IO pins supply voltage <0=> 3.3 V <1=> 1.8 V
// <i> Make sure this setting corresponds to the VDD_IO_FLEX pin voltage. If the VDD_IO_FLEX pin is
// connected to a 3.3 V supply, do not change the value of the GPIO_CNTL register to command 1.8-V
// operation mode!
#define FLEX_IO_VOLTAGE_1V8                             1

// <o> "CLICKBOARD_ANA" ADC12 instance number <0=> ADC120 <1=> ADC121 <2=> ADC122
#define BOARD_CLICKBOARD_ANA_ADC12_INSTANCE             1
// <o> "CLICKBOARD_ANA" ADC12 input number <0=> IN0 <1=> IN1 <2=> IN2 <3=> IN3 <4=> IN4 <5=> IN5
#define BOARD_CLICKBOARD_ANA_ADC12_INPUT                0

// <o> "CLICKBOARD_ANA" ADC24 negative input number <0=> IN0_N <1=> IN1_N <2=> IN2_N <3=> IN3_N
// <i> WARNING: This option does not change the positive input pin automatically!
#define BOARD_CLICKBOARD_ANA_ADC24_INPUT                2

// <o> "CLICKBOARD_ANA" CMP instance number <0=> CMP0 <1=> CMP1 <2=> CMP2 <3=> CMP3
#define BOARD_CLICKBOARD_ANA_CMP_INSTANCE               0
// <o> "CLICKBOARD_ANA" CMP input number <0=> IN0 <1=> IN1 <2=> IN2 <3=> IN3
#define BOARD_CLICKBOARD_ANA_CMP_INPUT                  1

// <o> "POTENTIOMETER" ADC12 instance number <0=> ADC120 <1=> ADC121 <2=> ADC122
#define BOARD_POTENTIOMETER_ADC12_INSTANCE              1
// <o> "POTENTIOMETER" ADC12 input number <0=> IN0 <1=> IN1 <2=> IN2 <3=> IN3 <4=> IN4 <5=> IN5
#define BOARD_POTENTIOMETER_ADC12_INPUT                 1

// <o> "POTENTIOMETER" ADC24 negative input number <0=> IN0_N <1=> IN1_N <2=> IN2_N <3=> IN3_N
// <i> WARNING: This option does not change the positive input pin automatically!
#define BOARD_POTENTIOMETER_ADC24_INPUT                 3

// <o> "POTENTIOMETER" CMP instance number <0=> CMP0 <1=> CMP1 <2=> CMP2 <3=> CMP3
#define BOARD_POTENTIOMETER_CMP_INSTANCE                0
// <o> "POTENTIOMETER" CMP input number <0=> IN0 <1=> IN1 <2=> IN2 <3=> IN3
#define BOARD_POTENTIOMETER_CMP_INPUT                   0

// <o> "CMP0_POS_INPUT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CMP0_POS_INPUT_GPIO_PORT                  0
// <o> "CMP0_POS_INPUT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CMP0_POS_INPUT_GPIO_PIN                   0
// <o> "CMP0_POS_INPUT" GPIO pin alternate function <0-7>
#define BOARD_CMP0_POS_INPUT_ALTERNATE_FUNCTION         7

// <o> "CMP_NEG_INPUT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CMP_NEG_INPUT_GPIO_PORT                   2
// <o> "CMP_NEG_INPUT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CMP_NEG_INPUT_GPIO_PIN                    0
// <o> "CMP_NEG_INPUT" GPIO pin alternate function <0-7>
#define BOARD_CMP_NEG_INPUT_ALTERNATE_FUNCTION          7

// <o> "CMP1_OUT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CMP1_OUT_GPIO_PORT                        14
// <o> "CMP1_OUT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CMP1_OUT_GPIO_PIN                         6
// <o> "CMP1_OUT" GPIO pin alternate function <0-7>
#define BOARD_CMP1_OUT_ALTERNATE_FUNCTION               1

// <o> "CMP0_OUT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CMP0_OUT_GPIO_PORT                        14
// <o> "CMP0_OUT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CMP0_OUT_GPIO_PIN                         7
// <o> "CMP0_OUT" GPIO pin alternate function <0-7>
#define BOARD_CMP0_OUT_ALTERNATE_FUNCTION               1

// <o> "CMP3_OUT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CMP3_OUT_GPIO_PORT                        14
// <o> "CMP3_OUT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CMP3_OUT_GPIO_PIN                         4
// <o> "CMP3_OUT" GPIO pin alternate function <0-7>
#define BOARD_CMP3_OUT_ALTERNATE_FUNCTION               1

// <o> "CMP2_OUT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CMP2_OUT_GPIO_PORT                        14
// <o> "CMP2_OUT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CMP2_OUT_GPIO_PIN                         5
// <o> "CMP2_OUT" GPIO pin alternate function <0-7>
#define BOARD_CMP2_OUT_ALTERNATE_FUNCTION               1

// <o> "LPCMP_POS_INPUT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4
// <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12
// <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPCMP_POS_INPUT_GPIO_PORT                 2
// <o> "LPCMP_POS_INPUT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_LPCMP_POS_INPUT_GPIO_PIN                  4
// <o> "LPCMP_POS_INPUT" GPIO pin alternate function <0-7>
#define BOARD_LPCMP_POS_INPUT_ALTERNATE_FUNCTION        7

// <o> "LPCMP_NEG_INPUT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4
// <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12
// <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPCMP_NEG_INPUT_GPIO_PORT                 2
// <o> "LPCMP_NEG_INPUT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_LPCMP_NEG_INPUT_GPIO_PIN                  0
// <o> "LPCMP_NEG_INPUT" GPIO pin alternate function <0-7>
#define BOARD_LPCMP_NEG_INPUT_ALTERNATE_FUNCTION        7

// <o> ADC12 instance <0=>0 <0=>1 <0=>2
#define BOARD_ADC12_INSTANCE                            2

// <o> "ADC12_CH0" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_ADC12_CH0_GPIO_PORT                       1
// <o> "ADC12_CH0" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_ADC12_CH0_GPIO_PIN                        4

// <o> "ADC12_CH1" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_ADC12_CH1_GPIO_PORT                       1
// <o> "ADC12_CH1" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_ADC12_CH1_GPIO_PIN                        5

// <o> "ADC12_CH2" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_ADC12_CH2_GPIO_PORT                       1
// <o> "ADC12_CH2" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_ADC12_CH2_GPIO_PIN                        6

// <o> "ADC12_CH3" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_ADC12_CH3_GPIO_PORT                       1
// <o> "ADC12_CH3" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_ADC12_CH3_GPIO_PIN                        7

// <o> "ADC12_CH4" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_ADC12_CH4_GPIO_PORT                       2
// <o> "ADC12_CH4" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_ADC12_CH4_GPIO_PIN                        0

// <o> "ADC12_CH5" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_ADC12_CH5_GPIO_PORT                       2
// <o> "ADC12_CH5" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_ADC12_CH5_GPIO_PIN                        1

// <o> "ADC24_CH0" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_ADC24_CH0_POS_GPIO_PORT                   0
// <o> "ADC24_CH0" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_ADC24_CH0_POS_GPIO_PIN                    0

// <o> "ADC24_CH0" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_ADC24_CH0_NEG_GPIO_PORT                   0
// <o> "ADC24_CH0" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_ADC24_CH0_NEG_GPIO_PIN                    4

// <o> "ADC24_CH1" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_ADC24_CH1_POS_GPIO_PORT                   0
// <o> "ADC24_CH1" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_ADC24_CH1_POS_GPIO_PIN                    1

// <o> "ADC24_CH1" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_ADC24_CH1_NEG_GPIO_PORT                   0
// <o> "ADC24_CH1" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_ADC24_CH1_NEG_GPIO_PIN                    5

// <o> "ADC24_CH2" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_ADC24_CH2_POS_GPIO_PORT                   0
// <o> "ADC24_CH2" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_ADC24_CH2_POS_GPIO_PIN                    2

// <o> "ADC24_CH2" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_ADC24_CH2_NEG_GPIO_PORT                   0
// <o> "ADC24_CH2" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_ADC24_CH2_NEG_GPIO_PIN                    6

// <o> "ADC24_CH3" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_ADC24_CH3_POS_GPIO_PORT                   0
// <o> "ADC24_CH3" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_ADC24_CH3_POS_GPIO_PIN                    3

// <o> "ADC24_CH3" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_ADC24_CH3_NEG_GPIO_PORT                   0
// <o> "ADC24_CH3" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_ADC24_CH3_NEG_GPIO_PIN                    7

// <o> "CLICKBOARD_ANA" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_ADC_CLICKBOARD_ANA_GPIO_PORT              0
// <o> "CLICKBOARD_ANA" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_ADC_CLICKBOARD_ANA_GPIO_PIN               6

// <o> "DAC120_OUT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_DAC120_OUT_GPIO_PORT                      2
// <o> "DAC120_OUT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_DAC120_OUT_GPIO_PIN                       2
// <o> "DAC120_OUT" GPIO pin alternate function <0-7>
#define BOARD_DAC120_ALTERNATE_FUNCTION                 7

// <o> "DAC121_OUT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_DAC121_OUT_GPIO_PORT                      2
// <o> "DAC121_OUT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_DAC121_OUT_GPIO_PIN                       3
// <o> "LPCMP_NEG_INPUT" GPIO pin alternate function <0-7>
#define BOARD_DAC121_ALTERNATE_FUNCTION                 7

// <o> "SD_RESET" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_SD_RESET_GPIO_PORT                        14
// <o> "SD_RESET" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_SD_RESET_GPIO_PIN                         7

// <o> "SD_CARD_DETECT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_SD_CARD_DETECT_GPIO_PORT                  3
// <o> "SD_CARD_DETECT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_SD_CARD_DETECT_GPIO_PIN                   3

// <o> "SD_CMD_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_SD_CMD_A_GPIO_PORT                        7
// <o> "SD_CMD_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_SD_CMD_A_GPIO_PIN                         0
// <o> "SD_CMD_A" GPIO pin alternate function <0-7>
#define BOARD_SD_CMD_ALTERNATE_FUNCTION                 6

// <o> "SD_CLK_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_SD_CLK_A_GPIO_PORT                        7
// <o> "SD_CLK_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_SD_CLK_A_GPIO_PIN                         1
// <o> "SD_CLK_A" GPIO pin alternate function <0-7>
#define BOARD_SD_CLK_ALTERNATE_FUNCTION                 6

// <o> "SD_D0_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_SD_D0_A_GPIO_PORT                         5
// <o> "SD_D0_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_SD_D0_A_GPIO_PIN                          0
// <o> "SD_D0_A" GPIO pin alternate function <0-7>
#define BOARD_SD_D0_ALTERNATE_FUNCTION                  7

// <o> "SD_D1_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_SD_D1_A_GPIO_PORT                         5
// <o> "SD_D1_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_SD_D1_A_GPIO_PIN                          1
// <o> "SD_D1_A" GPIO pin alternate function <0-7>
#define BOARD_SD_D1_ALTERNATE_FUNCTION                  7

// <o> "SD_D2_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_SD_D2_A_GPIO_PORT                         5
// <o> "SD_D2_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_SD_D2_A_GPIO_PIN                          2
// <o> "SD_D2_A" GPIO pin alternate function <0-7>
#define BOARD_SD_D2_ALTERNATE_FUNCTION                  7

// <o> "SD_D3_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_SD_D3_A_GPIO_PORT                         5
// <o> "SD_D3_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_SD_D3_A_GPIO_PIN                          3
// <o> "SD_D3_A" GPIO pin alternate function <0-7>
#define BOARD_SD_D3_ALTERNATE_FUNCTION                  6

// <o> "SD_D4_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_SD_D4_A_GPIO_PORT                         5
// <o> "SD_D4_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_SD_D4_A_GPIO_PIN                          4

// <o> "SD_D5_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_SD_D5_A_GPIO_PORT                         5
// <o> "SD_D5_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_SD_D5_A_GPIO_PIN                          5

// <o> "SD_D6_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_SD_D6_A_GPIO_PORT                         5
// <o> "SD_D6_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_SD_D6_A_GPIO_PIN                          6

// <o> "SD_D7_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_SD_D7_A_GPIO_PORT                         5
// <o> "SD_D7_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_SD_D7_A_GPIO_PIN                          7

// <o> "I2C1_SDA_C" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_I2C1_SDA_C_GPIO_PORT                      7
// <o> "I2C1_SDA_C" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_I2C1_SDA_C_GPIO_PIN                       2

// <o> "I2C1_SCL_C" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_I2C1_SCL_C_GPIO_PORT                      7
// <o> "I2C1_SCL_C" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_I2C1_SCL_C_GPIO_PIN                       3

// <o> "LPI2S_SDO_C" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPI2S_SDO_C_GPIO_PORT                     13
// <o> "LPI2S_SDO_C" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_LPI2S_SDO_C_GPIO_PIN                      5

// <o> "LPI2S_WS_C" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPI2S_WS_C_GPIO_PORT                      13
// <o> "LPI2S_WS_C" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LPI2S_WS_C_GPIO_PIN                       7

// <o> "LPI2S_SCLK_C" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPI2S_SCLK_C_GPIO_PORT                    13
// <o> "LPI2S_SCLK_C" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_LPI2S_SCLK_C_GPIO_PIN                     6

// <o> "I2S3_WS_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_I2S3_WS_B_GPIO_PORT                       8
// <o> "I2S3_WS_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_I2S3_WS_B_GPIO_PIN                        7

// <o> "I2S3_SCLK_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_I2S3_SCLK_B_GPIO_PORT                     8
// <o> "I2S3_SCLK_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_I2S3_SCLK_B_GPIO_PIN                      6

// <o> "I2S3_SDI_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_I2S3_SDI_B_GPIO_PORT                      9
// <o> "I2S3_SDI_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_I2S3_SDI_B_GPIO_PIN                       0

// <o> "I2S1_SDO_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_I2S1_SDO_GPIO_PORT                        3
// <o> "I2S1_SDO_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_I2S1_SDO_GPIO_PIN                         3

// <o> "I2S1_WS_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_I2S1_WS_GPIO_PORT                         4
// <o> "I2S1_WS_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_I2S1_WS_GPIO_PIN                          0

// <o> "I2S1_SCLK_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_I2S1_SCLK_GPIO_PORT                       3
// <o> "I2S1_SCLK_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_I2S1_SCLK_GPIO_PIN                        4

// <o> "LPPDM_TEST" LPPDM data/clock pair number <0=> D0/C0 <1=> D1/C1 <2=> D2/C2 <3=> D3/C3
#define BOARD_LPPDM_TEST_LPPDM_INPUT                    1

// <o> "LPPDM_D0_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPPDM_D0_GPIO_PORT                        3
// <o> "LPPDM_D0_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LPPDM_D0_GPIO_PIN                         5
// <o> "LPPDM_D0_B" GPIO pin alternate function <0-7>
#define BOARD_LPPDM_D0_ALTERNATE_FUNCTION               3

// <o> "LPPDM_D1_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPPDM_D1_GPIO_PORT                        3
// <o> "LPPDM_D1_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LPPDM_D1_GPIO_PIN                         7
// <o> "LPPDM_D1_B" GPIO pin alternate function <0-7>
#define BOARD_LPPDM_D1_ALTERNATE_FUNCTION               3

// <o> "LPPDM_D2_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPPDM_D2_GPIO_PORT                        11
// <o> "LPPDM_D2_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LPPDM_D2_GPIO_PIN                         6
// <o> "LPPDM_D2_B" GPIO pin alternate function <0-7>
#define BOARD_LPPDM_D2_ALTERNATE_FUNCTION               3

// <o> "LPPDM_D3_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPPDM_D3_GPIO_PORT                        7
// <o> "LPPDM_D3_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LPPDM_D3_GPIO_PIN                         7
// <o> "LPPDM_D3_A" GPIO pin alternate function <0-7>
#define BOARD_LPPDM_D3_ALTERNATE_FUNCTION               4

// <o> "LPPDM_C0_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPPDM_C0_GPIO_PORT                        3
// <o> "LPPDM_C0_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LPPDM_C0_GPIO_PIN                         4
// <o> "LPPDM_C0_B" GPIO pin alternate function <0-7>
#define BOARD_LPPDM_C0_ALTERNATE_FUNCTION               3

// <o> "LPPDM_C1_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPPDM_C1_GPIO_PORT                        3
// <o> "LPPDM_C1_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LPPDM_C1_GPIO_PIN                         6
// <o> "LPPDM_C1_B" GPIO pin alternate function <0-7>
#define BOARD_LPPDM_C1_ALTERNATE_FUNCTION               3

// <o> "LPPDM_C2_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPPDM_C2_GPIO_PORT                        11
// <o> "LPPDM_C2_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LPPDM_C2_GPIO_PIN                         2
// <o> "LPPDM_C2_B" GPIO pin alternate function <0-7>
#define BOARD_LPPDM_C2_ALTERNATE_FUNCTION               3

// <o> "LPPDM_C3_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPPDM_C3_GPIO_PORT                        7
// <o> "LPPDM_C3_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LPPDM_C3_GPIO_PIN                         6
// <o> "LPPDM_C3_A" GPIO pin alternate function <0-7>
#define BOARD_LPPDM_C3_ALTERNATE_FUNCTION               4

// <o> "PDM_D0_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_PDM_D0_A_GPIO_PORT                        0
// <o> "PDM_D0_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_PDM_D0_A_GPIO_PIN                         4

// <o> "PDM_D1_C" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_PDM_D1_C_GPIO_PORT                        6
// <o> "PDM_D1_C" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_PDM_D1_C_GPIO_PIN                         2

// <o> "PDM_D2_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_PDM_D2_B_GPIO_PORT                        5
// <o> "PDM_D2_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_PDM_D2_B_GPIO_PIN                         4

// <o> "PDM_D3_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_PDM_D3_A_GPIO_PORT                        5
// <o> "PDM_D3_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_PDM_D3_A_GPIO_PIN                         1

// <o> "PDM_C0_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_PDM_C0_A_GPIO_PORT                        0
// <o> "PDM_C0_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_PDM_C0_A_GPIO_PIN                         5

// <o> "PDM_C1_C" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_PDM_C1_C_GPIO_PORT                        6
// <o> "PDM_C1_C" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_PDM_C1_C_GPIO_PIN                         3

// <o> "PDM_C2_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_PDM_C2_A_GPIO_PORT                        6
// <o> "PDM_C2_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_PDM_C2_A_GPIO_PIN                         7

// <o> "PDM_C3_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_PDM_C3_A_GPIO_PORT                        5
// <o> "PDM_C3_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_PDM_C3_A_GPIO_PIN                         2

// <o> "TOUCH_RESET" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_TOUCH_RESET_GPIO_PORT                     6
// <o> "TOUCH_RESET" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_TOUCH_RESET_GPIO_PIN                      5

// <o> "UT_TRIGGER_MODE_GPO0" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=>
// GPIO4 <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=>
// GPIO12 <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_UT_TRIGGER_MODE_GPO0_GPIO_PORT            3
// <o> "UT_TRIGGER_MODE_GPO0" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=>
// PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_UT_TRIGGER_MODE_GPIO0_GPIO_PIN            5

// <o> "UTIMER_GPO1" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_UT_TRIGGER_MODE_GPO1_GPIO_PORT            3
// <o> "UTIMER_GPO1" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_UT_TRIGGER_MODE_GPO1_GPIO_PIN             6

// <o> "UT_CAPTURE_MODE_GPO0" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=>
// GPIO4 <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=>
// GPIO12 <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_UT_CAPTURE_MODE_GPO0_GPIO_PORT            3
// <o> "UT_CAPTURE_MODE_GPO0" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=>
// PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_UT_CAPTURE_MODE_GPO0_GPIO_PIN             3

// <o> "UT_CAPTURE_MODE_GPO1" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=>
// GPIO4 <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=>
// GPIO12 <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_UT_CAPTURE_MODE_GPO1_GPIO_PORT            3
// <o> "UT_CAPTURE_MODE_GPO1" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=>
// PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_UT_CAPTURE_MODE_GPO1_GPIO_PIN             4

// <o> "UT_TRIGGER_MODE_T0_GPO" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=>
// GPIO4 <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=>
// GPIO12 <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_UT_TRIGGER_MODE_T0_GPO_GPIO_PORT          0
// <o> "UT_TRIGGER_MODE_T0_GPO" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4
// <5=> PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_UT_TRIGGER_MODE_T0_GPO_GPIO_PIN           6
// <o> "UT_TRIGGER_MODE_T0_GPO" GPIO pin alternate function <0-7>
#define BOARD_UT_TRIGGER_MODE_T0_GPO_ALTERNATE_FUNCTION 5

// <o> "UT_TRIGGER_MODE_T1_GPO" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=>
// GPIO4 <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=>
// GPIO12 <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_UT_TRIGGER_MODE_T1_GPO_GPIO_PORT          0
// <o> "UT_TRIGGER_MODE_T1_GPO" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4
// <5=> PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_UT_TRIGGER_MODE_T1_GPO_GPIO_PIN           7
// <o> "UT_TRIGGER_MODE_T1_GPO" GPIO pin alternate function <0-7>
#define BOARD_UT_TRIGGER_MODE_T1_GPO_ALTERNATE_FUNCTION 5

// <o> "UT_CAPTURE_MODE_T0_GPO" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=>
// GPIO4 <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=>
// GPIO12 <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_UT_CAPTURE_MODE_T0_GPO_GPIO_PORT          1
// <o> "UT_CAPTURE_MODE_T0_GPO" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4
// <5=> PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_UT_CAPTURE_MODE_T0_GPO_GPIO_PIN           0
// <o> "UT_CAPTURE_MODE_T0_GPO" GPIO pin alternate function <0-7>
#define BOARD_UT_CAPTURE_MODE_T0_GPO_ALTERNATE_FUNCTION 4

// <o> "UT_CAPTURE_MODE_T1_GPO" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=>
// GPIO4 <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=>
// GPIO12 <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_UT_CAPTURE_MODE_T1_GPO_GPIO_PORT          1
// <o> "UT_CAPTURE_MODE_T1_GPO" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4
// <5=> PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_UT_CAPTURE_MODE_T1_GPO_GPIO_PIN           1
// <o> "UT_CAPTURE_MODE_T1_GPO" GPIO pin alternate function <0-7>
#define BOARD_UT_CAPTURE_MODE_T1_GPO_ALTERNATE_FUNCTION 4

// <o> "UT_COMPARE_MODE_T0_GPO" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=>
// GPIO4 <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=>
// GPIO12 <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_UT_COMPARE_MODE_T0_GPO_GPIO_PORT          1
// <o> "UT_COMPARE_MODE_T0_GPO" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4
// <5=> PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_UT_COMPARE_MODE_T0_GPO_GPIO_PIN           2
// <o> "UT_COMPARE_MODE_T0_GPO" GPIO pin alternate function <0-7>
#define BOARD_UT_COMPARE_MODE_T0_GPO_ALTERNATE_FUNCTION 4

// <o> "QEC0_X_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_QEC0_X_B_GPIO_PORT                        8
// <o> "QEC0_X_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_QEC0_X_B_GPIO_PIN                         4

// <o> "QEC0_Y_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_QEC0_Y_B_GPIO_PORT                        8
// <o> "QEC0_Y_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_QEC0_Y_B_GPIO_PIN                         5

// <o> "QEC0_Z_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_QEC0_Z_B_GPIO_PORT                        8
// <o> "QEC0_Z_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_QEC0_Z_B_GPIO_PIN                         6

// <o> "QEC_X_GPO" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_QEC_X_GPO_GPIO_PORT                       1
// <o> "QEC0_X_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_QEC_X_GPO_GPIO_PIN                        0

// <o> "QEC_Y_GPO" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_QEC_Y_GPO_GPIO_PORT                       1
// <o> "QEC_Y_GPO" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_QEC_Y_GPO_GPIO_PIN                        1

// <o> "QEC_Z_GPO" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_QEC_Z_GPO_GPIO_PORT                       1
// <o> "QEC_Z_GPO" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_QEC_Z_GPO_GPIO_PIN                        2

// <o> "PDM_MIC" PDM data/clock pair number <0=> D0/C0 <1=> D1/C1 <2=> D2/C2 <3=> D3/C3
#define BOARD_PDM_MIC_PDM_INPUT                         2

// <o> "LCD_BACKLIGHT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LCD_BACKLIGHT_GPIO_PORT                   6
// <o> "LCD_BACKLIGHT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_LCD_BACKLIGHT_GPIO_PIN                    1

// <o> "LEDRGB1_R" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LEDRGB1_R_GPIO_PORT                       6
// <o> "LEDRGB1_R" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LEDRGB1_R_GPIO_PIN                        2
// <o> "LEDRGB1_R" GPIO pin alternate function <0-7>
#define BOARD_LEDRGB1_R_ALTERNATE_FUNCTION              0

// <o> "LEDRGB1_G" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LEDRGB1_G_GPIO_PORT                       6
// <o> "LEDRGB1_G" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LEDRGB1_G_GPIO_PIN                        4
// <o> "LEDRGB1_G" GPIO pin alternate function <0-7>
#define BOARD_LEDRGB1_G_ALTERNATE_FUNCTION              0

// <o> "LEDRGB1_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LEDRGB1_B_GPIO_PORT                       6
// <o> "LEDRGB1_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LEDRGB1_B_GPIO_PIN                        6
// <o> "LEDRGB1_B" GPIO pin alternate function <0-7>
#define BOARD_LEDRGB1_B_ALTERNATE_FUNCTION              0

// <o> "CAN_RXD" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAN_RXD_GPIO_PORT                         0
// <o> "CAN_RXD_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CAN_RXD_GPIO_PIN                          4
// <o> "CAN_RXD" GPIO pin alternate function <0-7>
#define BOARD_CAN_RXD_ALTERNATE_FUNCTION                6

// <o> "CAN_TXD" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAN_TXD_GPIO_PORT                         0
// <o> "CAN_TXD" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CAN_TXD_GPIO_PIN                          5
// <o> "CAN_TXD" GPIO pin alternate function <0-7>
#define BOARD_CAN_TXD_ALTERNATE_FUNCTION                6

// <o> "CAN_STBY" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAN_STBY_GPIO_PORT                        0
// <o> "CAN_STBY" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CAN_STBY_GPIO_PIN                         6
// <o> "CAN_STBY" GPIO pin alternate function <0-7>
#define BOARD_CAN_STBY_ALTERNATE_FUNCTION               6

// <o> "CAM_XVCLK_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAM_XVCLK_A_GPIO_PORT                     0
// <o> "CAM_XVCLK_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CAM_XVCLK_A_GPIO_PIN                      3

// <o> "CAMERA_POWER" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAMERA_POWER_GPIO_PORT                    7
// <o> "CAMERA_POWER" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CAMERA_POWER_GPIO_PIN                     5

// <o> "I2C1_SDA_C" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAMERA_I2C_SDA_GPIO_PORT                  7
// <o> "I2C1_SDA_C" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CAMERA_I2C_SDA_GPIO_PIN                   2
// <o> "I2C1_SDA_C" GPIO pin alternate function <0-7>
#define BOARD_CAMERA_I2C_SDA_ALTERNATE_FUNCTION         5

// <o> "I2C1_SCL_C" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAMERA_I2C_SCL_GPIO_PORT                  7
// <o> "I2C1_SCL_C" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CAMERA_I2C_SCL_GPIO_PIN                   3
// <o> "I2C1_SCL_C" GPIO pin alternate function <0-7>
#define BOARD_CAMERA_I2C_SCL_ALTERNATE_FUNCTION         5

// <o> "CAM_HSYNC_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAM_HSYNC_GPIO_PORT                       0
// <o> "CAM_HSYNC_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CAM_HSYNC_GPIO_PIN                        0
// <o> "CAM_HSYNC_A" GPIO pin alternate function <0-7>
#define BOARD_CAM_HSYNC_ALTERNATE_FUNCTION              6

// <o> "CAM_VSYNC_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAM_VSYNC_GPIO_PORT                       0
// <o> "CAM_VSYNC_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CAM_VSYNC_GPIO_PIN                        1
// <o> "CAM_VSYNC_A" GPIO pin alternate function <0-7>
#define BOARD_CAM_VSYNC_ALTERNATE_FUNCTION              6

// <o> "CAM_PCLK_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAM_PCLK_GPIO_PORT                        0
// <o> "CAM_PCLK_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CAM_PCLK_GPIO_PIN                         2
// <o> "CAM_PCLK_A" GPIO pin alternate function <0-7>
#define BOARD_CAM_PCLK_ALTERNATE_FUNCTION               6

// <o> "CAM_D0_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAM_D0_GPIO_PORT                          8
// <o> "CAM_D0_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CAM_D0_GPIO_PIN                           0
// <o> "CAM_D0_B" GPIO pin alternate function <0-7>
#define BOARD_CAM_D0_ALTERNATE_FUNCTION                 7

// <o> "CAM_D1_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAM_D1_GPIO_PORT                          8
// <o> "CAM_D1_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CAM_D1_GPIO_PIN                           1
// <o> "CAM_D1_B" GPIO pin alternate function <0-7>
#define BOARD_CAM_D1_ALTERNATE_FUNCTION                 6

// <o> "CAM_D2_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAM_D2_GPIO_PORT                          8
// <o> "CAM_D2_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CAM_D2_GPIO_PIN                           2
// <o> "CAM_D2_B" GPIO pin alternate function <0-7>
#define BOARD_CAM_D2_ALTERNATE_FUNCTION                 7

// <o> "CAM_D3_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAM_D3_GPIO_PORT                          8
// <o> "CAM_D3_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CAM_D3_GPIO_PIN                           3
// <o> "CAM_D3_B" GPIO pin alternate function <0-7>
#define BOARD_CAM_D3_ALTERNATE_FUNCTION                 7

// <o> "CAM_D4_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAM_D4_GPIO_PORT                          8
// <o> "CAM_D4_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CAM_D4_GPIO_PIN                           4
// <o> "CAM_D4_B" GPIO pin alternate function <0-7>
#define BOARD_CAM_D4_ALTERNATE_FUNCTION                 7

// <o> "CAM_D5_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAM_D5_GPIO_PORT                          8
// <o> "CAM_D5_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CAM_D5_GPIO_PIN                           5
// <o> "CAM_D5_B" GPIO pin alternate function <0-7>
#define BOARD_CAM_D5_ALTERNATE_FUNCTION                 7

// <o> "CAM_D6_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAM_D6_GPIO_PORT                          8
// <o> "CAM_D6_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CAM_D6_GPIO_PIN                           6
// <o> "CAM_D6_B" GPIO pin alternate function <0-7>
#define BOARD_CAM_D6_ALTERNATE_FUNCTION                 7

// <o> "CAM_D7_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAM_D7_GPIO_PORT                          8
// <o> "CAM_D7_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CAM_D7_GPIO_PIN                           7
// <o> "CAM_D7_B" GPIO pin alternate function <0-7>
#define BOARD_CAM_D7_ALTERNATE_FUNCTION                 7

// <o> "LPCAM_HSYNC_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPCAM_HSYNC_GPIO_PORT                     0
// <o> "LPCAM_HSYNC_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_LPCAM_HSYNC_GPIO_PIN                      0
// <o> "LPCAM_HSYNC_B" GPIO pin alternate function <0-7>
#define BOARD_LPCAM_HSYNC_ALTERNATE_FUNCTION            5

// <o> "LPCAM_VSYNC_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPCAM_VSYNC_GPIO_PORT                     0
// <o> "LPCAM_VSYNC_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_LPCAM_VSYNC_GPIO_PIN                      1
// <o> "LPCAM_VSYNC_B" GPIO pin alternate function <0-7>
#define BOARD_LPCAM_VSYNC_ALTERNATE_FUNCTION            5

// <o> "LPCAM_PCLK_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPCAM_PCLK_GPIO_PORT                      0
// <o> "LPCAM_PCLK_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_LPCAM_PCLK_GPIO_PIN                       2
// <o> "LPCAM_PCLK_B" GPIO pin alternate function <0-7>
#define BOARD_LPCAM_PCLK_ALTERNATE_FUNCTION             5

// <o> "LPCAM_D0_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPCAM_D0_GPIO_PORT                        8
// <o> "LPCAM_D0_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LPCAM_D0_GPIO_PIN                         0
// <o> "LPCAM_D0_A" GPIO pin alternate function <0-7>
#define BOARD_LPCAM_D0_ALTERNATE_FUNCTION               4

// <o> "LPCAM_D1_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPCAM_D1_GPIO_PORT                        8
// <o> "LPCAM_D1_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LPCAM_D1_GPIO_PIN                         1
// <o> "LPCAM_D0_A" GPIO pin alternate function <0-7>
#define BOARD_LPCAM_D1_ALTERNATE_FUNCTION               3

// <o> "LPCAM_D2_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPCAM_D2_GPIO_PORT                        8
// <o> "LPCAM_D2_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LPCAM_D2_GPIO_PIN                         2
// <o> "LPCAM_D0_A" GPIO pin alternate function <0-7>
#define BOARD_LPCAM_D2_ALTERNATE_FUNCTION               4

// <o> "LPCAM_D3_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPCAM_D3_GPIO_PORT                        8
// <o> "LPCAM_D3_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LPCAM_D3_GPIO_PIN                         3
// <o> "LPCAM_D0_A" GPIO pin alternate function <0-7>
#define BOARD_LPCAM_D3_ALTERNATE_FUNCTION               4

// <o> "LPCAM_D4_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPCAM_D4_GPIO_PORT                        8
// <o> "LPCAM_D4_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LPCAM_D4_GPIO_PIN                         4
// <o> "LPCAM_D0_A" GPIO pin alternate function <0-7>
#define BOARD_LPCAM_D4_ALTERNATE_FUNCTION               4

// <o> "LPCAM_D5_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPCAM_D5_GPIO_PORT                        8
// <o> "LPCAM_D5_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LPCAM_D5_GPIO_PIN                         5
// <o> "LPCAM_D0_A" GPIO pin alternate function <0-7>
#define BOARD_LPCAM_D5_ALTERNATE_FUNCTION               4

// <o> "LPCAM_D6_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPCAM_D6_GPIO_PORT                        8
// <o> "LPCAM_D6_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LPCAM_D6_GPIO_PIN                         6
// <o> "LPCAM_D0_A" GPIO pin alternate function <0-7>
#define BOARD_LPCAM_D6_ALTERNATE_FUNCTION               4

// <o> "LPCAM_D7_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPCAM_D7_GPIO_PORT                        8
// <o> "LPCAM_D7_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LPCAM_D7_GPIO_PIN                         7
// <o> "LPCAM_D0_A" GPIO pin alternate function <0-7>
#define BOARD_LPCAM_D7_ALTERNATE_FUNCTION               4

// <o> "LPI2C0_SDA_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPI2C0_SDA_GPIO_PORT                      7
// <o> "LPI2C0_SDA_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_LPI2C0_SDA_GPIO_PIN                       5
// <o> "LPI2C0_SDA_A" GPIO pin alternate function <0-7>
#define BOARD_LPI2C0_SDA_ALTERNATE_FUNCTION             6

// <o> "LPI2C0_SCL_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPI2C0_SCL_GPIO_PORT                      7
// <o> "LPI2C0_SCL_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_LPI2C0_SCL_GPIO_PIN                       4
// <o> "LPI2C0_SCL_A" GPIO pin alternate function <0-7>
#define BOARD_LPI2C0_SCL_ALTERNATE_FUNCTION             5

// <o> "I2C0_SDA_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_I2C0_SDA_GPIO_PORT                        3
// <o> "I2C0_SDA_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_I2C0_SDA_GPIO_PIN                         5
// <o> "I2C0_SDA_B" GPIO pin alternate function <0-7>
#define BOARD_I2C0_SDA_ALTERNATE_FUNCTION               5

// <o> "I2C0_SCL_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_I2C0_SCL_GPIO_PORT                        3
// <o> "I2C0_SCL_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_I2C0_SCL_GPIO_PIN                         4
// <o> "I2C0_SCL_B" GPIO pin alternate function <0-7>
#define BOARD_I2C0_SCL_ALTERNATE_FUNCTION               5

// <o> "Master" MW SPI instance number <0-3>
#define BOARD_MW_SPI_MASTER_INSTANCE                    2

// <o> "Slave" MW SPI instance number <0-3>
#define BOARD_MW_SPI_SLAVE_INSTANCE                     3

// <o> baudrate for Microwire SPI
#define BOARD_MW_SPI_MASTER_BUS_SPEED                   1000000

// <o>  "LPSPI_MISO" master GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=>
// GPIO4 <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=>
// GPIO12 <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPSPI_MISO_GPIO_PORT                      7
// <o> "LPSPI_MISO" masterGPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=>
// PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_LPSPI_MISO_GPIO_PIN                       4
// <o> "LPSPI_MISO" GPIO pin alternate function <0-7>
#define BOARD_LPSPI_MISO_ALTERNATE_FUNCTION             4

// <o>  "LPSPI_MOSI" master GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=>
// GPIO4 <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=>
// GPIO12 <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPSPI_MOSI_GPIO_PORT                      7
// <o> "LPSPI_MOSI" masterGPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=>
// PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_LPSPI_MOSI_GPIO_PIN                       5
// <o> "LPSPI_MOSI" GPIO pin alternate function <0-7>
#define BOARD_LPSPI_MOSI_ALTERNATE_FUNCTION             5

// <o>  "LPSPI_SCLK" master GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=>
// GPIO4 <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=>
// GPIO12 <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPSPI_SCLK_GPIO_PORT                      7
// <o> "LPSPI_SCLK" masterGPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=>
// PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_LPSPI_SCLK_GPIO_PIN                       6
// <o> "LPSPI_SCLK" GPIO pin alternate function <0-7>
#define BOARD_LPSPI_SCLK_ALTERNATE_FUNCTION             5

// <o>  "LPSPI_SS" master GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4
// <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12
// <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPSPI_SS_GPIO_PORT                        7
// <o> "LPSPI_SS" masterGPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=>
// PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_LPSPI_SS_GPIO_PIN                         7
// <o> "LPSPI_SS" GPIO pin alternate function <0-7>
#define BOARD_LPSPI_SS_ALTERNATE_FUNCTION               5

// <o> "SPI0_MISO" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_SPI0_MISO_GPIO_PORT                       1
// <o>  "SPI0_MISO"GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_SPI0_MISO_GPIO_PIN                        0
// <o> "SPI0_MISO" GPIO pin alternate function <0-7>
#define BOARD_SPI0_MISO_ALTERNATE_FUNCTION              2

// <o> "SPI0_MOSI" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_SPI0_MOSI_GPIO_PORT                       1
// <o> "SPI0_MOSI" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_SPI0_MOSI_GPIO_PIN                        1
// <o> "SPI0_MOSI" GPIO pin alternate function <0-7>
#define BOARD_SPI0_MOSI_ALTERNATE_FUNCTION              2

// <o> "SPI0_SCLK" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_SPI0_SCLK_GPIO_PORT                       1
// <o> "SPI0_SCLK" SPI slave GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4
// <5=> PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_SPI0_SCLK_GPIO_PIN                        2
// <o> "SPI0_SCLK" GPIO pin alternate function <0-7>
#define BOARD_SPI0_SCLK_ALTERNATE_FUNCTION              2

// <o> "SPI0_SS0" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_SPI0_SS0_GPIO_PORT                        1
// <o> "SPI0_SS0"  GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_SPI0_SS0_GPIO_PIN                         3
// <o> "SPI0_SS0" GPIO pin alternate function <0-7>
#define BOARD_SPI0_SS0_ALTERNATE_FUNCTION               2

// <o> "SPI1_MISO" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_SPI1_MISO_GPIO_PORT                       8
// <o>  "SPI1_MISO"GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_SPI1_MISO_GPIO_PIN                        3
// <o> "SPI1_MISO" GPIO pin alternate function <0-7>
#define BOARD_SPI1_MISO_ALTERNATE_FUNCTION              2

// <o> "SPI1_MOSI" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_SPI1_MOSI_GPIO_PORT                       8
// <o> "SPI1_MOSI" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_SPI1_MOSI_GPIO_PIN                        4
// <o> "SPI1_MOSI" GPIO pin alternate function <0-7>
#define BOARD_SPI1_MOSI_ALTERNATE_FUNCTION              2

// <o> "SPI1_SCLK" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_SPI1_SCLK_GPIO_PORT                       8
// <o> "SPI1_SCLK" SPI slave GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4
// <5=> PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_SPI1_SCLK_GPIO_PIN                        5
// <o> "SPI1_SCLK" GPIO pin alternate function <0-7>
#define BOARD_SPI1_SCLK_ALTERNATE_FUNCTION              2

// <o> "SPI1_SS0" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_SPI1_SS0_GPIO_PORT                        6
// <o> "SPI1_SS0"  GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_SPI1_SS0_GPIO_PIN                         4
// <o> "SPI1_SS0" GPIO pin alternate function <0-7>
#define BOARD_SPI1_SS0_ALTERNATE_FUNCTION               4

// <o> "MW_SPI_MASTER_MISO" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=>
// GPIO4 <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=>
// GPIO12 <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_MW_SPI_MASTER_MISO_GPIO_PORT              9
// <o>  "MW_SPI_MASTER_MISO" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4
// <5=> PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_MW_SPI_MASTER_MISO_GPIO_PIN               2
// <o> "MW_SPI_MASTER_MISO" GPIO pin alternate function <0-7>
#define BOARD_MW_SPI_MASTER_MISO_ALTERNATE_FUNCTION     3

// <o> "MW_SPI_MASTER_MOSI" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=>
// GPIO4 <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=>
// GPIO12 <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_MW_SPI_MASTER_MOSI_GPIO_PORT              9
// <o> "MW_SPI_MASTER_MOSI" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=>
// PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_MW_SPI_MASTER_MOSI_GPIO_PIN               3
// <o> "MW_SPI_MASTER_MOSI" GPIO pin alternate function <0-7>
#define BOARD_MW_SPI_MASTER_MOSI_ALTERNATE_FUNCTION     4

// <o> "MW_SPI_MASTER_SCLK" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=>
// GPIO4 <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=>
// GPIO12 <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_MW_SPI_MASTER_SCLK_GPIO_PORT              9
// <o> "MW_SPI_MASTER_SCLK" SPI slave GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=>
// PIN4 <5=> PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_MW_SPI_MASTER_SCLK_GPIO_PIN               4
// <o> "MW_SPI_MASTER_SCLK" GPIO pin alternate function <0-7>
#define BOARD_MW_SPI_MASTER_SCLK_ALTERNATE_FUNCTION     3

// <o> "MW_SPI_MASTER_SS0" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4
// <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12
// <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_MW_SPI_MASTER_SS0_GPIO_PORT               9
// <o> "MW_SPI_MASTER_SS0"  GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=>
// PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_MW_SPI_MASTER_SS0_GPIO_PIN                5
// <o> "MW_SPI_MASTER_SS0" GPIO pin alternate function <0-7>
#define BOARD_MW_SPI_MASTER_SS0_ALTERNATE_FUNCTION      3

// <o> "MW_SPI_SLAVE_MISO" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4
// <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12
// <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_MW_SPI_SLAVE_MISO_GPIO_PORT               12
// <o>  "MW_SPI_SLAVE_MISO"GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=>
// PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_MW_SPI_SLAVE_MISO_GPIO_PIN                4
// <o> "MW_SPI_SLAVE_MISO" GPIO pin alternate function <0-7>
#define BOARD_MW_SPI_SLAVE_MISO_ALTERNATE_FUNCTION      2

// <o> "MW_SPI_SLAVE_MOSI" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4
// <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12
// <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_MW_SPI_SLAVE_MOSI_GPIO_PORT               12
// <o> "MW_SPI_SLAVE_MOSI" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=>
// PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_MW_SPI_SLAVE_MOSI_GPIO_PIN                5
// <o> "MW_SPI_SLAVE_MOSI" GPIO pin alternate function <0-7>
#define BOARD_MW_SPI_SLAVE_MOSI_ALTERNATE_FUNCTION      2

// <o> "MW_SPI_SLAVE_SCLK" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4
// <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12
// <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_MW_SPI_SLAVE_SCLK_GPIO_PORT               12
// <o> "MW_SPI_SLAVE_SCLK" SPI slave GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=>
// PIN4 <5=> PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_MW_SPI_SLAVE_SCLK_GPIO_PIN                6
// <o> "MW_SPI_SLAVE_SCLK" GPIO pin alternate function <0-7>
#define BOARD_MW_SPI_SLAVE_SCLK_ALTERNATE_FUNCTION      2

// <o> "MW_SPI_SLAVE_SS0" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4
// <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12
// <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_MW_SPI_SLAVE_SS0_GPIO_PORT                12
// <o> "MW_SPI_SLAVE_SS0"  GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=>
// PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_MW_SPI_SLAVE_SS0_GPIO_PIN                 7
// <o> "MW_SPI_SLAVE_SS0" GPIO pin alternate function <0-7>
#define BOARD_MW_SPI_SLAVE_SS0_ALTERNATE_FUNCTION       3

// <o> "LPUART_RX_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPUART_RX_GPIO_PORT                       7
// <o> "LPUART_RX_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_LPUART_RX_GPIO_PIN                        6
// <o> "LPUART_RX_A" GPIO pin alternate function <0-7>
#define BOARD_LPUART_RX_ALTERNATE_FUNCTION              2

// <o> "LPUART_TX_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LPUART_TX_GPIO_PORT                       7
// <o> "LPUART_TX_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_LPUART_TX_GPIO_PIN                        7
// <o> "LPUART_TX_A" GPIO pin alternate function <0-7>
#define BOARD_LPUART_TX_ALTERNATE_FUNCTION              2

// <o> "CDC_PCLK_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_PCLK_GPIO_PORT                        5
// <o> "CDC_PCLK_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_PCLK_GPIO_PIN                         3
// <o> "CDC_PCLK_A" GPIO pin alternate function <0-7>
#define BOARD_CDC_PCLK_ALTERNATE_FUNCTION               7

// <o> "CDC_DE_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_DE_GPIO_PORT                          5
// <o> "CDC_DE_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_DE_GPIO_PIN                           4
// <o> "CDC_DE_A" GPIO pin alternate function <0-7>
#define BOARD_CDC_DE_ALTERNATE_FUNCTION                 7

// <o> "CDC_HSYNC_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_HSYNC_GPIO_PORT                       4
// <o> "CDC_HSYNC_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CDC_HSYNC_GPIO_PIN                        1
// <o> "CDC_HSYNC_A" GPIO pin alternate function <0-7>
#define BOARD_CDC_HSYNC_ALTERNATE_FUNCTION              6

// <o> "CDC_VSYNC_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_VSYNC_GPIO_PORT                       4
// <o> "CDC_VSYNC_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CDC_VSYNC_GPIO_PIN                        0
// <o> "CDC_VSYNC_A" GPIO pin alternate function <0-7>
#define BOARD_CDC_VSYNC_ALTERNATE_FUNCTION              6

// <o> "CDC_D0_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D0_GPIO_PORT                          11
// <o> "CDC_D0_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D0_GPIO_PIN                           0
// <o> "CDC_D0_B" GPIO pin alternate function <0-7>
#define BOARD_CDC_D0_ALTERNATE_FUNCTION                 7

// <o> "CDC_D1_A"GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D1_GPIO_PORT                          8
// <o> "CDC_D1_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D1_GPIO_PIN                           1
// <o> "CDC_D1_A" GPIO pin alternate function <0-7>
#define BOARD_CDC_D1_ALTERNATE_FUNCTION                 5

// <o> "CDC_D2_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D2_GPIO_PORT                          8
// <o> "CDC_D2_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D2_GPIO_PIN                           2
// <o> "CDC_D2_A" GPIO pin alternate function <0-7>
#define BOARD_CDC_D2_ALTERNATE_FUNCTION                 6

// <o> "CDC_D3_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D3_GPIO_PORT                          8
// <o> "CDC_D3_A"  GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D3_GPIO_PIN                           3
// <o> "CDC_D3_A" GPIO pin alternate function <0-7>
#define BOARD_CDC_D3_ALTERNATE_FUNCTION                 6

// <o> "CDC_D4_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D4_GPIO_PORT                          8
// <o> "CDC_D4_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D4_GPIO_PIN                           4
// <o> "CDC_D4_A" GPIO pin alternate function <0-7>
#define BOARD_CDC_D4_ALTERNATE_FUNCTION                 6

// <o> "CDC_D5_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D5_GPIO_PORT                          11
// <o> "CDC_D5_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D5_GPIO_PIN                           5
// <o> "CDC_D5_B" GPIO pin alternate function <0-7>
#define BOARD_CDC_D5_ALTERNATE_FUNCTION                 7

// <o> "CDC_D6_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D6_GPIO_PORT                          11
// <o> "CDC_D6_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D6_GPIO_PIN                           6
// <o> "CDC_D6_B" GPIO pin alternate function <0-7>
#define BOARD_CDC_D6_ALTERNATE_FUNCTION                 7

// <o> "CDC_D7_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D7_GPIO_PORT                          11
// <o> "CDC_D7_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D7_GPIO_PIN                           7
// <o> "CDC_D7_B" GPIO pin alternate function <0-7>
#define BOARD_CDC_D7_ALTERNATE_FUNCTION                 7

// <o> "CDC_D8_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D8_GPIO_PORT                          9
// <o> "CDC_D8_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D8_GPIO_PIN                           0
// <o> "CDC_D8_A" GPIO pin alternate function <0-7>
#define BOARD_CDC_D8_ALTERNATE_FUNCTION                 5

// <o> "CDC_D9_A"GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D9_GPIO_PORT                          9
// <o> "CDC_D9_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D9_GPIO_PIN                           1
// <o> "CDC_D9_A" GPIO pin alternate function <0-7>
#define BOARD_CDC_D9_ALTERNATE_FUNCTION                 6

// <o> "CDC_D10_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D10_GPIO_PORT                         9
// <o> "CDC_D10_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D10_GPIO_PIN                          2
// <o> "CDC_D10_A" GPIO pin alternate function <0-7>
#define BOARD_CDC_D10_ALTERNATE_FUNCTION                6

// <o> "CDC_D11_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D11_GPIO_PORT                         9
// <o> "CDC_D11_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D11_GPIO_PIN                          3
// <o> "CDC_D11_A" GPIO pin alternate function <0-7>
#define BOARD_CDC_D11_ALTERNATE_FUNCTION                6

// <o> "CDC_D12_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D12_GPIO_PORT                         9
// <o> "CDC_D12_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D12_GPIO_PIN                          4
// <o> "CDC_D12_A" GPIO pin alternate function <0-7>
#define BOARD_CDC_D12_ALTERNATE_FUNCTION                6

// <o> "CDC_D13_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D13_GPIO_PORT                         12
// <o> "CDC_D13_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D13_GPIO_PIN                          5
// <o> "CDC_D13_B" GPIO pin alternate function <0-7>
#define BOARD_CDC_D13_ALTERNATE_FUNCTION                5

// <o> "CDC_D14_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D14_GPIO_PORT                         12
// <o> "CDC_D14_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D14_GPIO_PIN                          6
// <o> "CDC_D14_B" GPIO pin alternate function <0-7>
#define BOARD_CDC_D14_ALTERNATE_FUNCTION                5

// <o> "CDC_D15_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D15_GPIO_PORT                         12
// <o> "CDC_D15_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D15_GPIO_PIN                          7
// <o> "CDC_D15_B" GPIO pin alternate function <0-7>
#define BOARD_CDC_D15_ALTERNATE_FUNCTION                5

// <o> "CDC_D16_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D16_GPIO_PORT                         13
// <o> "CDC_D16_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D16_GPIO_PIN                          0
// <o> "CDC_D16_B" GPIO pin alternate function <0-7>
#define BOARD_CDC_D16_ALTERNATE_FUNCTION                6

// <o> "CDC_D17_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D17_GPIO_PORT                         13
// <o> "CDC_D17_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D17_GPIO_PIN                          1
// <o> "CDC_D17_B" GPIO pin alternate function <0-7>
#define BOARD_CDC_D17_ALTERNATE_FUNCTION                5

// <o> "CDC_D18_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D18_GPIO_PORT                         13
// <o> "CDC_D18_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D18_GPIO_PIN                          2
// <o> "CDC_D18_B" GPIO pin alternate function <0-7>
#define BOARD_CDC_D18_ALTERNATE_FUNCTION                5

// <o> "CDC_D19_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D19_GPIO_PORT                         13
// <o> "CDC_D19_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D19_GPIO_PIN                          3
// <o> "CDC_D19_B" GPIO pin alternate function <0-7>
#define BOARD_CDC_D19_ALTERNATE_FUNCTION                5

// <o> "CDC_D20_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D20_GPIO_PORT                         13
// <o> "CDC_D20_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D20_GPIO_PIN                          4
// <o> "CDC_D20_B" GPIO pin alternate function <0-7>
#define BOARD_CDC_D20_ALTERNATE_FUNCTION                5

// <o> "CDC_D21_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D21_GPIO_PORT                         13
// <o> "CDC_D21_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D21_GPIO_PIN                          5
// <o> "CDC_D21_B" GPIO pin alternate function <0-7>
#define BOARD_CDC_D21_ALTERNATE_FUNCTION                5

// <o> "CDC_D22_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D22_GPIO_PORT                         13
// <o> "CDC_D22_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D22_GPIO_PIN                          6
// <o> "CDC_D22_B" GPIO pin alternate function <0-7>
#define BOARD_CDC_D22_ALTERNATE_FUNCTION                5

// <o> "CDC_D23_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CDC_D23_GPIO_PORT                         13
// <o> "CDC_D23_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CDC_D23_GPIO_PIN                          7
// <o> "CDC_D23_B" GPIO pin alternate function <0-7>
#define BOARD_CDC_D23_ALTERNATE_FUNCTION                5

// <o> "CLICKBOARD_INT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CLICKBOARD_INT_GPIO_PORT                  8
// <o> "CLICKBOARD_INT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CLICKBOARD_INT_GPIO_PIN                   1

// <o> "CLICKBOARD_RST" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CLICKBOARD_RST_GPIO_PORT                  8
// <o> "CLICKBOARD_RST" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CLICKBOARD_RST_GPIO_PIN                   3

// <o> "ICM_IMU_IRQ" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_ICM_IMU_IRQ_GPIO_PORT                     8
// <o> "ICM_IMU_IRQ" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_ICM_IMU_IRQ_GPIO_PIN                      4

// <o> "BMI_IMU_IRQ" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_BMI_IMU_IRQ_GPIO_PORT                     8
// <o> "BMI_IMU_IRQ" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_BMI_IMU_IRQ_GPIO_PIN                      5

// <o> "CAMERA_RESET" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAMERA_RESET_GPIO_PORT                    9
// <o> "CAMERA_RESET" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CAMERA_RESET_GPIO_PIN                     1

// <o> "CAMERA_FLASH" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAMERA_FLASH_GPIO_PORT                    9
// <o> "CAMERA_FLASH" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CAMERA_FLASH_GPIO_PIN                     2

// <o> "CAMERA_TRIGGER" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAMERA_TRIGGER_GPIO_PORT                  9
// <o> "CAMERA_TRIGGER" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CAMERA_TRIGGER_GPIO_PIN                   3

// <o> "TOUCH_INT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_TOUCH_INT_GPIO_PORT                       9
// <o> "TOUCH_INT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_TOUCH_INT_GPIO_PIN                        4

// <o> "LEDRGB0_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LEDRGB0_B_GPIO_PORT                       12
// <o> "LEDRGB0_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LEDRGB0_B_GPIO_PIN                        0
// <o> "LEDRGB0_B" GPIO pin alternate function <0-7>
#define BOARD_LEDRGB0_B_ALTERNATE_FUNCTION              0
// <o> "UTIMER PWM LEDRGB0_B" GPIO pin alternate function <0-7>
#define BOARD_LEDRGB0_B_UT_ALTERNATE_FUNCTION           4

// <o> "LEDRGB0_R" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LEDRGB0_R_GPIO_PORT                       12
// <o> "LEDRGB0_R" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LEDRGB0_R_GPIO_PIN                        3
// <o> "LEDRGB0_R" GPIO pin alternate function <0-7>
#define BOARD_LEDRGB0_R_ALTERNATE_FUNCTION              0
// <o> "UTIMER PWM LEDRGB0_R" GPIO pin alternate function <0-7>
#define BOARD_LEDRGB0_R_UT_ALTERNATE_FUNCTION           4

// <o> "LEDRGB0_G" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LEDRGB0_G_GPIO_PORT                       7
// <o> "LEDRGB0_G" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LEDRGB0_G_GPIO_PIN                        4
// <o> "LEDRGB0_G" GPIO pin alternate function <0-7>
#define BOARD_LEDRGB0_G_ALTERNATE_FUNCTION              0
// <o> "UTIMER PWM LEDRGB0_G" GPIO pin alternate function <0-7>
#define BOARD_LEDRGB0_G_UT_ALTERNATE_FUNCTION           6

// <o> "JOY_SW_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_JOY_SW_A_GPIO_PORT                        15
// <o> "JOY_SW_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_JOY_SW_A_GPIO_PIN                         0

// <o> "JOY_SW_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_JOY_SW_B_GPIO_PORT                        15
// <o> "JOY_SW_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_JOY_SW_B_GPIO_PIN                         1

// <o> "JOY_SW_C" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_JOY_SW_C_GPIO_PORT                        15
// <o> "JOY_SW_C" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_JOY_SW_C_GPIO_PIN                         2

// <o> "JOY_SW_D" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_JOY_SW_D_GPIO_PORT                        15
// <o> "JOY_SW_D" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_JOY_SW_D_GPIO_PIN                         3

// <o> "JOY_SW_CENTER" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_JOY_SW_CENTER_GPIO_PORT                   15
// <o> "JOY_SW_CENTER" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_JOY_SW_CENTER_GPIO_PIN                    4

// <o> "LCD_RESET" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LCD_RESET_GPIO_PORT                       15
// <o> "LCD_RESET" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LCD_RESET_GPIO_PIN                        5

// <o> "IS66_HYPERRAM_RESET" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4
// <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12
// <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_IS66_HYPERRAM_RESET_GPIO_PORT             15
// <o> "IS66_HYPERRAM_RESET" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=>
// PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_IS66_HYPERRAM_RESET_GPIO_PIN              6

// <o> "ISSI_FLASH_RESET" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4
// <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12
// <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_ISSI_FLASH_RESET_GPIO_PORT                15
// <o> "ISSI_FLASH_RESET" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=>
// PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_ISSI_FLASH_RESET_GPIO_PIN                 5

// P0_0 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_0_ADC12_INSTANCE                       0
// P0_0 ADC12 input number (Do Not Modify!)
#define BOARD_P0_0_ADC12_INPUT                          0

// P0_0 ADC24 positive input number (Do Not Modify!)
#define BOARD_P0_0_ADC24_POSITIVE_INPUT                 0

// P0_0 CMP instance number (Do Not Modify!)
#define BOARD_P0_0_CMP_INSTANCE                         0
// P0_0 CMP input number (Do Not Modify!)
#define BOARD_P0_0_CMP_INPUT                            0

// P0_1 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_1_ADC12_INSTANCE                       0
// P0_1 ADC12 input number (Do Not Modify!)
#define BOARD_P0_1_ADC12_INPUT                          1

// P0_1 ADC24 positive input number (Do Not Modify!)
#define BOARD_P0_1_ADC24_POSITIVE_INPUT                 1

// P0_1 CMP instance number (Do Not Modify!)
#define BOARD_P0_1_CMP_INSTANCE                         1
// P0_1 CMP input number (Do Not Modify!)
#define BOARD_P0_1_CMP_INPUT                            0

// P0_2 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_2_ADC12_INSTANCE                       0
// P0_2 ADC12 input number (Do Not Modify!)
#define BOARD_P0_2_ADC12_INPUT                          2

// P0_2 ADC24 positive input number (Do Not Modify!)
#define BOARD_P0_2_ADC24_POSITIVE_INPUT                 2

// P0_2 CMP instance number (Do Not Modify!)
#define BOARD_P0_2_CMP_INSTANCE                         2
// P0_2 CMP input number (Do Not Modify!)
#define BOARD_P0_2_CMP_INPUT                            0

// P0_3 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_3_ADC12_INSTANCE                       0
// P0_3 ADC12 input number (Do Not Modify!)
#define BOARD_P0_3_ADC12_INPUT                          3

// P0_3 ADC24 positive input number (Do Not Modify!)
#define BOARD_P0_3_ADC24_POSITIVE_INPUT                 3

// P0_3 CMP instance number (Do Not Modify!)
#define BOARD_P0_3_CMP_INSTANCE                         3
// P0_3 CMP input number (Do Not Modify!)
#define BOARD_P0_3_CMP_INPUT                            0

// P0_4 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_4_ADC12_INSTANCE                       0
// P0_4 ADC12 input number (Do Not Modify!)
#define BOARD_P0_4_ADC12_INPUT                          4

// P0_4 ADC24 negative input number (Do Not Modify!)
#define BOARD_P0_4_ADC24_NEGATIVE_INPUT                 0

// P0_4 CMP instance number (Do Not Modify!)
#define BOARD_P0_4_CMP_INSTANCE                         0
// P0_4 CMP input number (Do Not Modify!)
#define BOARD_P0_4_CMP_INPUT                            3

// P0_5 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_5_ADC12_INSTANCE                       0
// P0_5 ADC12 input number (Do Not Modify!)
#define BOARD_P0_5_ADC12_INPUT                          5

// P0_5 ADC24 negative input number (Do Not Modify!)
#define BOARD_P0_5_ADC24_NEGATIVE_INPUT                 1

// P0_5 CMP instance number (Do Not Modify!)
#define BOARD_P0_5_CMP_INSTANCE                         1
// P0_5 CMP input number (Do Not Modify!)
#define BOARD_P0_5_CMP_INPUT                            3

// P0_6 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_6_ADC12_INSTANCE                       1
// P0_6 ADC12 input number (Do Not Modify!)
#define BOARD_P0_6_ADC12_INPUT                          0

// P0_6 ADC24 negative input number (Do Not Modify!)
#define BOARD_P0_6_ADC24_NEGATIVE_INPUT                 2

// P0_6 CMP instance number (Do Not Modify!)
#define BOARD_P0_6_CMP_INSTANCE                         0
// P0_6 CMP input number (Do Not Modify!)
#define BOARD_P0_6_CMP_INPUT                            1

// P0_7 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_7_ADC12_INSTANCE                       1
// P0_7 ADC12 input number (Do Not Modify!)
#define BOARD_P0_7_ADC12_INPUT                          1

// P0_7 ADC24 negative input number (Do Not Modify!)
#define BOARD_P0_7_ADC24_NEGATIVE_INPUT                 3

// P0_7 CMP instance number (Do Not Modify!)
#define BOARD_P0_7_CMP_INSTANCE                         1
// P0_7 CMP input number (Do Not Modify!)
#define BOARD_P0_7_CMP_INPUT                            1

// P1_0 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_0_ADC12_INSTANCE                       1
// P1_0 ADC12 input number (Do Not Modify!)
#define BOARD_P1_0_ADC12_INPUT                          2

// P1_0 CMP instance number (Do Not Modify!)
#define BOARD_P1_0_CMP_INSTANCE                         2
// P1_0 CMP input number (Do Not Modify!)
#define BOARD_P1_0_CMP_INPUT                            1

// P1_1 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_1_ADC12_INSTANCE                       1
// P1_1 ADC12 input number (Do Not Modify!)
#define BOARD_P1_1_ADC12_INPUT                          3

// P1_1 CMP instance number (Do Not Modify!)
#define BOARD_P1_1_CMP_INSTANCE                         3
// P1_1 CMP input number (Do Not Modify!)
#define BOARD_P1_1_CMP_INPUT                            1

// P1_2 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_2_ADC12_INSTANCE                       1
// P1_2 ADC12 input number (Do Not Modify!)
#define BOARD_P1_2_ADC12_INPUT                          4

// P1_2 CMP instance number (Do Not Modify!)
#define BOARD_P1_2_CMP_INSTANCE                         2
// P1_2 CMP input number (Do Not Modify!)
#define BOARD_P1_2_CMP_INPUT                            3

// P1_3 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_3_ADC12_INSTANCE                       1
// P1_3 ADC12 input number (Do Not Modify!)
#define BOARD_P1_3_ADC12_INPUT                          5

// P1_3 CMP instance number (Do Not Modify!)
#define BOARD_P1_3_CMP_INSTANCE                         3
// P1_3 CMP input number (Do Not Modify!)
#define BOARD_P1_3_CMP_INPUT                            3

// P1_4 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_4_ADC12_INSTANCE                       2
// P1_4 ADC12 input number (Do Not Modify!)
#define BOARD_P1_4_ADC12_INPUT                          0

// P1_4 CMP instance number (Do Not Modify!)
#define BOARD_P1_4_CMP_INSTANCE                         0
// P1_4 CMP input number (Do Not Modify!)
#define BOARD_P1_4_CMP_INPUT                            2

// P1_5 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_5_ADC12_INSTANCE                       2
// P1_5 ADC12 input number (Do Not Modify!)
#define BOARD_P1_5_ADC12_INPUT                          1

// P1_5 CMP instance number (Do Not Modify!)
#define BOARD_P1_5_CMP_INSTANCE                         1
// P1_5 CMP input number (Do Not Modify!)
#define BOARD_P1_5_CMP_INPUT                            2

// P1_6 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_6_ADC12_INSTANCE                       2
// P1_6 ADC12 input number (Do Not Modify!)
#define BOARD_P1_6_ADC12_INPUT                          2

// P1_6 CMP instance number (Do Not Modify!)
#define BOARD_P1_6_CMP_INSTANCE                         2
// P1_6 CMP input number (Do Not Modify!)
#define BOARD_P1_6_CMP_INPUT                            2

// P1_7 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_7_ADC12_INSTANCE                       2
// P1_7 ADC12 input number (Do Not Modify!)
#define BOARD_P1_7_ADC12_INPUT                          3

// P1_7 CMP instance number (Do Not Modify!)
#define BOARD_P1_7_CMP_INSTANCE                         3
// P1_7 CMP input number (Do Not Modify!)
#define BOARD_P1_7_CMP_INPUT                            2

// P2_0 ADC12 instance number (Do Not Modify!)
#define BOARD_P2_0_ADC12_INSTANCE                       2
// P2_0 ADC12 input number (Do Not Modify!)
#define BOARD_P2_0_ADC12_INPUT                          4

// P2_1 ADC12 instance number (Do Not Modify!)
#define BOARD_P2_1_ADC12_INSTANCE                       2
// P2_1 ADC12 input number (Do Not Modify!)
#define BOARD_P2_1_ADC12_INPUT                          1

// P2_2 DAC12 instance number (Do Not Modify!)
#define BOARD_P2_2_DAC12_INSTANCE                       0
// P2_3 DAC12 instance number (Do Not Modify!)
#define BOARD_P2_3_DAC12_INSTANCE                       1

#define BOARD_DAC12_INSTANCE                            BOARD_P2_2_DAC12_INSTANCE

// P2_4 LPCMP input number (Do Not Modify!)
#define BOARD_P2_4_LPCMP_INPUT                          0

// P2_5 LPCMP input number (Do Not Modify!)
#define BOARD_P2_5_LPCMP_INPUT                          1

// P2_6 LPCMP input number (Do Not Modify!)
#define BOARD_P2_6_LPCMP_INPUT                          2

// P2_7 LPCMP input number (Do Not Modify!)
#define BOARD_P2_7_LPCMP_INPUT                          3

// <e> "WM8904_CODEC" on I2S presence flag
#define BOARD_WM8904_CODEC_PRESENT                      1

// <o> "WM8904_CODEC_I2C_SDA" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=>
// GPIO4 <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <15=> LPGPIO
#define BOARD_WM8904_CODEC_I2C_SDA_GPIO_PORT            7
// <o> "WM8904_CODEC_I2C_SDA" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=>
// PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_WM8904_CODEC_I2C_SDA_GPIO_PIN             2

// <o> "WM8904_CODEC_I2C_SDA" GPIO pin alternate function
#define BOARD_WM8904_CODEC_I2C_SDA_ALTERNATE_FUNCTION   5

// <o> "WM8904_CODEC_I2C_SCL" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=>
// GPIO4 <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <15=> LPGPIO
#define BOARD_WM8904_CODEC_I2C_SCL_GPIO_PORT            7

// <o> "WM8904_CODEC_I2C_SCL" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=>
// PIN5 <6=> PIN6 <7=> PIN7
#define BOARD_WM8904_CODEC_I2C_SCL_GPIO_PIN             3

// <o> "WM8904_CODEC_I2C_SCL" GPIO pin alternate function
#define BOARD_WM8904_CODEC_I2C_SCL_ALTERNATE_FUNCTION   5

// <o> "DAC Output" I2S instance number <0=> I2S0 <1=> I2S1 <2=> I2S2  <3=> I2S3  <LP=> LPI2S
#define BOARD_DAC_OUTPUT_I2S_INSTANCE                   3

// <o> "DAC_OUTPUT_SDO" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_DAC_OUTPUT_SDO_GPIO_PORT                  9
// <o> "DAC_OUTPUT_SDO" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_DAC_OUTPUT_SDO_GPIO_PIN                   3
// <o> "DAC_OUTPUT_SDO" GPIO pin alternate function <0-7>
#define BOARD_DAC_OUTPUT_SDO_ALTERNATE_FUNCTION         3

// <o> "DAC_OUTPUT_WS" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_DAC_OUTPUT_WS_GPIO_PORT                   8
// <o> "DAC_OUTPUT_WS" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_DAC_OUTPUT_WS_GPIO_PIN                    7
// <o> "DAC_OUTPUT_WS" GPIO pin alternate function <0-7>
#define BOARD_DAC_OUTPUT_WS_ALTERNATE_FUNCTION          2

// <o> "DAC_OUTPUT_SCLK" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4
// <5=> GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12
// <13=> GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_DAC_OUTPUT_SCLK_GPIO_PORT                 8
// <o> "DAC_OUTPUT_SCLK" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_DAC_OUTPUT_SCLK_GPIO_PIN                  6
// <o> "DAC_OUTPUT_SCLK" GPIO pin alternate function <0-7>
#define BOARD_DAC_OUTPUT_SCLK_ALTERNATE_FUNCTION        2

// <o> "MIC_INPUT_SDI" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_MIC_INPUT_SDI_GPIO_PORT                   13
// <o> "MIC_INPUT_SDI" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_MIC_INPUT_SDI_GPIO_PIN                    4
// <o> "MIC_INPUT_SDI" GPIO pin alternate function <0-7>
#define BOARD_MIC_INPUT_SDI_ALTERNATE_FUNCTION          2

// <o> "MIC_INPUT_WS" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_MIC_INPUT_WS_GPIO_PORT                    13
// <o> "MIC_INPUT_WS" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_MIC_INPUT_WS_GPIO_PIN                     7
// <o> "MIC_INPUT_WS" GPIO pin alternate function <0-7>
#define BOARD_MIC_INPUT_WS_ALTERNATE_FUNCTION           2

// <o> "MIC_INPUT_SCLK" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_MIC_INPUT_SCLK_GPIO_PORT                  13
// <o> "MIC_INPUT_SCLK" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_MIC_INPUT_SCLK_GPIO_PIN                   6
// <o> "MIC_INPUT_SCLK" GPIO pin alternate function <0-7>
#define BOARD_MIC_INPUT_SCLK_ALTERNATE_FUNCTION         2

// </h>
