/*!
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2025-01-01
 *
 * @attention
 *
 *  Copyright (C) 2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"
#include "bmp561_gpio.h"
#include "bmp561_sysctrl.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/

/* Private function prototypes ********************************************/
void GPIO_Init(void);

/* External variables *****************************************************/

/* External functions *****************************************************/

/*!
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    BOARD_Delay_Config();

    GPIO_Init();

    while (1)
    {
        BOARD_Delay_Ms(500);
        GPIO_SetBit(GPIO_PIN_3);
        GPIO_SetBit(GPIO_PIN_4);

        BOARD_Delay_Ms(500);
        GPIO_ResetBit(GPIO_PIN_3);
        GPIO_ResetBit(GPIO_PIN_4);
    }
}

/*!
 * @brief   GPIO initialize
 *
 * @param   None
 *
 * @retval  None
 */
void GPIO_Init(void)
{
    SYSCTRL_Unlock();
    SYSCTRL_EnableAHBPeriphClock(SYSCTRL_AHB_GPIO);
    SYSCTRL_Lock();

    GPIO_Config_T gpioConfig;
    gpioConfig.pin = GPIO_PIN_3;
    gpioConfig.mode = GPIO_MODE_OUT;
    gpioConfig.speed = GPIO_OS_HIGH;
    gpioConfig.type = GPIO_OT_PP;
    gpioConfig.pullEn = DISABLE;
    gpioConfig.polarity = GPIO_POL_DOWN;
    gpioConfig.drive = GPIO_DS_HIGH;
    GPIO_Config(&gpioConfig);

    gpioConfig.pin = GPIO_PIN_4;
    GPIO_Config(&gpioConfig);
}