/*------------------------------------------------------------------------------
 * Example main module
 * Copyright (c) 2019-2020 Arm Limited (or its affiliates). All rights reserved.
 *------------------------------------------------------------------------------
 * Name:    main.c
 * Purpose: Main module
 *----------------------------------------------------------------------------*/

#include "main.h"
#include "LPC407x_8x_177x_8x.h"         // Device header
#include "Board_LED.h"                  // ::Board Support:LED
#include "Board_GLCD.h"                 // ::Board Support:Graphic LCD


/*------------------------------------------------------------------------------
 * main function
 *----------------------------------------------------------------------------*/
int main(void) {

  SystemCoreClockUpdate ();                     // Update System Core Clock info
  LED_Initialize ();                            // Initialize LED
  GLCD_Initialize ();                           // Initialize Graphical LCD

  osKernelInitialize ();                        // Initialize CMSIS-RTOS2
  osThreadNew (app_main, NULL, &app_main_attr); // Create application main thread
  osKernelStart ();                             // Start thread execution

  for (;;) {}
}
