/*
 *   Copyright (C) 2025 Alif Semiconductor - All Rights Reserved.
 *   Use, distribution and modification of this code is permitted under the
 *   terms stated in the Alif Semiconductor Software License Agreement
 *
 *   You should have received a copy of the Alif Semiconductor Software
 *   License Agreement with this file. If not, please write to:
 *   https://alifsemi.com/contact/, or visit: https://alifsemi.com/license/
 */
/******************************************************************************
 * @file     board_defs.h
 * @author  	Auto generated by Conductor Tool https://conductor.alifsemi.com/
 * @version  v1.0.1
 * @date     2025-5-30
 * @brief    Board info/settings for "DevKit Gen 2 (DK-E7)" project
 *           with AE722F80F55D5LS
 * @bug      None.
 * @note     To modify this file manually, take care to modify pins.h and gpios.h
 *           accordingly when required.
 ******************************************************************************/
//-------- <<< Use Configuration Wizard in Context Menu >>> -------------------

// <h> Board peripheral instances
// <o> "ADC12A" ADC12 instance number <0-2>
#define BOARD_ADC12A_ADC12_INSTANCE          0

// <o> "ADC12B" ADC12 instance number <0-2>
#define BOARD_ADC12B_ADC12_INSTANCE          1

// <o> "ADC12C" ADC12 instance number <0-2>
#define BOARD_ADC12C_ADC12_INSTANCE          2

// <e> ADC24 module enabled flag
#define BOARD_ADC24_ENABLED                  1
// </e>

// <e> CANFD module enabled flag
#define BOARD_CANFD_ENABLED                  1
// <e> "CAN Transceiver" on CANFD presence flag
#define BOARD_CANFD_CAN_TRANSCEIVER_PRESENT  1
// </e>
// </e>

// <o> "CMPA" CMP instance number <0-4>
#define BOARD_CMPA_CMP_INSTANCE              0

// <o> "CMPB" CMP instance number <0-4>
#define BOARD_CMPB_CMP_INSTANCE              1

// <o> "CMPC" CMP instance number <0-4>
#define BOARD_CMPC_CMP_INSTANCE              2

// <o> "CMPD" CMP instance number <0-4>
#define BOARD_CMPD_CMP_INSTANCE              3

// <e> CSI module enabled flag
#define BOARD_CSI_ENABLED                    1
// <e> "ARX3A0" on CSI presence flag
#define BOARD_CSI_ARX3A0_PRESENT             1
// </e>
// <e> "AR0144" on CSI presence flag
#define BOARD_CSI_AR0144_PRESENT             1
// </e>
// </e>

// <e> DSI module enabled flag
#define BOARD_DSI_ENABLED                    1
// <e> "ILI9806" on DSI presence flag
#define BOARD_DSI_ILI9806_PRESENT            1
// </e>
// </e>

// <e> ETH module enabled flag
#define BOARD_ETH_ENABLED                    1
// <e> "RTL8201" on ETH presence flag
#define BOARD_ETH_RTL8201_PRESENT            1
// </e>
// </e>

// <o> "Clickboard" I2C instance number <0-3>
#define BOARD_CLICKBOARD_I2C_INSTANCE        0

// <o> "Slave" I2C instance number <0-3>
#define BOARD_SLAVE_I2C_INSTANCE             0

// <o> "Camera" I2C instance number <0-3>
#define BOARD_CAMERA_I2C_INSTANCE            1

// <o> "GT911 Touchscreen" I2C instance number <0-3>
#define BOARD_GT911_TOUCHSCREEN_I2C_INSTANCE 1

// <o> "Master" I2C instance number <0-3>
#define BOARD_MASTER_I2C_INSTANCE            1

// <o> "MIC Input" I2S instance number <0-3>
#define BOARD_MIC_INPUT_I2S_INSTANCE         3

// <e> I3C module enabled flag
#define BOARD_I3C_ENABLED                    1
// <e> "ICM42670 IMU" on I3C presence flag
#define BOARD_I3C_ICM42670_IMU_PRESENT       1
// </e>
// <e> "BMI323 IMU" on I3C presence flag
#define BOARD_I3C_BMI323_IMU_PRESENT         1
// </e>
// <e> "pin header" on I3C presence flag
#define BOARD_I3C_PIN_HEADER_PRESENT         1
// </e>
// </e>

// <e> JTAG module enabled flag
#define BOARD_JTAG_ENABLED                   1
// </e>

// <e> LPCPI module enabled flag
#define BOARD_LPCPI_ENABLED                  1
// </e>

// <e> LPGPIO module enabled flag
#define BOARD_LPGPIO_ENABLED                 1
// </e>

// <e> LPI2S module enabled flag
#define BOARD_LPI2S_ENABLED                  1
// </e>

// <e> LPPDM module enabled flag
#define BOARD_LPPDM_ENABLED                  1
// </e>

// <e> MISC module enabled flag
#define BOARD_MISC_ENABLED                   1
// </e>

// <o> "ISSI RAM" OSPI instance number <0-1>
#define BOARD_ISSI_RAM_OSPI_INSTANCE         0

// <o> "ISSI Flash" OSPI instance number <0-1>
#define BOARD_ISSI_FLASH_OSPI_INSTANCE       1

// <e> PDM module enabled flag
#define BOARD_PDM_ENABLED                    1
// <e> "PDM MIC" on PDM presence flag
#define BOARD_PDM_PDM_MIC_PRESENT            1
// </e>
// </e>

// <o> "Encoder" UTIMER instance number <12-15>
#define BOARD_ENCODER_UTIMER_INSTANCE        12

// <e> SDMMC module enabled flag
#define BOARD_SDMMC_ENABLED                  1
// <e> "SDCARD" on SDMMC presence flag
#define BOARD_SDMMC_SDCARD_PRESENT           1
// </e>
// </e>

// <e> SEUART module enabled flag
#define BOARD_SEUART_ENABLED                 1
// </e>

// <o> "Clickboard" UART instance number <0-7>
#define BOARD_CLICKBOARD_UART_INSTANCE       0

// <o> "UARTA" UART instance number <0-7>
#define BOARD_UARTA_UART_INSTANCE            2

// <o> "UARTB" UART instance number <0-7>
#define BOARD_UARTB_UART_INSTANCE            4

// <e> USB module enabled flag
#define BOARD_USB_ENABLED                    1
// <e> "Device Role" on USB presence flag
#define BOARD_USB_DEVICE_ROLE_PRESENT        1
// </e>
// </e>

// <o> "Capture Mode" UTIMER instance number <0-12>
#define BOARD_CAPTURE_MODE_UTIMER_INSTANCE   0

// <o> "Compare Mode" UTIMER instance number <0-12>
#define BOARD_COMPARE_MODE_UTIMER_INSTANCE   1

// <o> "Trigger Mode" UTIMER instance number <0-12>
#define BOARD_TRIGGER_MODE_UTIMER_INSTANCE   2

// <o> "Clickboard PWM" UTIMER instance number <0-12>
#define BOARD_CLICKBOARD_PWM_UTIMER_INSTANCE 3

// </h>
// <h> Miscellaneous
// <o> Onboard LEDs
// <i> Sets the #define BOARD_LED_COUNT in the board_def.h file exported from the Conductor tool.
#define BOARD_LED_COUNT                      0

// <o> Onboard RGB LEDs
// <i> Sets the #define BOARD_LEDRGB_COUNT in the board_def.h file exported from the Conductor tool.
#define BOARD_LEDRGB_COUNT                   2

// <o> Onboard Push-buttons
// <i> Sets the #define BOARD_BUTTON_COUNT in the board_def.h file exported from the Conductor tool.
#define BOARD_BUTTON_COUNT                   5

// <o> Onboard Config Switches or Jumpers
// <i> Sets the #define BOARD_CONFIG_JUMPER_COUNT in the board_def.h file exported from the
// Conductor tool.
#define BOARD_CONFIG_JUMPER_COUNT            0

// <o> Onboard Switching Devices
// <i> Sets the #define BOARD_SWITCH_OUTPUT_COUNT in the board_def.h file exported from the
// Conductor tool. These include relays, solid state relays, transistors, optocopulers, etc.
#define BOARD_SWITCH_OUTPUT_COUNT            0

// <o> OSPI0 Bus Speed
// <i> Selects OSPI0 bus speed for a 200-MHz (default) HCLK. For 100 MHz and lower HCLK clock
// speeds, some values are either not possible, either rounded to the closest possible value in
// hardware.
#define BOARD_OSPI0_BUS_SPEED                100000000

// <o> OSPI1 Bus Speed
// <i> Selects OSPI1 bus speed for a 200-MHz (default) HCLK. For 100 MHz and lower HCLK clock
// speeds, some values are either not possible, either rounded to the closest possible value in
// hardware.
#define BOARD_OSPI1_BUS_SPEED                100000000

// <o> OSPI0 onboard memory size
#define BOARD_OSPI0_MEM_SIZE                 33554432

// <o> OSPI1 onboard memory size
#define BOARD_OSPI1_MEM_SIZE                 33554432

// </h>
// <h> GPIO port/pin numbers, analog instance/input numbers, etc.
// <o> FLEX IO pins supply voltage <0=> 3.3 V <1=> 1.8 V
// <i> Make sure this setting corresponds to the VDD_IO_FLEX pin voltage. If the VDD_IO_FLEX pin is
// connected to a 3.3 V supply, do not change the value of the GPIO_CNTL register to command 1.8-V
// operation mode!
#define FLEX_IO_VOLTAGE_1V8                  1

// <o> "CLICKBOARD_ANA" ADC12 instance number <0=> ADC120 <1=> ADC121 <2=> ADC122
#define BOARD_CLICKBOARD_ANA_ADC12_INSTANCE  1
// <o> "CLICKBOARD_ANA" ADC12 input number <0=> IN0 <1=> IN1 <2=> IN2 <3=> IN3 <4=> IN4 <5=> IN5
#define BOARD_CLICKBOARD_ANA_ADC12_INPUT     0

// <o> "CLICKBOARD_ANA" ADC24 negative input number <0=> IN0_N <1=> IN1_N <2=> IN2_N <3=> IN3_N
// <i> WARNING: This option does not change the positive input pin automatically!
#define BOARD_CLICKBOARD_ANA_ADC24_INPUT     2

// <o> "CLICKBOARD_ANA" CMP instance number <0=> CMP0 <1=> CMP1 <2=> CMP2 <3=> CMP3
#define BOARD_CLICKBOARD_ANA_CMP_INSTANCE    0
// <o> "CLICKBOARD_ANA" CMP input number <0=> IN0 <1=> IN1 <2=> IN2 <3=> IN3
#define BOARD_CLICKBOARD_ANA_CMP_INPUT       1

// <o> "POTENTIOMETER" ADC12 instance number <0=> ADC120 <1=> ADC121 <2=> ADC122
#define BOARD_POTENTIOMETER_ADC12_INSTANCE   1
// <o> "POTENTIOMETER" ADC12 input number <0=> IN0 <1=> IN1 <2=> IN2 <3=> IN3 <4=> IN4 <5=> IN5
#define BOARD_POTENTIOMETER_ADC12_INPUT      1

// <o> "POTENTIOMETER" ADC24 negative input number <0=> IN0_N <1=> IN1_N <2=> IN2_N <3=> IN3_N
// <i> WARNING: This option does not change the positive input pin automatically!
#define BOARD_POTENTIOMETER_ADC24_INPUT      3

// <o> "POTENTIOMETER" CMP instance number <0=> CMP0 <1=> CMP1 <2=> CMP2 <3=> CMP3
#define BOARD_POTENTIOMETER_CMP_INSTANCE     1
// <o> "POTENTIOMETER" CMP input number <0=> IN0 <1=> IN1 <2=> IN2 <3=> IN3
#define BOARD_POTENTIOMETER_CMP_INPUT        1

// <o> "SD_CARD_DETECT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_SD_CARD_DETECT_GPIO_PORT       3
// <o> "SD_CARD_DETECT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_SD_CARD_DETECT_GPIO_PIN        3

// <o> "LPPDM_TEST" LPPDM data/clock pair number <0=> D0/C0 <1=> D1/C1 <2=> D2/C2 <3=> D3/C3
#define BOARD_LPPDM_TEST_LPPDM_INPUT         1

// <o> "TOUCH_RESET" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_TOUCH_RESET_GPIO_PORT          4
// <o> "TOUCH_RESET" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_TOUCH_RESET_GPIO_PIN           0

// <o> "UTIMER_GPO0" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_UTIMER_GPO0_GPIO_PORT          4
// <o> "UTIMER_GPO0" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_UTIMER_GPO0_GPIO_PIN           1

// <o> "UTIMER_GPO1" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_UTIMER_GPO1_GPIO_PORT          4
// <o> "UTIMER_GPO1" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_UTIMER_GPO1_GPIO_PIN           2

// <o> "UTIMER_GPO2" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_UTIMER_GPO2_GPIO_PORT          4
// <o> "UTIMER_GPO2" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_UTIMER_GPO2_GPIO_PIN           3

// <o> "PDM_MIC" PDM data/clock pair number <0=> D0/C0 <1=> D1/C1 <2=> D2/C2 <3=> D3/C3
#define BOARD_PDM_MIC_PDM_INPUT              2

// <o> "LCD_BACKLIGHT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LCD_BACKLIGHT_GPIO_PORT        6
// <o> "LCD_BACKLIGHT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_LCD_BACKLIGHT_GPIO_PIN         1

// <o> "LEDRGB1_R" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LEDRGB1_R_GPIO_PORT            6
// <o> "LEDRGB1_R" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LEDRGB1_R_GPIO_PIN             2

// <o> "UTIMER_GPO3" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_UTIMER_GPO3_GPIO_PORT          6
// <o> "UTIMER_GPO3" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_UTIMER_GPO3_GPIO_PIN           3

// <o> "LEDRGB1_G" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LEDRGB1_G_GPIO_PORT            6
// <o> "LEDRGB1_G" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LEDRGB1_G_GPIO_PIN             4

// <o> "LEDRGB1_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LEDRGB1_B_GPIO_PORT            6
// <o> "LEDRGB1_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LEDRGB1_B_GPIO_PIN             6

// <o> "LEDRGB0_G" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LEDRGB0_G_GPIO_PORT            7
// <o> "LEDRGB0_G" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LEDRGB0_G_GPIO_PIN             4

// <o> "CAMERA_POWER" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAMERA_POWER_GPIO_PORT         7
// <o> "CAMERA_POWER" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CAMERA_POWER_GPIO_PIN          5

// <o> "CLICKBOARD_INT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CLICKBOARD_INT_GPIO_PORT       8
// <o> "CLICKBOARD_INT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CLICKBOARD_INT_GPIO_PIN        1

// <o> "CLICKBOARD_RST" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CLICKBOARD_RST_GPIO_PORT       8
// <o> "CLICKBOARD_RST" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CLICKBOARD_RST_GPIO_PIN        3

// <o> "ICM_IMU_IRQ" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_ICM_IMU_IRQ_GPIO_PORT          8
// <o> "ICM_IMU_IRQ" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_ICM_IMU_IRQ_GPIO_PIN           4

// <o> "BMI_IMU_IRQ" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_BMI_IMU_IRQ_GPIO_PORT          8
// <o> "BMI_IMU_IRQ" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_BMI_IMU_IRQ_GPIO_PIN           5

// <o> "CAMERA_RESET" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAMERA_RESET_GPIO_PORT         9
// <o> "CAMERA_RESET" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CAMERA_RESET_GPIO_PIN          1

// <o> "CAMERA_FLASH" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAMERA_FLASH_GPIO_PORT         9
// <o> "CAMERA_FLASH" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CAMERA_FLASH_GPIO_PIN          2

// <o> "CAMERA_TRIGGER" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_CAMERA_TRIGGER_GPIO_PORT       9
// <o> "CAMERA_TRIGGER" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_CAMERA_TRIGGER_GPIO_PIN        3

// <o> "TOUCH_INT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_TOUCH_INT_GPIO_PORT            9
// <o> "TOUCH_INT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_TOUCH_INT_GPIO_PIN             4

// <o> "LEDRGB0_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LEDRGB0_B_GPIO_PORT            12
// <o> "LEDRGB0_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LEDRGB0_B_GPIO_PIN             0

// <o> "LEDRGB0_R" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LEDRGB0_R_GPIO_PORT            12
// <o> "LEDRGB0_R" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LEDRGB0_R_GPIO_PIN             3

// <o> "QEC_X_GPO" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_QEC_X_GPO_GPIO_PORT            14
// <o> "QEC_X_GPO" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_QEC_X_GPO_GPIO_PIN             0

// <o> "QEC_Y_GPO" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_QEC_Y_GPO_GPIO_PORT            14
// <o> "QEC_Y_GPO" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_QEC_Y_GPO_GPIO_PIN             1

// <o> "QEC_Z_GPO" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_QEC_Z_GPO_GPIO_PORT            14
// <o> "QEC_Z_GPO" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_QEC_Z_GPO_GPIO_PIN             2

// <o> "CMP3_OUT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CMP3_OUT_GPIO_PORT             14
// <o> "CMP3_OUT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CMP3_OUT_GPIO_PIN              4

// <o> "CMP2_OUT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CMP2_OUT_GPIO_PORT             14
// <o> "CMP2_OUT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CMP2_OUT_GPIO_PIN              5

// <o> "CMP1_OUT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CMP1_OUT_GPIO_PORT             14
// <o> "CMP1_OUT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CMP1_OUT_GPIO_PIN              6

// <o> "CMP0_OUT" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_CMP0_OUT_GPIO_PORT             14
// <o> "CMP0_OUT" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_CMP0_OUT_GPIO_PIN              7

// <o> "JOY_SW_A" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_JOY_SW_A_GPIO_PORT             15
// <o> "JOY_SW_A" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_JOY_SW_A_GPIO_PIN              0

// <o> "JOY_SW_B" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_JOY_SW_B_GPIO_PORT             15
// <o> "JOY_SW_B" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_JOY_SW_B_GPIO_PIN              1

// <o> "JOY_SW_C" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_JOY_SW_C_GPIO_PORT             15
// <o> "JOY_SW_C" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_JOY_SW_C_GPIO_PIN              2

// <o> "JOY_SW_D" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=> GPIO5
// <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=> GPIO13
// <14=> GPIO14 <15=> LPGPIO
#define BOARD_JOY_SW_D_GPIO_PORT             15
// <o> "JOY_SW_D" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_JOY_SW_D_GPIO_PIN              3

// <o> "JOY_SW_CENTER" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_JOY_SW_CENTER_GPIO_PORT        15
// <o> "JOY_SW_CENTER" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_JOY_SW_CENTER_GPIO_PIN         4

// <o> "LCD_RESET" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_LCD_RESET_GPIO_PORT            15
// <o> "LCD_RESET" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5 <6=>
// PIN6 <7=> PIN7
#define BOARD_LCD_RESET_GPIO_PIN             5

// <o> "OSPI0_RESET" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_OSPI0_RESET_GPIO_PORT          15
// <o> "OSPI0_RESET" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_OSPI0_RESET_GPIO_PIN           6

// <o> "OSPI1_RESET" GPIO port number <0=> GPIO0 <1=> GPIO1 <2=> GPIO2 <3=> GPIO3 <4=> GPIO4 <5=>
// GPIO5 <6=> GPIO6 <7=> GPIO7 <8=> GPIO8 <9=> GPIO9 <10=> GPIO10 <11=> GPIO11 <12=> GPIO12 <13=>
// GPIO13 <14=> GPIO14 <15=> LPGPIO
#define BOARD_OSPI1_RESET_GPIO_PORT          15
// <o> "OSPI1_RESET" GPIO pin number <0=> PIN0 <1=> PIN1 <2=> PIN2 <3=> PIN3 <4=> PIN4 <5=> PIN5
// <6=> PIN6 <7=> PIN7
#define BOARD_OSPI1_RESET_GPIO_PIN           7

// P0_0 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_0_ADC12_INSTANCE            0
// P0_0 ADC12 input number (Do Not Modify!)
#define BOARD_P0_0_ADC12_INPUT               0

// P0_0 ADC24 positive input number (Do Not Modify!)
#define BOARD_P0_0_ADC24_POSITIVE_INPUT      0

// P0_0 CMP instance number (Do Not Modify!)
#define BOARD_P0_0_CMP_INSTANCE              0
// P0_0 CMP input number (Do Not Modify!)
#define BOARD_P0_0_CMP_INPUT                 0

// P0_1 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_1_ADC12_INSTANCE            0
// P0_1 ADC12 input number (Do Not Modify!)
#define BOARD_P0_1_ADC12_INPUT               1

// P0_1 ADC24 positive input number (Do Not Modify!)
#define BOARD_P0_1_ADC24_POSITIVE_INPUT      1

// P0_1 CMP instance number (Do Not Modify!)
#define BOARD_P0_1_CMP_INSTANCE              1
// P0_1 CMP input number (Do Not Modify!)
#define BOARD_P0_1_CMP_INPUT                 0

// P0_2 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_2_ADC12_INSTANCE            0
// P0_2 ADC12 input number (Do Not Modify!)
#define BOARD_P0_2_ADC12_INPUT               2

// P0_2 ADC24 positive input number (Do Not Modify!)
#define BOARD_P0_2_ADC24_POSITIVE_INPUT      2

// P0_2 CMP instance number (Do Not Modify!)
#define BOARD_P0_2_CMP_INSTANCE              2
// P0_2 CMP input number (Do Not Modify!)
#define BOARD_P0_2_CMP_INPUT                 0

// P0_3 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_3_ADC12_INSTANCE            0
// P0_3 ADC12 input number (Do Not Modify!)
#define BOARD_P0_3_ADC12_INPUT               3

// P0_3 ADC24 positive input number (Do Not Modify!)
#define BOARD_P0_3_ADC24_POSITIVE_INPUT      3

// P0_3 CMP instance number (Do Not Modify!)
#define BOARD_P0_3_CMP_INSTANCE              3
// P0_3 CMP input number (Do Not Modify!)
#define BOARD_P0_3_CMP_INPUT                 0

// P0_4 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_4_ADC12_INSTANCE            0
// P0_4 ADC12 input number (Do Not Modify!)
#define BOARD_P0_4_ADC12_INPUT               4

// P0_4 ADC24 negative input number (Do Not Modify!)
#define BOARD_P0_4_ADC24_NEGATIVE_INPUT      0

// P0_4 CMP instance number (Do Not Modify!)
#define BOARD_P0_4_CMP_INSTANCE              0
// P0_4 CMP input number (Do Not Modify!)
#define BOARD_P0_4_CMP_INPUT                 3

// P0_5 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_5_ADC12_INSTANCE            0
// P0_5 ADC12 input number (Do Not Modify!)
#define BOARD_P0_5_ADC12_INPUT               5

// P0_5 ADC24 negative input number (Do Not Modify!)
#define BOARD_P0_5_ADC24_NEGATIVE_INPUT      1

// P0_5 CMP instance number (Do Not Modify!)
#define BOARD_P0_5_CMP_INSTANCE              1
// P0_5 CMP input number (Do Not Modify!)
#define BOARD_P0_5_CMP_INPUT                 3

// P0_6 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_6_ADC12_INSTANCE            1
// P0_6 ADC12 input number (Do Not Modify!)
#define BOARD_P0_6_ADC12_INPUT               0

// P0_6 ADC24 negative input number (Do Not Modify!)
#define BOARD_P0_6_ADC24_NEGATIVE_INPUT      2

// P0_6 CMP instance number (Do Not Modify!)
#define BOARD_P0_6_CMP_INSTANCE              0
// P0_6 CMP input number (Do Not Modify!)
#define BOARD_P0_6_CMP_INPUT                 1

// P0_7 ADC12 instance number (Do Not Modify!)
#define BOARD_P0_7_ADC12_INSTANCE            1
// P0_7 ADC12 input number (Do Not Modify!)
#define BOARD_P0_7_ADC12_INPUT               1

// P0_7 ADC24 negative input number (Do Not Modify!)
#define BOARD_P0_7_ADC24_NEGATIVE_INPUT      3

// P0_7 CMP instance number (Do Not Modify!)
#define BOARD_P0_7_CMP_INSTANCE              1
// P0_7 CMP input number (Do Not Modify!)
#define BOARD_P0_7_CMP_INPUT                 1

// P1_0 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_0_ADC12_INSTANCE            1
// P1_0 ADC12 input number (Do Not Modify!)
#define BOARD_P1_0_ADC12_INPUT               2

// P1_0 CMP instance number (Do Not Modify!)
#define BOARD_P1_0_CMP_INSTANCE              2
// P1_0 CMP input number (Do Not Modify!)
#define BOARD_P1_0_CMP_INPUT                 1

// P1_1 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_1_ADC12_INSTANCE            1
// P1_1 ADC12 input number (Do Not Modify!)
#define BOARD_P1_1_ADC12_INPUT               3

// P1_1 CMP instance number (Do Not Modify!)
#define BOARD_P1_1_CMP_INSTANCE              3
// P1_1 CMP input number (Do Not Modify!)
#define BOARD_P1_1_CMP_INPUT                 1

// P1_2 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_2_ADC12_INSTANCE            1
// P1_2 ADC12 input number (Do Not Modify!)
#define BOARD_P1_2_ADC12_INPUT               4

// P1_2 CMP instance number (Do Not Modify!)
#define BOARD_P1_2_CMP_INSTANCE              2
// P1_2 CMP input number (Do Not Modify!)
#define BOARD_P1_2_CMP_INPUT                 3

// P1_3 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_3_ADC12_INSTANCE            1
// P1_3 ADC12 input number (Do Not Modify!)
#define BOARD_P1_3_ADC12_INPUT               5

// P1_3 CMP instance number (Do Not Modify!)
#define BOARD_P1_3_CMP_INSTANCE              3
// P1_3 CMP input number (Do Not Modify!)
#define BOARD_P1_3_CMP_INPUT                 3

// P1_4 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_4_ADC12_INSTANCE            2
// P1_4 ADC12 input number (Do Not Modify!)
#define BOARD_P1_4_ADC12_INPUT               0

// P1_4 CMP instance number (Do Not Modify!)
#define BOARD_P1_4_CMP_INSTANCE              0
// P1_4 CMP input number (Do Not Modify!)
#define BOARD_P1_4_CMP_INPUT                 2

// P1_5 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_5_ADC12_INSTANCE            2
// P1_5 ADC12 input number (Do Not Modify!)
#define BOARD_P1_5_ADC12_INPUT               1

// P1_5 CMP instance number (Do Not Modify!)
#define BOARD_P1_5_CMP_INSTANCE              1
// P1_5 CMP input number (Do Not Modify!)
#define BOARD_P1_5_CMP_INPUT                 2

// P1_6 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_6_ADC12_INSTANCE            2
// P1_6 ADC12 input number (Do Not Modify!)
#define BOARD_P1_6_ADC12_INPUT               2

// P1_6 CMP instance number (Do Not Modify!)
#define BOARD_P1_6_CMP_INSTANCE              2
// P1_6 CMP input number (Do Not Modify!)
#define BOARD_P1_6_CMP_INPUT                 2

// P1_7 ADC12 instance number (Do Not Modify!)
#define BOARD_P1_7_ADC12_INSTANCE            2
// P1_7 ADC12 input number (Do Not Modify!)
#define BOARD_P1_7_ADC12_INPUT               3

// P1_7 CMP instance number (Do Not Modify!)
#define BOARD_P1_7_CMP_INSTANCE              3
// P1_7 CMP input number (Do Not Modify!)
#define BOARD_P1_7_CMP_INPUT                 2

// P2_0 ADC12 instance number (Do Not Modify!)
#define BOARD_P2_0_ADC12_INSTANCE            2
// P2_0 ADC12 input number (Do Not Modify!)
#define BOARD_P2_0_ADC12_INPUT               4

// P2_1 ADC12 instance number (Do Not Modify!)
#define BOARD_P2_1_ADC12_INSTANCE            2
// P2_1 ADC12 input number (Do Not Modify!)
#define BOARD_P2_1_ADC12_INPUT               1

// P2_2 DAC12 instance number (Do Not Modify!)
#define BOARD_P2_2_DAC12_INSTANCE            0
// P2_3 DAC12 instance number (Do Not Modify!)
#define BOARD_P2_3_DAC12_INSTANCE            1
// P2_4 LPCMP input number (Do Not Modify!)
#define BOARD_P2_4_LPCMP_INPUT               0

// P2_5 LPCMP input number (Do Not Modify!)
#define BOARD_P2_5_LPCMP_INPUT               1

// P2_6 LPCMP input number (Do Not Modify!)
#define BOARD_P2_6_LPCMP_INPUT               2

// P2_7 LPCMP input number (Do Not Modify!)
#define BOARD_P2_7_LPCMP_INPUT               3

// </h>
