/* Copyright (C) 2025 Alif Semiconductor - All Rights Reserved.
 * Use, distribution and modification of this code is permitted under the
 * terms stated in the Alif Semiconductor Software License Agreement
 *
 * You should have received a copy of the Alif Semiconductor Software
 * License Agreement with this file. If not, please write to:
 * contact@alifsemi.com, or visit: https://alifsemi.com/license
 *
 */

//-------- <<< Use Configuration Wizard in Context Menu >>> --------------------

#ifndef __CORE_CONFIG_H
#define __CORE_CONFIG_H

// <o> Map Global to Local address of TCM Alias
//     <0=> DISABLE
//     <1=> ENABLE
// <i> Defines Enable this to return aliased address in GlobalToLocal function
// <i> Default: 0
#define CONFIG_MAP_GLOBAL_TO_LOCAL_TCM_ALIAS 0

// <e> Prefetch Control
// <i> Prefetch Control values for Performance Improvement

// <o> Maximum Outstanding Line-fills <1-6>
// <i> Defines Maximum Outstanding line-fills issued on AXI
// <i> Default: 5
#define MEMSYSCTL_PFCR_MAX_OS_DEFAULT_VALUE  5

// <o> Maximum Look Ahead Distance <0-6>
// <i> Defines Maximum Look Ahead distance
// <i> Default: 6
#define MEMSYSCTL_PFCR_MAX_LA_DEFAULT_VALUE  6

// <o> Minimum Look Ahead Distance <0-6>
// <i> Defines Minimum Look Ahead distance
// <i> Default: 2
#define MEMSYSCTL_PFCR_MIN_LA_DEFAULT_VALUE  2

// </e> Prefetch Control

#endif /* __CORE_CONFIG_H */
