/******************************************************************************
 * @file     resources.h
 * @author   Auto generated by Conductor Tool https://conductor.alifsemi.com/
 * @version  v1.0.0
 * @date     2025-4-11
 * @brief    Firewall and DMA settings for "AI/ML AppKit Gen 2 (AK-E7-AIML)" project with
 *AE722F80F55D5LS
 * @bug      None.
 * @note     None.
 ******************************************************************************/
/*
 *   Copyright (C) 2025 Alif Semiconductor - All Rights Reserved.
 *   Use, distribution and modification of this code is permitted under the
 *   terms stated in the Alif Semiconductor Software License Agreement
 *
 *   You should have received a copy of the Alif Semiconductor Software
 *   License Agreement with this file. If not, please write to:
 *   https://alifsemi.com/contact/, or visit: https://alifsemi.com/license/
 */

#ifndef __RESOURCES_H__
#define __RESOURCES_H__

#include <stdint.h>
/* ===========================================================================================================================
 */
/* ================                                TrustZone Region Settings ================ */
/* ===========================================================================================================================
 */

/* Region Settings */
#define SAU_REGIONS_MAX      32 /* maximum number of SAU regions */
#define SAU_INIT_CTRL_ENABLE 0  /* Enable/disable the SAU - 0: Disable, 1: Enable SAU */
#define SAU_INIT_CTRL_ALLNS                                                                        \
    1 /* Value for SAU_CTRL register bit ALLNS - 0: all Memory is Secure (FW en),  1: all Memory   \
         is Non-Secure (FW dis) */

/* ===========================================================================================================================
 */
/* ================                                DMA Definitions ================ */
/* ===========================================================================================================================
 */

/* Callback DMA Macro */
#define SET_DMA_REGISTER(reg, mask, value)                                                         \
    {                                                                                              \
        *(uint32_t *) (reg) &= ~((uint32_t) (mask));                                               \
        *(uint32_t *) (reg) |= (uint32_t) (value);                                                 \
    }

#endif /* __RESOURCES_H__ */
