
/**
 ******************************************************************************
 *
 * @file        Sample_main_wizard.C
 * @brief       MG32 demo main c Code. 
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/05/28
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_MID.h"
#include "MG32_ChipInit.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
extern void Sample_REG_I2C(void);
extern void Sample_MID_I2C_MEM(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/



int main(void)
{
    // ------------------------------------------------------------------------
    // chip initial (User can enable CSC, GPIO, TM, ADC, EXIC ... wizard)
    // ------------------------------------------------------------------------
    ChipInit();
    MID_InitTick(0U);

//-----------------------------------------------------------------------------
    GPIOB->SC.W = (PX_SC_SET10_mask_w | PX_SC_SET11_mask_w | PX_SC_SET12_mask_w | PX_SC_SET13_mask_w);
    GPIOC->SC.W = (PX_SC_SET10_mask_w | PX_SC_SET11_mask_w);

  //CSC ICKO
    PINC(0)->CR.W  = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af1_w;

  //URT0 TX / RX
    // PINB(2)->CR.W  = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af10_w;
    // PINB(3)->CR.W  = PX_CR_IOM_din_w | PX_CR_HS_disable_w | PX_CR_PU_enable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af10_w;
    PINB(8)->CR.W  = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af3_w;
    PINB(9)->CR.W  = PX_CR_IOM_din_w | PX_CR_HS_disable_w | PX_CR_PU_enable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af3_w;

//-----------------------------------------------------------------------------
    NVIC_DisableIRQ(I2C0_IRQn);

  //URT0 Initial CK_HS = 12MHz, URT0 Baudrate 230400
  //URT0 Initial CK_HS = 25MHz, URT0 Baudrate 480000
  //URT_Init(URT0);     // for Debug Information
    URT0->CR0.W = 0;
    URT0->CLK.W = URT_CLK_BR_EN_mask_w;
    URT0->CR1.W = 0x0C400C40;
    URT0->CR2.W = 0x0000000C;
    URT0->CR3.W = 0x00000A00;
    URT0->RLR.W = 0x00000101;
    URT0->CNT.W = 0x00000101;
    URT0->IRDA.W = 0x00000300;
    URT0->MUTE.W = 0x00010100;
    URT0->CR0.W = URT_CR0_EN_mask_w;

    //URT_Init(URT2);         // for Debug Information

//-----------------------------------------------------------------------------
    printf("%c[2J",27);
    printf("%c[H",27);
    printf("CPU Clock 24MHz\n\r");
    printf("Baud Rate 460800Hz\n\r");

    printf("Initial Ready \n\r");

//-----------------------------------------------------------------------------

    // Middleware
    Sample_MID_I2C_MEM();

    printf("    End\n\r");
    while(1)
    {
        //To do......
    }
}



volatile static uint8_t gURT0_First = 0;
int fputc(int ch, FILE *f)
{
    (void)f;
    if(gURT0_First == 0)
        gURT0_First = 1;
    else
        while((URT0->STA.W & URT_STA_TCF_mask_w) == 0);
    URT0->STA.W = URT_STA_TCF_mask_w;
    URT0->TDAT.B[0] = (uint8_t)ch;
    return ch;
}

int fgetc(FILE *f)
{
    int ch;

    (void)f;
    while(URT0->STA.MBIT.RXF == 0);
    ch = URT0->RDAT.B[0];
    return ch;
}


