

/**
 ******************************************************************************
 *
 * @file        Sample_main_wizard.C
 * @brief       MG32 demo main c Code. 
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/05/24
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */



/* Includes ------------------------------------------------------------------*/
#include "MG32_DRV.h"
#include "MG32_ChipInit.h"
#include "Sample_RTC_ShowCalendar.h"
/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
extern __IO uint8_t MG32_Calendar_Date_Ready;
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

int main(void)
{    
    SMP_PerpetualCalendarDef RTC_Calendar;
    
    // ------------------------------------------------------------------------
    // chip initial (User can enable CSC, GPIO, TM, ADC, EXIC ... wizard)
    // ------------------------------------------------------------------------
    ChipInit();    
        
    RTC_Calendar.year = 2022;
    RTC_Calendar.month = May;
    RTC_Calendar.day = 2;
    RTC_Calendar.hour = 10;
    RTC_Calendar.minute = 30;
    RTC_Calendar.second = 20;
    Sample_RTC_ShowCalendar(&RTC_Calendar);
    
    while(1)
    {
        //To do......
        if(MG32_Calendar_Date_Ready==1)
        {
            Sample_RTC_CaptureConvert(&RTC_Calendar);
            
            printf("\n%d/%d/%d %d:%d.%d\n", RTC_Calendar.year, RTC_Calendar.month, RTC_Calendar.day, RTC_Calendar.hour, RTC_Calendar.minute, RTC_Calendar.second);
            fflush(stdout);
            printf("Weekend:%d\n",RTC_Calendar.weekend);
            fflush(stdout);
            MG32_Calendar_Date_Ready = 0;
        }
    }
}




















