/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** DM           Daniel Mysliwitz                                              **
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2015-08-07, DM:   Initial version                                  **
** V1.1.0: 2016-03-18, DM:   PORT added                                       **
** V1.2.0: 2017-04-17, DM:   Device initialization moved into TLE_Init()      **
** V1.2.1: 2017-10-17, DM:   MISRA 2012 compliancy                            **
** V1.2.2: 2018-03-06, DM:   MISRA 2012 doesn't like 'int main(...)' while the**
**                           ARM compiler likes it pretty much, therefore     **
**                           Note 970 gets disabled temporarily               **
** V1.2.3: 2020-02-20, BG:   Updated phi calculation in degrees               **
** V1.2.4: 2020-02-27, BG:   Updated revision history                         **
** V1.2.5: 2021-07-19, BG:   Removed warnings for ARMCC v6 compiler           **
** V1.3.1: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** SDADC: Angle calculation                                                   **
********************************************************************************
** For this example, you need to use a board with TLE9868QXB20.               **
** Connect a TMR sensor (e.g. TLE5501) to the board.                          **
** When rotating a magnet on the TMR sensor, you can measure the angle        **
** between the sensor and magnetization direction.                            **
** Pin Layout of the TMR Sensor on TLE9868QXB20 EvalBoard v0.5:               **
**    - P2.3: ADC3.P                                                          **
**    - P2.7: ADC3.N                                                          **
**    - P2.4: ADC4.P                                                          **
**    - P2.5: ADC4.N                                                          **
*******************************************************************************/

#include "tle_device.h"
#include <math.h>

void SDADC_ISR_Ch0(void);
void SDADC_ISR_Ch1(void);

__USED static sint16 sdadc_sin, sdadc_cos;
__USED static double phi_d;
__USED static uint16 phi_u;
static const double PI_const = 3.14159265359;


int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();
  /* Set start of conversion for both ADC3 and ADC4 */
  SDADC_SOC_Set();

  for (;;)
  {
    (void)WDT1_Service();
    /* Retrieve angle in radians */
    phi_d = atan2((double)sdadc_sin, (double)sdadc_cos);

    /* Convert phi_d into an angle in degrees, between 0 and 359 degrees */
    if (phi_d < 0)
    {
      phi_d += 2 * PI_const;
    }

    phi_u = (uint16)((phi_d * 180) / PI_const);
  }
}


/* Callback function to get sinus value */
void SDADC_ISR_Ch0(void)
{
  sdadc_sin = SDADC_Ch0_Result_Get();
}


/* Callback function to get cosinus value */
void SDADC_ISR_Ch1(void)
{
  sdadc_cos = SDADC_Ch1_Result_Get();
}
