/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2020-02-27, BG:   Initial version of revision history              **
** V1.0.1: 2021-07-19, BG:   Removed warnings for ARMCC v6 compiler           **
** V1.1.1: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** ADC1: Display Poti position with LEDs, running ADC1 in EIM                 **
********************************************************************************
** Read Poti voltage with ADC1-Ch4, measuring Ch4 in EIM.                     **
** The EIM is triggered by Timer13 (CCU6) with a 1ms rate.                    **
** The voltage measured on Ch4 is divided in 8 intervals and displayed        **
** accordingly on the 8 LEDs.                                                 **
*******************************************************************************/

#include "tle_device.h"
#include "eval_board.h"

void Poti_Handler(void);


int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();
  /* Start Timer13 */
  CCU6_StartTmr_T13();

  for (;;)
  {
    (void)WDT1_Service();
  }
}


void Poti_Handler(void)
{
#define Interval_mV 555u
  uint16 mV;
  bool value_valid;
  value_valid = ADC1_GetEIMResult_mV(&mV);

  if (value_valid == true)
  {
    switch (mV / Interval_mV)
    {
      case 0:
        PORT_ChangePin(LED1, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED2, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED3, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED4, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED5, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED6, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED7, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED8, PORT_ACTION_CLEAR);
        break;
      case 1:
        PORT_ChangePin(LED1, PORT_ACTION_SET);
        PORT_ChangePin(LED2, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED3, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED4, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED5, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED6, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED7, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED8, PORT_ACTION_CLEAR);
        break;
      case 2:
        PORT_ChangePin(LED1, PORT_ACTION_SET);
        PORT_ChangePin(LED2, PORT_ACTION_SET);
        PORT_ChangePin(LED3, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED4, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED5, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED6, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED7, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED8, PORT_ACTION_CLEAR);
        break;
      case 3:
        PORT_ChangePin(LED1, PORT_ACTION_SET);
        PORT_ChangePin(LED2, PORT_ACTION_SET);
        PORT_ChangePin(LED3, PORT_ACTION_SET);
        PORT_ChangePin(LED4, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED5, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED6, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED7, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED8, PORT_ACTION_CLEAR);
        break;
      case 4:
        PORT_ChangePin(LED1, PORT_ACTION_SET);
        PORT_ChangePin(LED2, PORT_ACTION_SET);
        PORT_ChangePin(LED3, PORT_ACTION_SET);
        PORT_ChangePin(LED4, PORT_ACTION_SET);
        PORT_ChangePin(LED5, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED6, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED7, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED8, PORT_ACTION_CLEAR);
        break;
      case 5:
        PORT_ChangePin(LED1, PORT_ACTION_SET);
        PORT_ChangePin(LED2, PORT_ACTION_SET);
        PORT_ChangePin(LED3, PORT_ACTION_SET);
        PORT_ChangePin(LED4, PORT_ACTION_SET);
        PORT_ChangePin(LED5, PORT_ACTION_SET);
        PORT_ChangePin(LED6, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED7, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED8, PORT_ACTION_CLEAR);
        break;
      case 6:
        PORT_ChangePin(LED1, PORT_ACTION_SET);
        PORT_ChangePin(LED2, PORT_ACTION_SET);
        PORT_ChangePin(LED3, PORT_ACTION_SET);
        PORT_ChangePin(LED4, PORT_ACTION_SET);
        PORT_ChangePin(LED5, PORT_ACTION_SET);
        PORT_ChangePin(LED6, PORT_ACTION_SET);
        PORT_ChangePin(LED7, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED8, PORT_ACTION_CLEAR);
        break;
      case 7:
        PORT_ChangePin(LED1, PORT_ACTION_SET);
        PORT_ChangePin(LED2, PORT_ACTION_SET);
        PORT_ChangePin(LED3, PORT_ACTION_SET);
        PORT_ChangePin(LED4, PORT_ACTION_SET);
        PORT_ChangePin(LED5, PORT_ACTION_SET);
        PORT_ChangePin(LED6, PORT_ACTION_SET);
        PORT_ChangePin(LED7, PORT_ACTION_SET);
        PORT_ChangePin(LED8, PORT_ACTION_CLEAR);
        break;
      default:
        PORT_ChangePin(LED1, PORT_ACTION_SET);
        PORT_ChangePin(LED2, PORT_ACTION_SET);
        PORT_ChangePin(LED3, PORT_ACTION_SET);
        PORT_ChangePin(LED4, PORT_ACTION_SET);
        PORT_ChangePin(LED5, PORT_ACTION_SET);
        PORT_ChangePin(LED6, PORT_ACTION_SET);
        PORT_ChangePin(LED7, PORT_ACTION_SET);
        PORT_ChangePin(LED8, PORT_ACTION_SET);
        break;
    }
  }
}

