/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2020-02-27, BG:   Initial version of revision history              **
** V1.0.1: 2021-07-19, BG:   Removed warnings for ARMCC v6 compiler           **
** V1.1.1: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** ADC2: VS over- and undervoltage detection                                  **
********************************************************************************
** Enable VS over- and undervoltage interrupt.                                **
** LED6 will be on in case of VS undervoltage below 7V.                       **
** LED7 will be on in case of VS overvoltage above 18.5V.                     **
*******************************************************************************/

#include "tle_device.h"
#include "eval_board.h"

void Diagnostic_Status_Clear(void);
void VS_Over_Voltage_Diag(void);
void VS_Under_Voltage_Diag(void);


int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();

  for (;;)
  {
    (void)WDT1_Service();
    Diagnostic_Status_Clear();
  }
}


/* Callback Function for ADC2 VS Upper Threshold Interrupt */
void VS_Over_Voltage_Diag(void)
{
  PORT_ChangePin(LED7, PORT_ACTION_SET);
}


/* Callback Function for ADC2 VS Lower Threshold Interrupt */
void VS_Under_Voltage_Diag(void)
{
  PORT_ChangePin(LED6, PORT_ACTION_SET);
}


void Diagnostic_Status_Clear(void)
{
  /* Check for VS overvoltage */
  if (SCUPM->SYS_SUPPLY_IRQ_STS.bit.VS_OV_STS == 1u)
  {
    /* Clear VS overvoltage status */
    SCUPM->SYS_SUPPLY_IRQ_CLR.bit.VS_OV_SCLR = 1u;
	/* Clear VS overvoltage status with '0' to add an extra MI_CLCK cycle */
    SCUPM->SYS_SUPPLY_IRQ_CLR.bit.VS_OV_SCLR = 0u;

    /* Status set again if overvoltage is still present */
    /* Status remains cleared if overvoltage is gone */
    if (SCUPM->SYS_SUPPLY_IRQ_STS.bit.VS_OV_STS == 0u)
    {
      /* If status stays clear, no more overvoltage condition and LED can be cleared */
      PORT_ChangePin(LED7, PORT_ACTION_CLEAR);
    }
  }

  /* Check for VS undervoltage */
  if (SCUPM->SYS_SUPPLY_IRQ_STS.bit.VS_UV_STS == 1u)
  {
    /* Clear VS undervoltage status */
    SCUPM->SYS_SUPPLY_IRQ_CLR.bit.VS_UV_SCLR = 1u;
	/* Clear VS undervoltage status with '0' to add an extra MI_CLCK cycle */
    SCUPM->SYS_SUPPLY_IRQ_CLR.bit.VS_UV_SCLR = 0u;

    /* Status set again if overvoltage is still present */
    /* Status remains cleared if overvoltage is gone */
    if (SCUPM->SYS_SUPPLY_IRQ_STS.bit.VS_UV_STS == 0u)
    {
      /* If status stays clear, no more overvoltage condition and LED can be cleared */
      PORT_ChangePin(LED6, PORT_ACTION_CLEAR);
    }
  }
}
