/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                                                                            **
**                _  _               ___             _                        **
**               (_)| |__   _ __    / _ \ _ __ ___  | |__    /\  /\           **
**               | || '_ \ | '__|  / /_\/| '_ ` _ \ | '_ \  / /_/ /           **
**               | || | | || |    / /_\\ | | | | | || |_) |/ __  /            **
**               |_||_| |_||_|    \____/ |_| |_| |_||_.__/ \/ /_/             **
**                                                                            **
**  ihr GmbH                                                                  **
**  Airport Boulevard B210                                                    **
**  77836 Rheinm�nster - Germany                                              **
**  http://www.ihr.de                                                         **
**  Phone +49(0) 7229-18475-0                                                 **
**  Fax   +49(0) 7229-18475-11                                                **
**                                                                            **
********************************************************************************
**                                                                            **
** (c) Alle Rechte bei IHR GmbH, auch fuer den Fall von Schutzrechts-         **
** anmeldungen. Jede Verfuegungsbefugnis, wie Kopier- und Weitergaberecht     **
** bei uns.                                                                   **
**                                                                            **
** (c) All rights reserved by IHR GmbH including the right to file            **
** industrial property rights. IHR GmbH retains the sole power of             **
** disposition such as reproduction or distribution.                          **
**                                                                            **
*********************    Workfile:    main.c              **********************
**                                                                            **
**  PROJECT-DESCRIPTION:  Infineon LIN Slave Driver                           **
**                                                                            **
**  FILE-DESCRIPTION:  main application file                                  **
**                                                                            **
*******************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** BR           B.Roegl                                                       **
** HS           H. Spinner                                                    **
** BG           Blandine Guillot                                              **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2014-02-18, HS:   New Demo driver for Infineon TLE9869             **
** V1.0.1: 2020-02-27, BG:   Updated abstract                                 **
** V1.0.2: 2021-07-19, BG:   Removed warnings for ARMCC v6 compiler           **
** V1.0.3: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** BDRV: Drive a DC motor over LIN                                            **
********************************************************************************
** Two boards are necessary for this example:                                 **
**  - Flash the LIN_MASTER example on the master board                        **
**  - Flash this example on the slave board, to which the motor is connected  **
** Both boards are connected over LIN. The Poti position on the first board   **
** will determine the motor speed.                                            **
*******************************************************************************/

#include "tle_device.h"
#include "linmain.h"
#include "eval_board.h"

#include "genLinConfig.h"
#include "lin_driver_api.h"

__USED uint16 speed;

int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();

  /* Initialize LIN LLD */
  LIN_LLD_Init();
  
  /* Configure bridge to run PWM on Phase 2 - forward */
  BDRV_Set_Bridge(Ch_PWM, Ch_PWM, Ch_En, Ch_On);

  /* Start PWM generation */
  CCU6_StartTmr_T12();
  
  for (;;)
  {
    /* Main watchdog service */
    (void)WDT1_Service();
    
    /* Handle LIN service */
    LIN_LLD_Service();
   
    if (l_flg_tst_RefSpeed())
    {
      /* Motor speed is read from Poti position and transmitted over LIN */
      speed = l_u16_rd_RefSpeed();
      if (speed < 1200)
      {
        CCU6_LoadShadowRegister_CC60(speed);
        CCU6_EnableST_T12();
      }
    }
  }
}


#if defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6000000)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wmissing-prototypes"
#endif
void Bdrv_Diagnose(void)
{
  /* Clear all LEDs used for diagnosis */
  PORT_ChangePin(LED6, PORT_ACTION_CLEAR);
  PORT_ChangePin(LED5, PORT_ACTION_CLEAR);
  PORT_ChangePin(LED3, PORT_ACTION_CLEAR);
  PORT_ChangePin(LED4, PORT_ACTION_CLEAR);

  if (BDRV->CTRL1.bit.LS1_OC_STS == 1)
  {
    /* Overcurrent detected on Low Side 1 */
    /* LED6 turned on */
    PORT_ChangePin(LED6, PORT_ACTION_SET);
    /* Clear status bit */
    SCUPM->BDRV_ISCLR.bit.LS1_OC_ICLR = 1;
  }
  if (BDRV->CTRL1.bit.HS1_OC_STS == 1)
  {
    /* Overcurrent detected on High Side 1 */
    /* LED5 turned on */
    PORT_ChangePin(LED5, PORT_ACTION_SET);
    /* Clear status bit */
    SCUPM->BDRV_ISCLR.bit.HS1_OC_ICLR = 1;
  }
  if (BDRV->CTRL1.bit.LS2_OC_STS == 1)
  {
    /* Overcurrent detected on Low Side 2 */
    /* LED4 turned on */
    PORT_ChangePin(LED4, PORT_ACTION_SET);
    /* Clear status bit */
    SCUPM->BDRV_ISCLR.bit.LS2_OC_ICLR = 1;
  }
  if (BDRV->CTRL1.bit.HS2_OC_STS == 1)
  {
    /* Overcurrent detected on High Side 2 */
    /* LED3 turned on */
    PORT_ChangePin(LED3, PORT_ACTION_SET);
    /* Clear status bit */
    SCUPM->BDRV_ISCLR.bit.HS2_OC_ICLR = 1;
  }

  if ((BDRV->CTRL1.bit.LS1_DS_STS == 1) && (BDRV->CTRL1.bit.LS1_DCS_EN == 1))
  {
    /* Short detected on Low Side 1 */
    /* LED6 turned on */
    PORT_ChangePin(LED6, PORT_ACTION_SET);
    /* Clear status bit */
    SCUPM->BDRV_ISCLR.bit.LS1_DS_ICLR = 1;
  }
  if ((BDRV->CTRL1.bit.HS1_DS_STS == 1) && (BDRV->CTRL1.bit.HS1_DCS_EN == 1))
  {
    /* Short detected on High Side 1 */
    /* LED5 turned on */
    PORT_ChangePin(LED5, PORT_ACTION_SET);
    /* Clear status bit */
    SCUPM->BDRV_ISCLR.bit.HS1_DS_ICLR = 1;
  }
  if ((BDRV->CTRL1.bit.LS2_DS_STS == 1) && (BDRV->CTRL1.bit.LS2_DCS_EN == 1))
  {
    /* Short detected on Low Side 2 */
    /* LED4 turned on */
    PORT_ChangePin(LED4, PORT_ACTION_SET);
    /* Clear status bit */
    SCUPM->BDRV_ISCLR.bit.LS2_DS_ICLR = 1;
  }
  if ((BDRV->CTRL1.bit.HS2_DS_STS == 1) && (BDRV->CTRL1.bit.HS2_DCS_EN == 1))
  {
    /* Short detected on High Side 2 */
    /* LED3 turned on */
    PORT_ChangePin(LED3, PORT_ACTION_SET);
    /* Clear status bit */
    SCUPM->BDRV_ISCLR.bit.HS2_DS_ICLR = 1;
  }
  
  WDT1_Service();
}
#if defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6000000)
  #pragma clang diagnostic pop
#endif
