/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2020-02-27, BG:   Initial version of revision history              **
** V1.0.1: 2021-07-19, BG:   Replaced SCU_Init and PORT_Init with TLE_Init    **
** V1.0.2: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** Blinky: Toggle pin P0.1                                                    **
********************************************************************************
** A variable is incremented till 100000. Each time this value is reached,    **
** the pin P0.1 is toggled and LED1 is turned on. The variable is             **
** reinitialized at the end.                                                  **
*******************************************************************************/

#include <eval_board.h>
#include "tle_device.h"

int main(void)
{
  int i = 0;
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();

  for (;;)
  {
    (void)WDT1_Service();
    i++;

    if (i > 100000)
    {
      /* Pin P0.1 (LED1) toggled when i bigger than 100000 */
      PORT_ChangePin(LED1, PORT_ACTION_TOGGLE);
      /* Reinitialize variable i */
      i = 0;
    }
  }
}

