/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** DM           Daniel Mysliwitz                                              **
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2014-06-17, DM:   PORT, SCU, LIN updated                           **
** V1.0.1: 2014-07-29, DM:   GPT12E added                                     **
** V1.0.2: 2021-07-19, BG:   Removed warnings for ARMCC v6 compiler           **
** V1.1.1: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** Running lights                                                             **
********************************************************************************
** All LEDs are turned on then off, one after another, continuously.          **
*******************************************************************************/

#include "tle_device.h"
#include "eval_board.h"

int PWM (int matrix_state, int position);
void PWM1_LEDsOn(void);
void PWM2_LEDsOn(void);
void PWM3_LEDsOn(void);
void PWM_PM_AllOff(void);

__USED static int i = 0; /* Stepwidth = (PWMPeriod * i) */
__USED static int x = 1; /* sign for PWM calc. matrix state - x * position */
__USED static uint32 LED[8] = {LED1, LED2, LED3, LED4, LED5, LED6, LED7, LED8};
__USED static int state = 0;


int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();
  /* Start Timer12 */
  CCU6_StartTmr_T12();

  for (;;)
  {
    (void)WDT1_Service();
  }
}


int PWM (int matrix_state, int position)
{
  int pwm = 0;

  if (((matrix_state - x * position) == -1) || ((matrix_state - x * position) == 13))
  {
    pwm = 1;
  }

  if (((matrix_state - x * position) == 0) || ((matrix_state - x * position) == 14))
  {
    pwm = 2;
  }

  if (((matrix_state - x * position) == 1) || ((matrix_state - x * position) == 15))
  {
    pwm = 3;
  }

  return pwm;
}


void PWM1_LEDsOn(void)
{
  int y = 0;
  SCU->IEN0.reg = 0;

  for (y = 0; y < 8; y++)
  {
    if (PWM(state, y) == 1)
    {
      PORT_ChangePin (LED[y], PORT_ACTION_SET);
    }
  }

  SCU->IEN0.reg = 0x80;
}


void PWM2_LEDsOn(void)
{
  int y = 0;
  SCU->IEN0.reg = 0;

  for (y = 0; y < 8; y++)
  {
    if (PWM(state, y) == 2)
    {
      PORT_ChangePin (LED[y], PORT_ACTION_SET);
    }
  }

  SCU->IEN0.reg = 0x80;
}


void PWM3_LEDsOn(void)
{
  int y = 0;
  SCU->IEN0.reg = 0;

  for (y = 0; y < 8; y++)
  {
    if (PWM (state, y) == 3)
    {
      PORT_ChangePin (LED[y], PORT_ACTION_SET);
    }
  }

  SCU->IEN0.reg = 0x80;
}


void PWM_PM_AllOff(void)
{
  SCU->IEN0.reg = 0;
  PORT->P0_DATA.reg = 0;
  PORT->P1_DATA.reg = 0;
  SCU->IEN0.reg = 0x80;
  i++;

  if (i == 60)
  {
    state++;
    i = 0;
  }

  if (state == 7)
  {
    x = -1;
  }

  if (state == 14)
  {
    x = 1;
    state = 0;
  }
}
