/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2020-02-27, BG:   Initial version of revision history              **
** V1.0.1: 2021-07-19, BG:   Removed warnings for ARMCC v6 compiler           **
** V1.1.1: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** CCU6: Synchronisation of ADC1-EIM with CCU6 Ch0                            **
********************************************************************************
** Timer12 is running at a 50us period in center-aligned mode.                **
** The three compare channel have a compare match at:                         **
** Channel | DC  | CC6x | COUT6x                                              **
** -----------------------------                                              **
**   Ch0   |  n  | P0.4 | P0.2                                                **
**   Ch1   | 50% | P1.0 | P1.1                                                **
**   Ch2   | 75% | P1.3 | P1.4                                                **
**                                                                            **
** Timer13 (sync. to Ch0) triggers ADC1-Ch4 (Poti), which adjusts the duty    **
** cycle of Channel 0.                                                        **
*******************************************************************************/

#include "tle_device.h"
#include "eval_board.h"

void Poti_Handler(void);


int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();
  /* Start PWM generation */
  CCU6_StartTmr_T12();

  for (;;)
  {
    (void)WDT1_Service();
  }
}


void Poti_Handler(void)
{
  uint16 cmp;
  uint16 mV;
  ADC1_GetEIMResult_mV(&mV);
  cmp = CCU6_T12PR * mV / 5000;
  CCU6_LoadShadowRegister_CC60(cmp);
  CCU6_EnableST_T12();
  PORT_ChangePin(LED1, PORT_ACTION_TOGGLE);
}
