/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2020-02-27, BG:   Initial version of revision history              **
** V1.0.2: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** CCU6: Generation of three different PWMs (50us) with 25%, 50% and 75% DC   **
********************************************************************************
** Timer12 is running at a 50us period in center-aligned mode.                **
** The three compare channels have a compare match at:                        **
** Channel | DC  | CC6x | COUT6x                                              **
** -----------------------------                                              **
**   Ch0   | 25% | P0.4 | P0.2                                                **
**   Ch1   | 50% | P1.0 | P1.1                                                **
**   Ch2   | 75% | P1.3 | P1.4                                                **
*******************************************************************************/

#include "tle_device.h"
#include "eval_board.h"

int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();
  /* Start PWM generation */
  CCU6_StartTmr_T12();

  for (;;)
  {
    (void)WDT1_Service();
  }
}
