/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2020-02-27, BG:   Initial version of revision history              **
** V1.0.1: 2021-07-19, BG:   Removed warnings for ARMCC v6 compiler           **
** V1.1.1: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** DMA: Store all ADC1 channel results into an array in RAM via DMA           **
********************************************************************************
** DMA gets triggered when the ADC1 sequence is completed.                    **
** All 8 ADC1 channels are read and then stored into an array in RAM via DMA. **
*******************************************************************************/

#include "tle_device.h"

void DMA_Seq_Complete(void);

__USED uint32 adc_ch_result[DMA_CH0_NoOfTrans];


int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();
  /* Enable the DMA master */
  DMA_Master_En();

  for (;;)
  {
    (void)WDT1_Service();
  }
}


/* Callback Function on DMA complete */
void DMA_Seq_Complete(void)
{
  /* process data */
  /* ... */
  /* reload DMA Channel 0 */
  DMA_Reset_Channel(DMA_CH0, DMA_CH0_NoOfTrans);
}
