/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** DM           Daniel Mysliwitz                                              **
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2015-08-07, DM:   Initial version                                  **
** V1.0.1: 2016-03-18, DM:   Added PORT                                       **
** V1.0.2: 2021-07-19, BG:   Removed warnings for ARMCC v6 compiler           **
** V1.1.1: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** DMA: Scatter-gather                                                        **
********************************************************************************
** Four DMA tasks are defined. Each one copies data from one variable into    **
** another one.                                                               **
** DMA.Ch0 is set for Memory Scatter-Gater mode and operates on the 4 tasks.  **
** The DMA request for Ch0 is software-triggered                              **
*******************************************************************************/

#include "tle_device.h"

__USED static uint32 data0, data1;
__USED static uint16 data2, data3;
__USED static uint32 data4, data5;
__USED static uint32 data6, data7;

/* Task is being accessed from dma.c */
TDMA_Entry Task[DMA_CH0_TASK_NoOfTasks];


int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();
  /* Task[0] copies data0 to data1 */
  data0 = 0x12345678;
  data1 = 0;
  /* Task[1] copies data2 to data3 */
  data2 = 0xABCD;
  data3 = 0;
  /* Task[2] copies data4 to data5 */
  data4 = 0xAA55CC33;
  data5 = 0;
  /* Task[3] copies data6 to data7 */
  data6 = 0xDEADBEEF;
  data7 = 0;
  DMA_Task_Set(&Task[0], DMA_Cycle_Type_MemSctGthAlt, 0, (uint32)&data0, (uint32)&data1, 1, DMA_32Bit_Transfer, DMA_No_Inc);
  DMA_Task_Set(&Task[1], DMA_Cycle_Type_MemSctGthAlt, 0, (uint32)&data2, (uint32)&data3, 1, DMA_16Bit_Transfer, DMA_No_Inc);
  DMA_Task_Set(&Task[2], DMA_Cycle_Type_MemSctGthAlt, 0, (uint32)&data4, (uint32)&data5, 1, DMA_32Bit_Transfer, DMA_No_Inc);
  DMA_Task_Set(&Task[3], DMA_Cycle_Type_Basic,        0, (uint32)&data6, (uint32)&data7, 1, DMA_32Bit_Transfer, DMA_No_Inc);
  /* Enable Dma master */
  DMA_Master_En();
  /* Set software request for DMA Channels */
  DMA_Software_Request_Set(DMA_MASK_CH0);

  for (;;)
  {
    (void)WDT1_Service();
  }
}

