/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2020-02-27, BG:   Initial version of revision history              **
** V1.0.1: 2021-07-19, BG:   Removed warnings for ARMCC v6 compiler           **
** V1.1.1: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** DMA: Send out 4 SPI data words through SSC1 triggered by DMA               **
********************************************************************************
** The first SPI transfer (0x1234) is initiated manually.                     **
** Then, based on the transmit ready indication given by the SSC1 module,     **
** the DMA is triggered and fills in the next words into the SPI sendbuffer.  **
** To decode SPI message from SSC1, here are the following settings in Config **
** Wizard:                                                                    **
** - SPI CLK : P0.3 (low when inactive)                                       **
** - SPI MOSI: P0.2                                                           **
** - SPI MISO: P0.4                                                           **
** - Least significant bit first                                              **
** - 16 bits per transfer                                                     **
** - Data valid on clock trailing edge                                        **
** - Enable line is active low                                                **
*******************************************************************************/

#include "tle_device.h"

__USED uint16 spi_tx_data[DMA_CH2_NoOfTrans] = {0xAAAA, 0x3333, 0x0F0F, 0x00FF};


int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();
  /* Enable the DMA master */
  DMA_Master_En();
  /* Send the first SPI data and start DMA along with it */
  SSC1_SendWord(0x1234);

  for (;;)
  {
    (void)WDT1_Service();
  }
}
