/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2020-02-27, BG:   Initial version of revision history              **
** V1.0.1: 2021-07-19, BG:   Removed warnings for ARMCC v6 compiler           **
** V1.2.1: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** DMA: Send out a 'Hello World!' string at UART2 triggered by DMA            **
********************************************************************************
** In a terminal window set up a serial connection @115.2kBaud through the    **
** debugger port.                                                             **
** The Core timer 3 of GPT12E triggers a DMA transfer (DMA_CH12) every 100us. **
** The DMA takes one character out of the "uart_tx_data' string and puts it   **
** into the send buffer of UART2.                                             **
** The UART2 sends out the data at P1.1/P1.2 @115.2kBaud.                     **
*******************************************************************************/

#include "tle_device.h"
#include <stdio.h>

void DMA_UART_SEND_Complete(void);

__USED char uart_tx_data[DMA_CH12_NoOfTrans] = "Hello World!\r\n";


int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();
  /* Enable DMA master */
  DMA_Master_En();
  /* Start GPT12E.T3 to start DMA triggered UART transfer */
  GPT12E_T3_Start();

  for (;;)
  {
    (void)WDT1_Service();

    /* Wait for MON button to be pressed */
    if (MON_Debounce(0u) == 0u)
    {
      /* Start GPT12E.T3 to start DMA triggered UART transfer */
      GPT12E_T3_Start();
    }
  }
}


/* Callback function on DMA complete */
void DMA_UART_SEND_Complete(void)
{
  /* Stop GPT12E.T3 */
  GPT12E_T3_Stop();
  /* Send a 'DMA done' through UART2 */
  printf("DMA done\n");
  /* Reload DMA Channel 12 */
  DMA_Reset_Channel(DMA_CH12, DMA_CH12_NoOfTrans);
}
