/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2020-02-27, BG:   Initial version of revision history              **
** V1.0.1: 2021-07-19, BG:   Removed warnings for ARMCC v6 compiler           **
** V1.1.1: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** GPT12E: Concatenation of T2 and T3                                         **
********************************************************************************
** Both core timer T3 and auxiliary timer T2 of GPT12E are concatenated       **
** resulting in a 32bit timer.                                                **
** P0.2 toggles every: max. timer value * GPT clock[s]                        **
** With TLE9869QXA20: max. timer value: 4294967295 (0xFFFFFFFF)               **
**                    GPT clock set up in Config Wizard: 6MHz -> T_GPT ~ 170ns**
**                    => P0.2 toggles every 716 seconds ~ 11 min 55 s         **
*******************************************************************************/

#include "tle_device.h"
#include "eval_board.h"

void GPT12E_T2_T3_Concat_Task(void);


int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();
  /* Start core timer T3 of GPT12E */
  GPT12E_T3_Start();

  for (;;)
  {
    (void)WDT1_Service();
  }
}


void GPT12E_T2_T3_Concat_Task(void)
{
  /* Toggle LED2 (P0.2) on concatenated timer overflow */
  PORT_ChangePin(LED2, PORT_ACTION_TOGGLE);
}
