/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2020-02-27, BG:   Initial version of revision history              **
** V1.0.2: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** GPT12E: T2 working as reload for T3                                        **
********************************************************************************
** Auxiliary timer2 of GPT12E is set up for reloading core timer T3.          **
** Upon T3 overflow, the value of T2 will be loaded into T3 and T3OUT (P1.2)  **
** is toggled.                                                                **
*******************************************************************************/

#include "tle_device.h"

int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();
  /* Start core timer T3 of GPT12E */
  GPT12E_T3_Start();

  for (;;)
  {
    (void)WDT1_Service();
  }
}
