/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

#include "linmain.h"

/*******************************************************************************
**                        Global Variable Declarations                        **
*******************************************************************************/
/* Global variables */
volatile unsigned char timer_250us, timer_1ms;
volatile uint16 timer_1s;
unsigned int BusIdleTimeOutCounter, tmpStatus;

/*******************************************************************************
**                         Global Function Definitions                        **
*******************************************************************************/

void LIN_LLD_Init(void)
{
  TIMER21_Start();
  /* Init LIN driver */
  l_sys_init();
}

void LIN_LLD_Service(void)
{
  if (timer_250us)
  {
    timer_250us = 0u;
    /* Cyclic communication task has to be called once every byte */
    l_cyclic_com_task();
  }

  /* 1ms cyclic task */
  if (timer_1ms >= 4u)
  {
    timer_1ms = 0u;
    l_sch_tick();
    /* Cyclic task of driver (timeout and diagnostic control) */
    ld_task();
  }
}

l_irqmask l_sys_irq_disable (void)
{
  return 0u;
}

void l_sys_irq_restore (l_irqmask mask)
{
  return;
}

void LIN_Enable_Transceiver(void)
{
}

void LIN_Disable_Transceiver(void)
{
}

void LIN_Task_250us(void)
{
  timer_250us++;
  timer_1ms++;
  timer_1s++;
}

void LIN_COM_Handler(void)
{
#ifdef AUTOBAUD_ENABLED

  if (TIMER2->T2CON.bit.EXF2 == 1u)
  {
    l_ifc_t2();
    TIMER2->T2ICLR.bit.EXF2CLR = 1u;
  }

#endif /* end #ifdef AUTOBAUD_ENABLED */

  if ((UART1->SCON.reg & 0x01u) == 1u)
  {
    l_ifc_rx();
    UART1->SCONCLR.bit.RICLR = 1u;
  }
}
