/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** BR           B.Roegl                                                       **
** HS           H. Spinner                                                    **
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2014-02-18, HS:   New Demo driver for Infineon TLE9869             **
** V1.0.1: 2020-02-27, BG:   Updated abstract                                 **
** V1.0.2: 2021-07-19, BG:   Removed warnings for ARMCC v6 compiler           **
** V1.1.1: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** LIN: Configuration as master                                               **
********************************************************************************
** This example is working in combination with the LIN_SLAVE example.         **
** The Poti position is read out at ADC1-CH4, measuring Ch4 in sequencer mode.**
** This value is written into RefSpeed and sent to the slave board over LIN.  **
*******************************************************************************/

#include "linmain.h"
#include "genLinConfig.h"
#include "lin_driver_api.h"

__USED uint16 Poti_Value_mV;
void Poti_LED_Display(uint16 mV);

int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();
  /* Initialize LIN LLD */
  LIN_LLD_Init();
  /* Start LIN scheduler */
  l_sch_set(0u, 0u);

  for (;;)
  {
    (void)WDT1_Service();
    /* Handle LIN service */
    LIN_LLD_Service();
    /* Display the poti value on the board LEDs */
    Poti_LED_Display(Poti_Value_mV);
  }
}

void Poti_LED_Display(uint16 mV)
{
#define Interval_mV 625u

  if (mV == 0u)
  {
    PORT_P01_Output_Low_Set();
  }

  if (mV > (0u * Interval_mV))
  {
    PORT_P01_Output_High_Set();
    PORT_P02_Output_Low_Set();
  }

  if (mV > (1u * Interval_mV))
  {
    PORT_P02_Output_High_Set();
    PORT_P03_Output_Low_Set();
  }

  if (mV > (2u * Interval_mV))
  {
    PORT_P03_Output_High_Set();
    PORT_P12_Output_Low_Set();
  }

  if (mV > (3u * Interval_mV))
  {
    PORT_P12_Output_High_Set();
    PORT_P10_Output_Low_Set();
  }

  if (mV > (4u * Interval_mV))
  {
    PORT_P10_Output_High_Set();
    PORT_P13_Output_Low_Set();
  }

  if (mV > (5u * Interval_mV))
  {
    PORT_P13_Output_High_Set();
    PORT_P14_Output_Low_Set();
  }

  if (mV > (6u * Interval_mV))
  {
    PORT_P14_Output_High_Set();
    PORT_P04_Output_Low_Set();
  }

  if (mV > (7u * Interval_mV))
  {
    PORT_P04_Output_High_Set();
  }
}

void Poti_Value(void)
{
  /* Read the value at Ch4 (Poti) in mV *
   * Values between 0 and 5000 are possible */
  if (ADC1_GetChResult_mV(&Poti_Value_mV, ADC1_CH4) == true)
  {
    /* Write the Poti value as speed parameter onto LIN */
    l_u16_wr_RefSpeed(Poti_Value_mV);
  }
}
