/*****************************************************************************\
*                                                                             *
*                _  _               ___             _                         *
*               (_)| |__   _ __    / _ \ _ __ ___  | |__    /\  /\            *
*               | || '_ \ | '__|  / /_\/| '_ ` _ \ | '_ \  / /_/ /            *
*               | || | | || |    / /_\\ | | | | | || |_) |/ __  /             *
*               |_||_| |_||_|    \____/ |_| |_| |_||_.__/ \/ /_/              *
*                                                                             *
*  ihr GmbH                                                                   *
*  Airport Boulevard B210                                                     *
*  77836 Rheinmnster - Germany                                               *
*  http://www.ihr.de                                                          *
*  Phone +49(0) 7229-18475-0                                                  *
*  Fax   +49(0) 7229-18475-11                                                 *
*                                                                             *
*******************************************************************************
*                                                                             *
*                                                                             *
* (c) Alle Rechte bei IHR GmbH, auch fuer den Fall von Schutzrechts-          *
* anmeldungen. Jede Verfuegungsbefugnis, wie Kopier- und Weitergaberecht      *
* bei uns.                                                                    *
*                                                                             *
* (c) All rights reserved by IHR GmbH including the right to file             *
* industrial property rights. IHR GmbH retains the sole power of              *
* disposition such as reproduction or distribution.                           *
*                                                                             *
*                                                                             *
********************   Workfile:      lin_driver_api.h     ********************
*                                                                             *
*  PROJECT-DESCRIPTION:  LIN Driver Protocol Layer                            *
*                                                                             *
*  FILE-DESCRIPTION:  All defines for lin_driver_api.c                        *
*                                                                             *
*                                                                             *
*******************************************************************************
*       Revision:       1.0                                                   *
*       Responsible:    B. Roegl                                              *
*       Creation date:  18/02/2014                                            *
*       Last Modtime:   18/02/2014                                            *
*                                                                             *
*  HISTORY:                                                                   *
*                                                                             *
*    Rev 1.0   18/02/2014 by H. Spinner                                       *
*         - New Demo driver for TLE986x/7x                                    *
*                                                                             *
\*****************************************************************************/
/**
@file   lin_driver_api.h
@brief   Header file for lin_driver_api.c
*/

#ifndef LIN_DRIVER_API_H /* to interprete header file only once */
#define LIN_DRIVER_API_H

#include "genLinConfig.h"
#include "lin_type.h"
#include "lin_main.h"
#include "lin_hal.h"
#ifdef LIN_MASTER
#include "lin_master_task.h"
#endif /* end #ifdef LIN_MASTER */


/* ===========================================================================
 *  Constants
 * ==========================================================================*/



/* ===========================================================================
 *  Structures
 * ==========================================================================*/

/* ===========================================================================
 *  Prototypes
 * ==========================================================================*/

l_bool l_sys_init (void);
#ifdef LIN_MASTER
l_u8 l_sch_tick (void);

void l_sch_set (l_u16 schedule, l_u8 entry);
#endif /* ifdef LIN_MASTER */
l_bool l_ifc_init (void);
l_u16 l_ifc_ioctl (l_ioctl_op op, void* pv);
l_u16 l_ifc_read_status(void);   
l_irqmask l_sys_irq_disable (void);
void l_sys_irq_restore (l_irqmask mask);
void LIN_Enable_Transceiver(void);
void LIN_Disable_Transceiver(void);

#ifdef LIN_MASTER
   l_u8 l_sch_tick (void);
   void l_sch_set (l_u16, l_u8);
#endif /* ifdef LIN_MASTER */



/* TASK for LIN Communication outside the ISR. */
#define l_cyclic_com_task()            l_hal_cyclic_call()

#define l_ifc_wake_up()    lin_hal_tx_wake_up();
#define l_ifc_rx()         lin_hal_ISR()
#define l_ifc_tx()
#define l_ifc_aux()


#ifndef LIN_PROTOCOL_VERSION_1_3
   #define ld_task()                do { l_frame_timeout_control(); } while (0)
#else
   #define ld_task()                do { } while (0)
#endif /* end #ifndef LIN_PROTOCOL_VERSION_1_3 */

/* TASK for LIN Communication outside the ISR. */
#define l_cyclic_com_task()            l_hal_cyclic_call()
void LIN_Enable_Transceiver(void);
void LIN_Disable_Transceiver(void);

#ifdef LIN_LIN_PROTOCOL_VERSION_1_3
/**
    @brief      Connect interface to the LIN bus
    @note       The call to the l_ifc_connect will connect the node to the LIN network and
        enable  the transmission of headers and data on the bus. Calls internally
        LIN_Enable_Transceiver().
*/
#define l_ifc_connect()     {LIN_Enable_Transceiver(); return 0;}

/**
    @brief      Disconnect interface from the LIN bus
    @note       The call to the l_ifc_disconnect will disconnect the node from the LIN network
        and thus disable the transmission of headers and data on the bus. Call internally
        LIN_Disable_Transceiver().
*/
#define l_ifc_disconnect()    {LIN_Disable_Transceiver(); return 0;}
#endif /* ifdef LIN_LIN_PROTOCOL_VERSION_1_3 */

#endif /* end #ifndef LIN_DRIVER_API_H */
