/*****************************************************************************\
*                                                                             *
*                _  _               ___             _                         *
*               (_)| |__   _ __    / _ \ _ __ ___  | |__    /\  /\            *
*               | || '_ \ | '__|  / /_\/| '_ ` _ \ | '_ \  / /_/ /            *
*               | || | | || |    / /_\\ | | | | | || |_) |/ __  /             *
*               |_||_| |_||_|    \____/ |_| |_| |_||_.__/ \/ /_/              *
*                                                                             *
*  ihr GmbH                                                                   *
*  Airport Boulevard B210                                                     *
*  77836 Rheinmnster - Germany                                               *
*  http://www.ihr.de                                                          *
*  Phone +49(0) 7229-18475-0                                                  *
*  Fax   +49(0) 7229-18475-11                                                 *
*                                                                             *
*******************************************************************************
*                                                                             *
*                                                                             *
* (c) Alle Rechte bei IHR GmbH, auch fuer den Fall von Schutzrechts-          *
* anmeldungen. Jede Verfuegungsbefugnis, wie Kopier- und Weitergaberecht      *
* bei uns.                                                                    *
*                                                                             *
* (c) All rights reserved by IHR GmbH including the right to file             *
* industrial property rights. IHR GmbH retains the sole power of              *
* disposition such as reproduction or distribution.                           *
*                                                                             *
*                                                                             *
********************   Workfile:      lin_main.c      *************************
*                                                                             *
*  PROJECT-DESCRIPTION:  LIN Driver Protocol Layer                            *
*                                                                             *
*  FILE-DESCRIPTION:  Main routines for LIN driver                            *
*                                                                             *
*                                                                             *
*******************************************************************************
*       Revision:       1.0                                                   *
*       Responsible:    B. Roegl                                              *
*       Creation date:  18/02/2014                                            *
*       Last Modtime:   18/02/2014                                            *
*                                                                             *
*  HISTORY:                                                                   *
*                                                                             *
*    Rev 1.0   18/02/2014 by H. Spinner                                       *
*         - New Demo driver for TLE986x/7x                                    *
*                                                                             *
\*****************************************************************************/
/**
@file lin_main.c
@brief Implementation of the Main Functionality inside the LIN Driver
*/

/* ===========================================================================
 *  Header files
 * ==========================================================================*/

#define LIN_MAIN_C
#include "genLinConfig.h"
#include "lin_hal.h"
#include "lin_slave_task.h"
#include "lin_driver_api.h"

#include "lin_main.h"

/* ===========================================================================
 *  Global Variables
 * ==========================================================================*/

l_u8              g_lin_frame_index                      = 0xFFu;
l_u8              g_lin_active_pid                       = 0x0u;
t_Lin_Frame_Ctrl  g_lin_frame_ctrl[LIN_NUMBER_OF_FRAMES] = LIN_FRAME_CTRL_INIT;  /* init with const from lin_config_file */
t_lin_prod_id     g_lin_prod_id;                                                 /* init with const from lin_config_file */
t_lin_status_word g_lin_status_word;
l_irqmask         g_lin_irqState                         = 0u;
l_u8              g_lin_frame_data_size                  = 0u;

#ifdef LIN_MASTER
l_u8                       g_ld_NodeConfRSID;
l_u8                       g_ld_NodeConfErr;
t_lin_sched_data    g_lin_sched_data;
l_u16  g_activeScheduleIdx;
l_u8        g_ScheduleFrmIdx;
l_u16       g_ScheduleIdx;
l_u16       g_sav_schedtab;
l_u8        g_sav_schedfrmidx;
l_u8        g_lin_config_status;
l_u8        g_lin_zero_schedule;
l_u16       g_nextScheduleIdx;
l_u8        g_nextScheduleFrmIdx;
l_u16        g_ld_timer_stmin;
l_u16        g_ld_timer_p2 = 0xFFFFu;
#ifdef LIN_2_X
l_u8        g_diag_status = 0x00u;
#endif /* end #ifdef LIN_2_X */
#endif /* end #ifdef LIN_MASTER */

/* ===========================================================================
 *  Functions
 * ==========================================================================*/

/* ---------------------------------------------------------------------------
 *  void lin_main_init(void)
 * --------------------------------------------------------------------------*/
/**
   @brief  Initializes driver, calls HAL-init
   @param  void
   @retval void
*/
void lin_main_init(void)
{
#ifdef LIN_MASTER
   g_lin_zero_schedule = L_SET;
   Init_ScheduleTableList();
#endif /* end #ifdef LIN_MASTER */

   /* init the Hardware */
   lin_hal_init();

   g_lin_status_word.reg = 0u;
}

/* ---------------------------------------------------------------------------
 *  void l_get_byte_array(l_u8 start[], l_u8 count, l_u8 destination[])
 * --------------------------------------------------------------------------*/
/**
   @brief  Fetch a byte array 
   @pre    LIN driver initialized
   @param  l_u8 start        source buffer
   @param  l_u8 count        number of bytes to be copied
   @param  l_u8 destination  target buffer
   @retval void
*/
void l_get_byte_array(l_u8 start[], l_u8 count, l_u8 destination[])
{
   l_u8 loc_i;
   for(loc_i = 0u; loc_i < count; loc_i++)
   {
      destination[loc_i] = start[loc_i];
   }
}

/* ---------------------------------------------------------------------------
 *  void l_set_byte_array(l_u8 start[], l_u8 count, const l_u8 source[])
 * --------------------------------------------------------------------------*/
/**
   @brief  Set a byte array 
   @pre    LIN driver initialized
   @param  l_u8 start        target buffer
   @param  l_u8 count        number of bytes to be copied
   @param  l_u8 source       source buffer
   @retval void
*/
void l_set_byte_array(l_u8 start[], l_u8 count, const l_u8 source[])
{
   l_u8 loc_i;
   for(loc_i = 0u; loc_i < count; loc_i++)
   {
      start[loc_i] = source[loc_i];
   }
}
