/******************************************************************************
*                                                                             *
*                _  _               ___             _                         *
*               (_)| |__   _ __    / _ \ _ __ ___  | |__    /\  /\            *
*               | || '_ \ | '__|  / /_\/| '_ ` _ \ | '_ \  / /_/ /            *
*               | || | | || |    / /_\\ | | | | | || |_) |/ __  /             *
*               |_||_| |_||_|    \____/ |_| |_| |_||_.__/ \/ /_/              *
*                                                                             *
*  ihr GmbH                                                                   *
*  Airport Boulevard B210                                                     *
*  77836 Rheinmnster - Germany                                               *
*  http://www.ihr.de                                                          *
*  Phone +49(0) 7229-18475-0                                                  *
*  Fax   +49(0) 7229-18475-11                                                 *
*                                                                             *
*******************************************************************************
*                                                                             *
*                                                                             *
* (c) Alle Rechte bei IHR GmbH, auch fuer den Fall von Schutzrechts-          *
* anmeldungen. Jede Verfuegungsbefugnis, wie Kopier- und Weitergaberecht      *
* bei uns.                                                                    *
*                                                                             *
* (c) All rights reserved by IHR GmbH including the right to file             *
* industrial property rights. IHR GmbH retains the sole power of              *
* disposition such as reproduction or distribution.                           *
*                                                                             *
*                                                                             *
********************   Workfile:      lin_main.h        ***********************
*                                                                             *
*  PROJECT-DESCRIPTION:  LIN Driver Protocol Layer                            *
*                                                                             *
*  FILE-DESCRIPTION:  All defines for lin_main.c                              *
*                                                                             *
*                                                                             *
*******************************************************************************
*       Revision:       1.0                                                   *
*       Responsible:    B. Roegl                                              *
*       Creation date:  18/02/2014                                            *
*       Last Modtime:   18/02/2014                                            *
*                                                                             *
*  HISTORY:                                                                   *
*                                                                             *
*    Rev 1.0   18/02/2014 by H. Spinner                                       *
*         - New Demo driver for TLE986x/7x                                    *
*                                                                             *
 *****************************************************************************/
/**
@file lin_main.h
@brief Header file of lin_main.c
*/

#ifndef LIN_MAIN_H /* to interprete header file only once */
#define LIN_MAIN_H

#include "genLinConfig.h"

/* ===========================================================================
 *  Constants
 * ==========================================================================*/

#ifndef L_SET
   #define L_SET                       1u
#endif /* end #ifdef L_SET */

#ifndef L_RESET
   #define L_RESET                     0u
#endif /* end #ifdef L_RESET */

#define PUBLISH                        1u
#define SUBSCRIBE                      0u


#define UNCONDITIONAL                  0u
#define LIN_2_X                        20u
#define LIN_1_3                        13u

#if defined LIN_PROTOCOL_VERSION_2_0 || defined LIN_PROTOCOL_VERSION_2_1
   #define LIN_PROTOCOL_TYPE           20u
#else
   #define LIN_PROTOCOL_TYPE           13u
#endif


/* ===========================================================================
 *  Structures
 * ==========================================================================*/

/* ===========================================================================
 *  Function Prototypes
 * ==========================================================================*/

void lin_main_init(void);

/* ===========================================================================
 *  Variables
 * ==========================================================================*/

extern l_u8               g_lin_frame_index;
extern t_lin_prod_id      g_lin_prod_id;
extern t_Lin_Frame_Ctrl   g_lin_frame_ctrl[LIN_NUMBER_OF_FRAMES];
extern t_lin_status_word  g_lin_status_word;
extern l_u8               g_lin_active_pid; 
extern l_irqmask          g_lin_irqState;
extern l_u8               g_lin_frame_data_size;
#ifdef LIN_MASTER
extern t_lin_sched_data    g_lin_sched_data;
extern l_u16    g_activeScheduleIdx;
extern l_u8                g_ScheduleFrmIdx;
extern l_u8                g_nextScheduleFrmIdx;
extern l_u16               g_ScheduleIdx;
extern l_u16               g_sav_schedtab;
extern l_u8                g_sav_schedfrmidx;
extern l_u16               g_nextScheduleIdx;
extern l_u8                g_lin_config_status;
extern l_u8                g_lin_zero_schedule;
extern l_u8                g_ld_NodeConfRSID;
extern l_u8                g_ld_NodeConfErr;
extern l_u16              g_ld_timer_stmin;
extern l_u16              g_ld_timer_p2;
#ifdef LIN_2_X
extern l_u8          g_diag_status;
#endif /* end #ifdef LIN_2_X */
#endif /* end #ifdef LIN_MASTER */

#endif /* end #ifndef LIN_MAIN_H */
