/*****************************************************************************\
*                                                                             *
*                _  _               ___             _                         *
*               (_)| |__   _ __    / _ \ _ __ ___  | |__    /\  /\            *
*               | || '_ \ | '__|  / /_\/| '_ ` _ \ | '_ \  / /_/ /            *
*               | || | | || |    / /_\\ | | | | | || |_) |/ __  /             *
*               |_||_| |_||_|    \____/ |_| |_| |_||_.__/ \/ /_/              *
*                                                                             *
*  ihr GmbH                                                                   *
*  Airport Boulevard B210                                                     *
*  77836 Rheinmnster - Germany                                               *
*  http://www.ihr.de                                                          *
*  Phone +49(0) 7229-18475-0                                                  *
*  Fax   +49(0) 7229-18475-11                                                 *
*                                                                             *
*******************************************************************************
*                                                                             *
*                                                                             *
* (c) Alle Rechte bei IHR GmbH, auch fuer den Fall von Schutzrechts-          *
* anmeldungen. Jede Verfuegungsbefugnis, wie Kopier- und Weitergaberecht      *
* bei uns.                                                                    *
*                                                                             *
* (c) All rights reserved by IHR GmbH including the right to file             *
* industrial property rights. IHR GmbH retains the sole power of              *
* disposition such as reproduction or distribution.                           *
*                                                                             *
*                                                                             *
********************   Workfile:     lin_master_task.c     ********************
*                                                                             *
*  PROJECT-DESCRIPTION:  LIN Driver Protocol Layer                            *
*                                                                             *
*  FILE-DESCRIPTION:     All Routines to send LIN Header                      *
*                                                                             *
*                                                                             *
*******************************************************************************
*       Revision:      2.0                                                    *
*       Responsible:   B.Roegl                                                *
*       Creation date: 20/02/2007                                             *
*       Last Modtime:  10/07/2012                                             *
*                                                                             *
*  HISTORY:                                                                   *
*                                                                             *
*   Rev 1.0   20/02/2007 by B.Kroepfl                                         *
*             - Creation of the file                                          *
*   Rev 1.1   26/10/2010 by B.Roegl                                           *
*             - Variables and Function added for Eventtriggered Collison      *
*               Resolving                                                     *
*             - Fileheader changed                                            *
*   Rev 2.0   10/07/2012 by B.Roegl                                           *
*             - Updated File Header                                           *
*                                                                             *
\*****************************************************************************/

/* ===========================================================================
 *  Header files
 * ==========================================================================*/

#include "lin_hal.h"
#include "lin_main.h"
#include "lin_driver_api.h"

#include "lin_master_task.h"

/* ===========================================================================
 *  Global Variables
 * ==========================================================================*/

/* ===========================================================================
 *  Functions
 * ==========================================================================*/

/* ---------------------------------------------------------------------------
 *  void lin_master_task_tx_header( l_u8 lin_protocol_type, l_u8 pid_uc, l_u8 length)
 * --------------------------------------------------------------------------*/
/**
   @brief  Starts transmission of a frame header according to the running
           schedule table
   @pre    LIN driver initialized
   @param  void
   @retval void
*/
void lin_master_task_tx_header( l_u8 lin_protocol_type, l_u8 pid_uc, l_u8 length)
{
   /* transmit PID field */
   lin_hal_tx_header(lin_protocol_type,pid_uc,length);
}
