/*****************************************************************************\
*                                                                             *
*                _  _               ___             _                         *
*               (_)| |__   _ __    / _ \ _ __ ___  | |__    /\  /\            *
*               | || '_ \ | '__|  / /_\/| '_ ` _ \ | '_ \  / /_/ /            *
*               | || | | || |    / /_\\ | | | | | || |_) |/ __  /             *
*               |_||_| |_||_|    \____/ |_| |_| |_||_.__/ \/ /_/              *
*                                                                             *
*  ihr GmbH                                                                   *
*  Airport Boulevard B210                                                     *
*  77836 Rheinmnster - Germany                                               *
*  http://www.ihr.de                                                          *
*  Phone +49(0) 7229-18475-0                                                  *
*  Fax   +49(0) 7229-18475-11                                                 *
*                                                                             *
*******************************************************************************
*                                                                             *
*                                                                             *
* (c) Alle Rechte bei IHR GmbH, auch fuer den Fall von Schutzrechts-          *
* anmeldungen. Jede Verfuegungsbefugnis, wie Kopier- und Weitergaberecht      *
* bei uns.                                                                    *
*                                                                             *
* (c) All rights reserved by IHR GmbH including the right to file             *
* industrial property rights. IHR GmbH retains the sole power of              *
* disposition such as reproduction or distribution.                           *
*                                                                             *
*                                                                             *
********************   Workfile:      lin_type.h         **********************
*                                                                             *
*  PROJECT-DESCRIPTION:  LIN Driver Protocol Layer                            *
*                                                                             *
*  FILE-DESCRIPTION:  All defines special data types for the lin driver       *
*                                                                             *
*                                                                             *
*******************************************************************************
*       Revision:       1.0                                                   *
*       Responsible:    B. Roegl                                              *
*       Creation date:  18/02/2014                                            *
*       Last Modtime:   18/02/2014                                            *
*                                                                             *
*  HISTORY:                                                                   *
*                                                                             *
*    Rev 1.0   18/02/2014 by H. Spinner                                       *
*         - New Demo driver for TLE986x/7x                                    *
*                                                                             *
\*****************************************************************************/
/**
@file lin_type.h
@brief Header file for all lin files
*/

#ifndef LIN_TYPE_H /* to interprete header file only once */
#define LIN_TYPE_H

/* ===========================================================================
 *  Type Definitions
 * ==========================================================================*/

typedef unsigned char  l_bool;                                                           /* Boolean Datatype */
typedef unsigned char  l_u8;                                                             /* 8Bit Datatype */
typedef unsigned short l_u16;                                                            /* 16Bit Datatype */
typedef unsigned short l_irqmask, l_ioctl_op;                                            /* Datatypes for special LIN functions */
typedef unsigned short l_signal_handle, l_flag_handle, l_ifc_handle, l_schedule_handle;  /* Datatypes for special LIN functions */

/* ===========================================================================
 *  Structures
 * ==========================================================================*/

#if defined LIN_ENABLE_ASSIGN_FRAME_ID || defined LIN_ENABLE_RBI_RD_MSG_ID_PID
typedef union
{ 
   l_u8 reg[5];
   struct
   {
      struct
      {
         l_u8  lo;
         l_u8  hi;
      } msg_id;
      l_u8 pid;
      struct
      {
         l_u8  publisher               :1;
         l_u8  update_flag             :1;
         l_u8  res                     :2;
         l_u8  transfer_type           :4;
      } frame_type;
      l_u8     length;
   } frame;
} t_Lin_Frame_Ctrl;
#else
typedef union
{ 
   l_u8 reg[3];
   struct
   {
      l_u8   pid;
      struct
      {
         l_u8  publisher               :1;
         l_u8  update_flag             :1;
         l_u8  res                     :2;
         l_u8  transfer_type           :4;
      } frame_type;
      l_u8     length;
   } frame;
} t_Lin_Frame_Ctrl;
#endif /* end #ifdef LIN_ENABLE_ASSIGN_FRAME_ID */


typedef struct LIN_PROD_ID_s
{
   l_u8  NAD;
   l_u8  Supplier_lo;
   l_u8  Supplier_hi;
   l_u8  Function_lo;
   l_u8  Function_hi;
   l_u8  Variant;
   l_u8  Initial_NAD;
} t_lin_prod_id;

typedef union u_lin_status_word
{
   struct
   {
      l_u16   error_in_resp                 :1;
      l_u16   successful_transfer           :1;
      l_u16   overrun                       :1;
      l_u16   goto_sleep                    :1;
      l_u16   bus_activity                  :1;
      l_u16   event_triggerd_frame_coll     :1;
      l_u16   save_config                   :1;
      l_u16   reserved                      :1;
      l_u16   last_pid                      :8;
   } flag;
   l_u16                 reg;
} t_lin_status_word;

typedef struct LIN_TP_RX_CF_CTRL
{
   l_u8    rx_cf_on    :1;
   l_u8    tx_on       :1;
   l_u8    rx_t_out_on :1;
   l_u8    tx_t_out_on :1;
   l_u8    rx_cf_num   :4;
}t_lin_tp_tx_rx_ctrl;

typedef union
{
   struct
   {
      l_u16   rx_diag     :1;
      l_u16   res1        :1;
      l_u16   rx_func_nad :1;
      l_u16   res2        :1;
      l_u16   evttrgfrm   :1;
      l_u16   res3        :3;
   }flag;
   l_u16      reg         :8;
}t_lin_rx_ctrl;

typedef struct LIN_TP_STATUS
{
   l_u16    rx_stat        :4;
   l_u16    tx_stat        :4;
}t_lin_tp_status;

typedef struct LIN_SCHEDULE_TABLE_TYPE
{
   l_u16 pid;
   l_u16 frame_type;
   l_u16 frame_delay;
}t_lin_sched_table;

typedef t_lin_sched_table l_ScheduleTableList[];


typedef struct _lin_sched_data
{
   l_u8 lin_current_schedule;       /* store actual used schedule */
   l_u8 lin_next_frame;             /* store next frame to transfer */
   l_u16  lin_current_delay;        /* store delay until next transfer */
   l_u8 lin_next_PID;               /* store PID of next Frame */
} t_lin_sched_data;

typedef union l_node_diag_info
{
   l_u16    reg[6];
   struct
   {
      l_u16 supplier_id;
      l_u16 function_id;
      l_u8  variant;
      l_u8  number_of_frames;
      l_u8  init_NAD;
      l_u8  conf_NAD;
      l_u16 p2_min;
      l_u16 st_min;
   }data;
} t_l_node_diag_info;

typedef union l_conf_frame_info
{
   l_u8  reg[3];
   struct
   {
      l_u8  msg_id_lo;
      l_u8  msg_id_hi;
      l_u8  pid;
   }data;
} t_l_conf_frame_info;

typedef t_l_node_diag_info* t_l_node_diag_info_list; 

typedef t_l_conf_frame_info* t_l_conf_frm_info_list;

typedef union
{
   struct
   {
      l_u8   lo;
      l_u8   hi;
   }b;
   l_u16     word;
}l_word;

typedef union
{
   struct LIN_TIMEOUT_CTRL
   {
      l_u8   autobaud        :1;
      l_u8   frame           :1;
      l_u8   transm_ongoing  :1;
      l_u8   recept_started  :1;
      l_u8   startup_config  :1;
      l_u8   break_transm    :1;
      l_u8   syncf_transm    :1;
      l_u8   lock_init_uart  :1;
   } flag;
   l_u8 byte;
} t_lin_timeout_ctrl;

#endif /* end ifndef LIN_TYPE_H */
