/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** BR           B.Roegl                                                       **
** HS           H. Spinner                                                    **
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2014-02-18, HS:   New Demo driver for Infineon TLE9869             **
** V1.0.1: 2020-02-27, BG:   Updated abstract                                 **
** V1.2.1: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** LIN: Configuration as slave                                                **
********************************************************************************
** This example is working in combination with the LIN_MASTER example.        **
** On the master board, the Poti position is read out at ADC1-CH4, measuring  **
** Ch4 in sequencer mode.                                                     **
** This value is written into RefSpeed and sent to the slave board over LIN.  **
** P0.4 is set when the speed is bigger than 1000.                            **
*******************************************************************************/

#include "tle_device.h"
#include "linmain.h"

#include "genLinConfig.h"
#include "lin_driver_api.h"

__USED uint16 speed;

int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();
  LIN_LLD_Init();

  for (;;)
  {
    (void)WDT1_Service();
    LIN_LLD_Service();

    if (l_flg_tst_RefSpeed())
    {
       speed = l_u16_rd_RefSpeed();

      if (speed > 1000)
      {
        PORT_ChangePin(0x04, PORT_ACTION_SET);
      }
      else
      {
        PORT_ChangePin(0x04, PORT_ACTION_CLEAR);
      }
    }
  }
}

