/*****************************************************************************\
*                                                                             *
*                _  _               ___             _                         *
*               (_)| |__   _ __    / _ \ _ __ ___  | |__    /\  /\            *
*               | || '_ \ | '__|  / /_\/| '_ ` _ \ | '_ \  / /_/ /            *
*               | || | | || |    / /_\\ | | | | | || |_) |/ __  /             *
*               |_||_| |_||_|    \____/ |_| |_| |_||_.__/ \/ /_/              *
*                                                                             *
*  ihr GmbH                                                                   *
*  Airport Boulevard B210                                                     *
*  77836 Rheinmnster - Germany                                               *
*  http://www.ihr.de                                                          *
*  Phone +49(0) 7229-18475-0                                                  *
*  Fax   +49(0) 7229-18475-11                                                 *
*                                                                             *
*******************************************************************************
*                                                                             *
*                                                                             *
* (c) Alle Rechte bei IHR GmbH, auch fuer den Fall von Schutzrechts-          *
* anmeldungen. Jede Verfuegungsbefugnis, wie Kopier- und Weitergaberecht      *
* bei uns.                                                                    *
*                                                                             *
* (c) All rights reserved by IHR GmbH including the right to file             *
* industrial property rights. IHR GmbH retains the sole power of              *
* disposition such as reproduction or distribution.                           *
*                                                                             *
*                                                                             *
********************   Workfile:      lin_driver_api.c      *******************
*                                                                             *
*  PROJECT-DESCRIPTION:  LIN Driver Protocol Layer                            *
*                                                                             *
*  FILE-DESCRIPTION:     All routines for access from application to          *
*                       lin driver and callback function from lin driver      *
*                             to application                                  *
*                                                                             *
*******************************************************************************
*       Revision:       1.0                                                   *
*       Responsible:    B. Roegl                                              *
*       Creation date:  18/02/2014                                            *
*       Last Modtime:   18/02/2014                                            *
*                                                                             *
*  HISTORY:                                                                   *
*                                                                             *
*    Rev 1.0   18/02/2014 by H. Spinner                                       *
*         - New Demo driver                                                   *
*                                                                             *
\*****************************************************************************/
/**
@file    lin_driver_api.c
@brief   Application Program Interface for the LIN Driver access
*/

/* ===========================================================================
 *  Header files
 * ==========================================================================*/

#include "genLinConfig.h"
#include "lin_slave_task.h"

#include "lin_driver_api.h"

/* ===========================================================================
 *  Global Variables
 * ==========================================================================*/

/* ===========================================================================
 *  Functions
 * ==========================================================================*/

/* ---------------------------------------------------------------------------
 *  l_bool l_sys_init (void)
 * --------------------------------------------------------------------------*/
/**
   @brief  Initialise LIN driver system.
   @pre    MCU started
   @param  void
   @retval void
*/
l_bool l_sys_init (void)
{
   lin_main_init();
   return 0u;
}


/* ---------------------------------------------------------------------------
 *  l_bool l_ifc_init(void)
 * --------------------------------------------------------------------------*/
/**
   @brief  Initialize LIN interface.
   @pre    LIN driver initialized
   @param  void
   @retval State of initialization
*/
l_bool l_ifc_init(void)
{
   return 0u;
}

/* ---------------------------------------------------------------------------
 *  l_u16 l_ifc_read_status(void)
 * --------------------------------------------------------------------------*/
/**
   @brief  Get status information from LIN driver.
   @pre    LIN driver initialized
   @param  void
   @retval LIN_status word        MSB contains last PID information
                                  LSB contains status flags
   @see    LIN 2.0 and LIN 2.1 specification
*/
l_u16 l_ifc_read_status(void)
{
   l_u16 loc_temp;

   loc_temp = g_lin_status_word.reg;
   g_lin_status_word.reg = 0u;
   return loc_temp;
}

#ifdef LIN_MASTER
/* ---------------------------------------------------------------------------
 *  l_ifc_goto_sleep(void)
 * --------------------------------------------------------------------------*/
/**
   @brief  Create a goto sleep master request.
   @pre    LIN driver initialized
   @param  void
   @retval void
*/
void l_ifc_goto_sleep(void)
{
   /* create goto sleep message and transmit at next tick */
}
#endif
