/*****************************************************************************\
*                                                                             *
*                _  _               ___             _                         *
*               (_)| |__   _ __    / _ \ _ __ ___  | |__    /\  /\            *
*               | || '_ \ | '__|  / /_\/| '_ ` _ \ | '_ \  / /_/ /            *
*               | || | | || |    / /_\\ | | | | | || |_) |/ __  /             *
*               |_||_| |_||_|    \____/ |_| |_| |_||_.__/ \/ /_/              *
*                                                                             *
*  ihr GmbH                                                                   *
*  Airport Boulevard B210                                                     *
*  77836 Rheinmnster - Germany                                               *
*  http://www.ihr.de                                                          *
*  Phone +49(0) 7229-18475-0                                                  *
*  Fax   +49(0) 7229-18475-11                                                 *
*                                                                             *
*******************************************************************************
*                                                                             *
*                                                                             *
* (c) Alle Rechte bei IHR GmbH, auch fuer den Fall von Schutzrechts-          *
* anmeldungen. Jede Verfuegungsbefugnis, wie Kopier- und Weitergaberecht      *
* bei uns.                                                                    *
*                                                                             *
* (c) All rights reserved by IHR GmbH including the right to file             *
* industrial property rights. IHR GmbH retains the sole power of              *
* disposition such as reproduction or distribution.                           *
*                                                                             *
*                                                                             *
********************   Workfile:      lin_type.h         **********************
*                                                                             *
*  PROJECT-DESCRIPTION:  LIN Driver Protocol Layer                            *
*                                                                             *
*  FILE-DESCRIPTION:  All defines special data types for the lin driver       *
*                                                                             *
*                                                                             *
*******************************************************************************
*       Revision:       1.0                                                   *
*       Responsible:    B. Roegl                                              *
*       Creation date:  18/02/2014                                            *
*       Last Modtime:   18/02/2014                                            *
*                                                                             *
*  HISTORY:                                                                   *
*                                                                             *
*    Rev 1.0   18/02/2014 by H. Spinner                                       *
*         - New Demo driver                                                   *
*                                                                             *
\*****************************************************************************/
/**
@file lin_type.h
@brief Header file for all lin files
*/

#ifndef LIN_TYPE_H /* to interprete header file only once */
#define LIN_TYPE_H

/* ===========================================================================
 *  Type Definitions
 * ==========================================================================*/

typedef unsigned char  l_bool;                                                           /* Boolean Datatype */
typedef unsigned char  l_u8;                                                             /* 8Bit Datatype */
typedef unsigned short l_u16;                                                            /* 16Bit Datatype */
typedef unsigned short l_irqmask, l_ioctl_op;                                            /* Datatypes for special LIN functions */
typedef unsigned short l_signal_handle, l_flag_handle, l_ifc_handle, l_schedule_handle;  /* Datatypes for special LIN functions */

/* ===========================================================================
 *  Structures
 * ==========================================================================*/

#if defined LIN_ENABLE_ASSIGN_FRAME_ID || defined LIN_ENABLE_RBI_RD_MSG_ID_PID
typedef union
{ 
   l_u8 reg[5];
   struct
   {
      struct
      {
         l_u8  lo;
         l_u8  hi;
      } msg_id;
      l_u8 pid;
      struct
      {
         l_u8  publisher               :1;
         l_u8  update_flag             :1;
         l_u8  res                     :2;
         l_u8  transfer_type           :4;
      } frame_type;
      l_u8     length;
   } frame;
} t_Lin_Frame_Ctrl;
#else
typedef union
{ 
   l_u8 reg[3];
   struct
   {
      l_u8   pid;
      struct
      {
         l_u8  publisher               :1;
         l_u8  update_flag             :1;
         l_u8  res                     :2;
         l_u8  transfer_type           :4;
      } frame_type;
      l_u8     length;
   } frame;
} t_Lin_Frame_Ctrl;
#endif /* end #ifdef LIN_ENABLE_ASSIGN_FRAME_ID */


typedef struct LIN_PROD_ID_s
{
   l_u8  NAD;
   l_u8  Supplier_lo;
   l_u8  Supplier_hi;
   l_u8  Function_lo;
   l_u8  Function_hi;
   l_u8  Variant;
   l_u8  Initial_NAD;
} t_lin_prod_id;

typedef union u_lin_status_word
{
   struct
   {
      l_u16   error_in_resp                 :1;
      l_u16   successful_transfer           :1;
      l_u16   overrun                       :1;
      l_u16   goto_sleep                    :1;
      l_u16   bus_activity                  :1;
      l_u16   event_triggerd_frame_coll     :1;
      l_u16   save_config                   :1;
      l_u16   reserved                      :1;
      l_u16   last_pid                      :8;
   } flag;
   l_u16                 reg;
} t_lin_status_word;


typedef union
{
   struct LIN_TIMEOUT_CTRL
   {
      l_u8   autobaud        :1;
      l_u8   frame           :1;
      l_u8   transm_ongoing  :1;
      l_u8   recept_started  :1;
      l_u8   startup_config  :1;
      l_u8   lock_init_uart  :1;
      l_u8   res             :2;
   } flag;
   l_u8 byte;
} t_lin_timeout_ctrl;

#endif /* end ifndef LIN_TYPE_H */
