/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** DM           Daniel Mysliwitz                                              **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2015-09-22, DM:   Initial version                                  **
** V1.0.1: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

#ifndef NVM_FUNC_H
#define NVM_FUNC_H

/*******************************************************************************
**                           Global Type Definitions                          **
*******************************************************************************/
/* return value typedef for the local Program Page function */
typedef union
{
  uint16  reg;
  struct
  {
    uint16 GlobFail   :  1;
    uint16            :  3;
    uint16 VerifyFail :  1;
    uint16 EmergExit  :  1;
    uint16 SparePgFail:  1;
    uint16 ExecFail   :  1;
    uint16 VS2lowFail :  1;
    uint16 RetryFail  :  1;
    uint16 DFlashDis  :  1;
  } bit;
} TlocProgramPage;

/* return value typedef for the local Program Page function */
typedef union
{
  uint16  reg;
  struct
  {
    uint16 GlobFail   :  1;
    uint16            :  6;
    uint16 ExecFail   :  1;
    uint16 VS2lowFail :  1;
    uint16 RetryFail  :  1;
  } bit;
} TlocEraseSector;

/* return value typedef for the local Erase Sector function */
typedef union
{
  uint8   reg;
  struct
  {
    uint8 EraseFail:  1;
    uint8          :  6;
    uint8 ExecFail :  1;
  } bit;
} TUser_Erase_Sector;

/*******************************************************************************
**                        Global Function Declarations                        **
*******************************************************************************/
TlocEraseSector locEraseSector(uint32 sector_address);
TlocProgramPage locProgramPage(uint32 addr, uint8 *buf);
TUser_MAPRAM_Init locMapRAM_Init(void);


#endif
