/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

#include "tle_device.h"

#if defined(__ARMCC_VERSION)
  void RAM_Branch_Function(void) __attribute__ ((used));
  int (* const myUSER_NVMRDY)(void) __attribute__((used));
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma location="RAMBranch"
#endif
  
int (* const myUSER_NVMRDY)(void) = (int (*)(void))addr_USER_NVMRDY;

/* This is an example for a function called by the NVM operation using RAM branching. */
/* This function is checking if the NVM module is ready. */
/* As long as the NVM module is not ready, the LED1 will be toggled. */
#if defined(__IAR_SYSTEMS_ICC__)
  #pragma location="RAMBranch"
#endif
void RAM_Branch_Function(void)
{
  int i;

  while (myUSER_NVMRDY() == 1u)
  {
    PORT->P0_DATA.reg = 0x02;

    for (i = 0; i < 10; i++);

    PORT->P0_DATA.reg = 0x00;
  }
}
