/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2020-02-27, BG:   Initial version of revision history              **
** V1.0.3: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** Flash: Program a page with RAM branching                                   **
********************************************************************************
** During the page programming, the function RAM_Branch_Function() is executed**
*******************************************************************************/

#include "tle_device.h"
#include "eval_board.h"

/* Allocate one flash page in RAM */
__USED static uint8 TargetData[FlashPageSize];
__USED static int NVM_Error;

int main(void)
{
  uint32 i;
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();

  /* Fill up the TargetData array with housenumbers */
  for (i = 0; i < FlashPageSize; i++)
  {
    TargetData[i] = (uint8) i;
  }

  /* Call ProgramPage with the RAM BRANCH feature activated */
  /* The function RAM_Branch_Function(void) will be called during NVM operation */
  NVM_Error = ProgramPage(DataFlashStart, TargetData, 1, 0, 0);

  /* Check if the programming worked fine */
  if (NVM_Error == 0u)
  {
    /* Data in the page 0 of Data Flash is correct */
    PORT_ChangePin(LED1, PORT_ACTION_SET);
  }
  else
  {
    /* An error happened during ProgramPage */
    PORT_ChangePin(LED7, PORT_ACTION_SET);
  }

  for (;;)
  {
    (void)WDT1_Service();
  }
}
