/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2020-02-27, BG:   Initial version of revision history              **
** V1.0.2: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** PMU: Power saving - Sleep mode, wake up by MON                             **
********************************************************************************
** Send the device into SleepMode by pulling P1.0 to high.                    **
** The device wakes up by MON (configured by default).                        **
*******************************************************************************/

#include "tle_device.h"
#include "eval_board.h"

int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();

  for (;;)
  {
    (void)WDT1_Service();

    /* If P1.0 is set high, ... */
    if (PORT_ReadPin(0x10) == 1)
    {
      /* ... the device enters sleep mode */
      SCU_EnterSleepMode();
    }
  }
}
