/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2020-02-27, BG:   Initial version of revision history              **
** V1.0.1: 2021-07-19, BG:   Removed warnings for ARMCC v6 compiler           **
** V1.1.1: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** PMU: VDDEXT enable and diagnostic function                                 **
********************************************************************************
** VDDEXT is enabled (5V at VDDEXT pin)                                       **
** LED1 will be set upon VDDEXT short to GND                                  **
** LED2 will be set upon overvoltage at VDDEXT                                **
** LED3 will be set upon overload at VDDEXT                                   **
** High Level on P1.0 clears LEDs and switches on VDDEXT again                **
*******************************************************************************/

#include "tle_device.h"
#include "eval_board.h"

void VDDEXT_Short_Diag_Callback(void);
void VDDEXT_Over_Volt_Diag_Callback(void);
void VDDEXT_Over_Load_Diag_Callback(void);

__USED static uint8 bVDDEXT_Fail;


int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();
  /* Disable VAREF, as VAREF is connected to VDDEXT on the evalboard */
  MF->REF2_CTRL.bit.VREF5V_PD_N = 0u;
  /* Initialize VDDEXT fail indication */
  bVDDEXT_Fail = 0;

  for (;;)
  {
    (void)WDT1_Service();

    /* Check if VDDEXT has failed */
    if (bVDDEXT_Fail == 1u)
    {
      /* Check if clear request for VDDEXT is active */
      if (PORT_ReadPin(0x10) == 1u)
      {
        /* Reset error LEDs */
        PORT_ChangePin(LED1, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED2, PORT_ACTION_CLEAR);
        PORT_ChangePin(LED3, PORT_ACTION_CLEAR);
        /* Clear VDDEXT error flags */
        PMU_VDDEXT_Short_Clr();
        /* Reset VDDEXT fail indication variable */
        bVDDEXT_Fail = 0u;
      }
    }
  }
}


/* Callback function on short diagnosis */
void VDDEXT_Short_Diag_Callback(void)
{
  /* Apply a delay of approx. 150us to give error flags in VDDEXT_CTRL time to show up */
  Delay_us(150);
  /* Set error LED1 */
  PORT_ChangePin(LED1, PORT_ACTION_SET);
  /* Set VDDEXT fail indication variable */
  bVDDEXT_Fail = 1u;
}

/* Callback function on overvoltage diagnosis */
void VDDEXT_Over_Volt_Diag_Callback(void)
{
  /* Apply a delay of approx. 150us to give error flags in VDDEXT_CTRL time to show up */
  Delay_us(150);
  /* Set error LED2 */
  PORT_ChangePin(LED2, PORT_ACTION_SET);
  /* Set VDDEXT fail indication variable */
  bVDDEXT_Fail = 1u;
}

/* Callback function on overload diagnosis */
void VDDEXT_Over_Load_Diag_Callback(void)
{
  /* Apply a delay of approx. 150us to give error flags in VDDEXT_CTRL time to show up */
  Delay_us(150);
  /* Set error LED3 */
  PORT_ChangePin(LED3, PORT_ACTION_SET);
  /* Set VDDEXT fail indication variable */
  bVDDEXT_Fail = 1u;
}
