/**
 * @cond
 ***********************************************************************************************************************
 *
 * Copyright (c) 2018, Infineon Technologies AG
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,are permitted provided that the
 * following conditions are met:
 *
 *   Redistributions of source code must retain the above copyright notice, this list of conditions and the  following
 *   disclaimer.
 *
 *   Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the
 *   following disclaimer in the documentation and/or other materials provided with the distribution.
 *
 *   Neither the name of the copyright holders nor the names of its contributors may be used to endorse or promote
 *   products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE  FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT  OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 **********************************************************************************************************************/
#ifndef ADC2_DEFINES_H
#define ADC2_DEFINES_H

/* XML Version 2.4.1 */
#define ADC2_XML_VERSION (20401)

#define ADC2_CH0_LOTH_VOLT (5.078)

#define ADC2_CH0_UPTH_VOLT (16.88)

#define ADC2_CH1_LOTH_VOLT (5.78)

#define ADC2_CH1_UPTH_VOLT (17.30)

#define ADC2_CH2_LOTH_VOLT (5.78)

#define ADC2_CH2_UPTH_VOLT (23.4)

#define ADC2_CH3_LOTH_VOLT (5.2)

#define ADC2_CH3_UPTH_VOLT (35.00)

#define ADC2_CH4_LOTH_VOLT (5.078)

#define ADC2_CH4_UPTH_VOLT (16.88)

#define ADC2_CH5_LOTH_VOLT (4.50)

#define ADC2_CH5_UPTH_VOLT (5.50)

#define ADC2_CH6_LOTH_VOLT (4.50)

#define ADC2_CH6_UPTH_VOLT (5.50)

#define ADC2_CH7_LOTH_VOLT (1.01)

#define ADC2_CH7_UPTH_VOLT (1.30)

#define ADC2_CH8_LOTH_VOLT (1.35)

#define ADC2_CH8_UPTH_VOLT (1.60)

#define ADC2_CH9_LOTH_DEG (150.00)

#define ADC2_CH9_UPTH_DEG (200.00)

#define ADC2_CLK (12.5)

#define ADC2_CNT0_3_LOWER (0x0u) /*decimal 0*/

#define ADC2_CNT0_3_UPPER (0x0u) /*decimal 0*/

#define ADC2_CNT4_5_LOWER (0x0u) /*decimal 0*/

#define ADC2_CNT4_5_UPPER (0x0u) /*decimal 0*/

#define ADC2_CONV_TIME (2.64)

#define ADC2_CTRL1 (0x0u) /*decimal 0*/

#define ADC2_CTRL2 (0x700u) /*decimal 1792*/

#define ADC2_CTRL4 (0x0u) /*decimal 0*/

#define ADC2_CTRL_STS (0x0u) /*decimal 0*/

#define ADC2_FILTCOEFF0_5 (0x0u) /*decimal 0*/

#define ADC2_FILT_LO_CTRL (0x0u) /*decimal 0*/

#define ADC2_FILT_UP_CTRL (0x0u) /*decimal 0*/

#define ADC2_MMODE0_5 (0x0u) /*decimal 0*/

#define ADC2_TH0_3_LOWER (0x192F423Au) /*decimal 422527546*/

#define ADC2_TH0_3_UPPER (0xA9C0C8C3u) /*decimal 2847983811*/

#define ADC2_TH4_5_LOWER (0x9B29u) /*decimal 39721*/

#define ADC2_TH4_5_UPPER (0xBD8Au) /*decimal 48522*/

#define ADC2_TH6_9_LOWER (0xD6D59FCFu) /*decimal 3604324303*/

#define ADC2_TH6_9_UPPER (0xEEFCCDFDu) /*decimal 4009545213*/

#endif /* ADC2_DEFINES_H */
