/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2020-02-27, BG:   Initial version of revision history              **
** V1.0.2: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** SCU: PLL setting                                                           **
********************************************************************************
** Set different values for PLL parameters in Config Wizard.                  **
** Check system frequency at "Clock Out Pin Select" (P0.4 in Config Wizard).  **
** => T_SYS = (P0.4 value [s] * 2 [if DC is 50%]) / Clock Out Divider         **
** => fSYS = 1 / T_SYS                                                        **
*******************************************************************************/

#include "tle_device.h"

int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();

  for (;;)
  {
    (void)WDT1_Service();
  }
}
