/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2020-02-27, BG:   Initial version of revision history              **
** V1.0.1: 2021-07-19, BG:   Removed warnings for ARMCC v6 compiler           **
** V1.1.1: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** SSC1/SSC2: Send data from SSC1 to SSC2                                     **
********************************************************************************
** Both SSC operate at 1Mbaud. SSC1 sends one byte at P0.3 (CLK), P0.2 (MTSR).**
** SSC2 receives one byte at P1.0 (CLK), P1.1 (MTSR). Connect clock signals   **
** and data signal from SSC1 and SSC2 together.                               **
** LED7 is set on receive.                                                    **
*******************************************************************************/

#include "tle_device.h"
#include "eval_board.h"

void Data_Received(void);


int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();
  SSC1_SendWord((uint16) 0xAAAA);

  for (;;)
  {
    (void)WDT1_Service();
  }
}


void Data_Received(void)
{
  uint16 data = SSC2_ReadWord();

  if (data == (uint16) 0x00AA)
  {
    PORT_ChangePin(LED7, PORT_ACTION_SET);
  }
}
