/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2020-02-27, BG:   Initial version of revision history              **
** V1.0.1: 2021-07-19, BG:   Removed warnings for ARMCC v6 compiler           **
** V1.1.1: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** Timer2: Blinky                                                             **
********************************************************************************
** Timer2 is configured as timer with a runtime of 200ms. For each overflow,  **
** the interrupt routine LED1_Blink is called and toggles LED1.               **
*******************************************************************************/

#include "tle_device.h"
#include "eval_board.h"

void LED1_Blink(void);


int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();
  /* Start Timer2 */
  TIMER2_Start();

  for (;;)
  {
    (void)WDT1_Service();
  }
}


/* Callback funtion for each Timer2 overflow */
void LED1_Blink(void)
{
  PORT_ChangePin(LED1, PORT_ACTION_TOGGLE);
}
