/*
 ***********************************************************************************************************************
 *
 * Copyright (c) Infineon Technologies AG
 * All rights reserved.
 *
 * The applicable license agreement can be found at this pack's installation directory in the file
 * license/IFX_SW_Licence_MOTIX_LITIX.txt
 *
 **********************************************************************************************************************/

/*******************************************************************************
**                             Author(s) Identity                             **
********************************************************************************
** Initials     Name                                                          **
** ---------------------------------------------------------------------------**
** BG           Blandine Guillot                                              **
** JO           Julia Ott                                                     **
*******************************************************************************/

/*******************************************************************************
**                          Revision Control History                          **
********************************************************************************
** V1.0.0: 2020-02-27, BG:   Initial version of revision history              **
** V1.1.1: 2025-03-13, JO:   EP-1580: Aligned example with TLE987x code       **
*******************************************************************************/

/*******************************************************************************
**                                  Abstract                                  **
********************************************************************************
** UART2: Send example                                                        **
********************************************************************************
** In a terminal window set up a serial connection @115.2kBaud through the    **
** debugger port.                                                             **
** Send "Hello World!" through the STDIO @ 115200 baud                        **
** STDIO uses UART2 P1.1/P1.2 through on-board debugger and VCOM              **
*******************************************************************************/

#include "tle_device.h"
#include <stdio.h>

int main(void)
{
  /* Initialization of hardware modules based on Config Wizard configuration */
  TLE_Init();
  printf("Hello World!\n");

  for (;;)
  {
    (void)WDT1_Service();
  }
}
